/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.ml;

import de.unistuttgart.quadrama.core.api.Origin;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class MapBackAnnotations
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ANNOTATION_TYPE = "Annotation type";
    public static final String PARAM_VIEW_NAME = "View name";
    @ConfigurationParameter(name="View name")
    String viewName;
    @ConfigurationParameter(name="Annotation type")
    String annotationClassName;
    Class<Annotation> annotationClass;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            Class<?> cl = Class.forName(this.annotationClassName);
            this.annotationClass = cl;
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            JCas other = jcas.getView(this.viewName);
            for (Origin origin : JCasUtil.select((JCas)other, Origin.class)) {
                int relativ = -origin.getBegin() + origin.getOffset();
                for (Annotation src : JCasUtil.selectCovered(this.annotationClass, (AnnotationFS)origin)) {
                    Annotation tgt = AnnotationFactory.createAnnotation((JCas)jcas, (int)(src.getBegin() + relativ), (int)(src.getEnd() + relativ), this.annotationClass);
                    for (Feature feature : src.getType().getFeatures()) {
                        if (!feature.getRange().isPrimitive() || !feature.getRange().getName().equalsIgnoreCase("uima.cas.String")) continue;
                        tgt.setStringValue(feature, src.getStringValue(feature));
                    }
                }
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

