/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.cr;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiReader;
import de.tudarmstadt.ukp.dkpro.core.io.xmi.XmiWriter;
import de.unistuttgart.ims.drama.api.FigureMention;
import de.unistuttgart.ims.drama.api.Speech;
import de.unistuttgart.ims.drama.core.cr.ClearTkMentionAnnotator;
import de.unistuttgart.ims.drama.core.cr.PrepareEvaluation;
import de.unistuttgart.ims.entitydetection.api.TrainingArea;
import de.unistuttgart.ims.uimautil.ClearAnnotation;
import de.unistuttgart.ims.uimautil.ContextWindowAnnotator;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.eval.Evaluation_ImplBase;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.jar.Train;
import org.cleartk.ml.mallet.MalletCrfStringOutcomeDataWriter;

public class MentionDetectionEvaluation
extends Evaluation_ImplBase<File, AnnotationStatistics<String>> {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> trainFiles = Arrays.asList(options.getTrainDirectory().listFiles());
        System.err.println(trainFiles.toString());
        MentionDetectionEvaluation evaluator = new MentionDetectionEvaluation(options.getModelsDirectory());
        AnnotationStatistics crossValidationStats = (AnnotationStatistics)evaluator.trainAndTest(trainFiles, trainFiles);
        System.err.println("Cross Validation Results:");
        System.err.print(crossValidationStats);
        System.err.println();
        System.err.println(crossValidationStats.confusions());
        System.err.println();
    }

    public MentionDetectionEvaluation(File baseDirectory) {
        super(baseDirectory);
    }

    protected CollectionReader getCollectionReader(List<File> files) throws Exception {
        return CollectionReaderFactory.createReader(XmiReader.class, (Object[])new Object[]{"sourceLocation", files.get(0).getParent() + "/*.xmi"});
    }

    public void train(CollectionReader collectionReader, File outputDirectory) throws Exception {
        AggregateBuilder aggregate = new AggregateBuilder();
        aggregate.add(AnalysisEngineFactory.createEngineDescription(ContextWindowAnnotator.class, (Object[])new Object[]{"Base Annotation", FigureMention.class, "Context class", Speech.class, "Target Annotation", TrainingArea.class}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(ClearTkMentionAnnotator.class, (Object[])new Object[]{"isTraining", true, "outputDirectory", outputDirectory, "dataWriterClassName", MalletCrfStringOutcomeDataWriter.class}), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
        Logger malletLogger = Logger.getLogger("cc.mallet");
        malletLogger.setLevel(Level.WARNING);
        Logger likelihoodLogger = Logger.getLogger("cc.mallet.fst.CRFOptimizableByLabelLikelihood");
        likelihoodLogger.setLevel(Level.INFO);
        Train.main((File)outputDirectory, (String[])new String[0]);
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File modelDirectory) throws Exception {
        String defaultViewName = "_InitialView";
        String goldViewName = "GoldView";
        AggregateBuilder aggregate = new AggregateBuilder();
        aggregate.add(AnalysisEngineFactory.createEngineDescription(PrepareEvaluation.class, (Object[])new Object[]{"Gold View", "GoldView"}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(ClearTkMentionAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", JarClassifierBuilder.getModelJarFile((File)modelDirectory)}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(ClearAnnotation.class, (Object[])new Object[]{"Type to Remove", TrainingArea.class}), new String[0]);
        aggregate.add(AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"targetLocation", "target/debug/", "useDocumentId", true}), new String[0]);
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator iter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregate.createAggregate()});
        while (iter.hasNext()) {
            JCas jCas = iter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldMentions = JCasUtil.select((JCas)goldView, FigureMention.class);
            Collection systemMentions = JCasUtil.select((JCas)systemView, FigureMention.class);
            stats.add(goldMentions, systemMentions);
        }
        return stats;
    }

    public static interface Options {
        @Option(longName={"train-dir"}, description="Specify the directory containing the training documents.  This is used for cross-validation and for training in a holdout set evaluator. When we run this example we point to a directory containing training data from the MASC-1.0.3 corpus - i.e. a directory called 'MASC-1.0.3/data/written'", defaultValue={"src/main/resources/training"})
        public File getTrainDirectory();

        @Option(longName={"models-dir"}, description="specify the directory in which to write out the trained model files", defaultValue={"target/models"})
        public File getModelsDirectory();
    }
}

