/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.drama.core.cr;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import de.unistuttgart.ims.drama.api.FigureMention;
import de.unistuttgart.ims.entitydetection.api.TrainingArea;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkSequenceAnnotator;
import org.cleartk.ml.Instances;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.function.FeatureFunctionExtractor;

public class ClearTkMentionAnnotator
extends CleartkSequenceAnnotator<String> {
    FeatureExtractor1<Token> extractor;
    CleartkExtractor<Token, Token> contextExtractor;
    BioChunking<Token, FigureMention> chunking;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.extractor = new CombinedExtractor1((FeatureExtractor1)new FeatureFunctionExtractor((FeatureExtractor1)new CoveredTextExtractor(), new FeatureFunction[]{new CharacterCategoryPatternFunction(CharacterCategoryPatternFunction.PatternType.REPEATS_MERGED)}), (FeatureExtractor1)new TypePathExtractor(Token.class, "pos/PosValue"));
        this.contextExtractor = new CleartkExtractor(Token.class, this.extractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2), new CleartkExtractor.Following(1)});
        this.chunking = new BioChunking(Token.class, FigureMention.class);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Map index = JCasUtil.indexCovering((JCas)jCas, Sentence.class, TrainingArea.class);
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            if (!index.containsKey(sentence) || ((Collection)index.get(sentence)).isEmpty()) continue;
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            ArrayList featureLists = new ArrayList();
            for (Token token : tokens) {
                ArrayList features = new ArrayList();
                features.addAll(this.extractor.extract(jCas, (Annotation)token));
                features.addAll(this.contextExtractor.extract(jCas, (Annotation)token));
                featureLists.add(features);
            }
            if (this.isTraining()) {
                List namedEntityMentions = JCasUtil.selectCovered((JCas)jCas, FigureMention.class, (AnnotationFS)sentence);
                List outcomes = this.chunking.createOutcomes(jCas, tokens, namedEntityMentions);
                this.dataWriter.write(Instances.toInstances((List)outcomes, featureLists));
                continue;
            }
            try {
                List outcomes = this.classifier.classify(featureLists);
                this.chunking.createChunks(jCas, tokens, outcomes);
            }
            catch (Exception exception) {}
        }
    }
}

