/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter<K>
extends HashMap<K, Integer> {
    private static final long serialVersionUID = 1L;

    public Counter() {
    }

    public Counter(Counter<K> c) {
        for (Object k : c.keySet()) {
            this.put(k, c.get(k));
        }
    }

    public void add(K k) {
        this.add(k, 1);
    }

    public void add(K k, int i) {
        if (!super.containsKey(k)) {
            super.put(k, i);
        } else {
            super.put(k, (Integer)super.get(k) + i);
        }
    }

    public void subtract(K k) {
        if (!super.containsKey(k)) {
            super.put(k, -1);
        } else {
            super.put(k, (Integer)super.get(k) - 1);
        }
    }

    public void addAll(Collection<? extends K> arg) {
        for (K k : arg) {
            this.add(k);
        }
    }

    public void subtractAll(Collection<? extends K> arg) {
        for (K k : arg) {
            this.subtract(k);
        }
    }

    public Pair<Integer, Set<K>> getMax() {
        HashSet set = new HashSet();
        int r = Integer.MIN_VALUE;
        for (Object k : this.keySet()) {
            int i = this.get(k);
            if (i > r) {
                set.clear();
                set.add(k);
                r = i;
                continue;
            }
            if (i != r) continue;
            set.add(k);
        }
        return new Pair((Object)r, set);
    }

    public Pair<Integer, Set<K>> getMin() {
        HashSet set = new HashSet();
        int r = Integer.MAX_VALUE;
        for (Object k : this.keySet()) {
            int i = this.get(k);
            if (i < r) {
                set.clear();
                set.add(k);
                r = i;
                continue;
            }
            if (i != r) continue;
            set.add(k);
        }
        return new Pair((Object)r, set);
    }

    public int getHighestCount() {
        return (Integer)this.getMax().getFirst();
    }

    public Set<K> getKeysWithMaxCount() {
        return (Set)this.getMax().getSecond();
    }

    @Override
    public Integer get(Object k) {
        if (super.containsKey(k)) {
            return (Integer)super.get(k);
        }
        return 0;
    }

    public static Counter<String> fromString(Reader r) throws IOException {
        String l;
        Counter<String> c = new Counter<String>();
        BufferedReader buf = new BufferedReader(r);
        while ((l = buf.readLine()) != null) {
            if (l == null) continue;
            String[] line = l.split("\t");
            c.add(line[0], Integer.valueOf(line[1]));
        }
        buf.close();
        return c;
    }
}

