/*
 * Decompiled with CFR 0.152.
 */
package de.unistuttgart.ims.cleartkutil;

import java.util.Formatter;
import java.util.Locale;
import org.cleartk.eval.util.ConfusionMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearTkUtil {
    public static <T extends Comparable<? super T>> String toCmdLine(ConfusionMatrix<T> cm) {
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, Locale.US);
        builder.append("Predicted Class \u2192\n");
        builder.append("\u2193 Actual Class\n");
        formatter.format("%5s ", " ");
        for (Comparable predicted : cm.getClasses()) {
            formatter.format("%5s ", predicted);
        }
        formatter.format("%5s\n", "Total");
        for (Comparable actual : cm.getClasses()) {
            builder.append(String.format("%5s ", actual));
            for (Comparable predicted : cm.getClasses()) {
                formatter.format("%5d ", cm.getCount(actual, predicted));
            }
            formatter.format("%5d\n", cm.getActualTotal(actual));
        }
        formatter.format("%5s ", "Total");
        for (Comparable predicted : cm.getClasses()) {
            formatter.format("%5d ", cm.getPredictedTotal(predicted));
        }
        builder.append("\n");
        formatter.flush();
        formatter.close();
        return builder.toString();
    }
}

