package de.uniks.networkparser.list;

/*
NetworkParser
The MIT License
Copyright (c) 2010-2016 Stefan Lindel https://www.github.com/fujaba/NetworkParser/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/**
 * Enum for Sortdirection.
 *
 * @author Stefan Lindel
 *
 */

public enum SortingDirection {
	/**
	 * The Sortdirection Options. ASC from small to BIG and DESC from BIG to small
	 */
	ASC(1), DESC(-1);

	/** The Variable of Direction. */
	private int direction;

	SortingDirection() {
	}

	/**
	 * @param value The new Sortdirection
	 */
	SortingDirection(int value) {
		this.setDirection(value);
	}

	/** @return The Sortdirection. */
	public int getDirection() {
		return direction;
	}

	/**
	 * Set the new Direction.
	 *
	 * @param value The new Sortdirection
	 */
	public void setDirection(int value) {
		this.direction = value;
	}

	/**
	 * Change Sort Direction.
	 *
	 * @return The new SortingDirection
	 */
	public SortingDirection changeDirection() {
		if (direction == SortingDirection.ASC.getDirection()) {
			return SortingDirection.DESC;
		} else if (direction == SortingDirection.DESC.getDirection()) {
			return SortingDirection.ASC;
		}
		return SortingDirection.ASC;
	}
}
