/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLEntityCreator;
import java.util.ArrayList;

public class XMLTokener
extends Tokener {
    public static final char ENDTAG = '/';
    private static final char[] TOKEN = new char[]{' ', '<', '/', '>'};
    public static final String CHILDREN = "<CHILDREN>";
    private SendableEntityCreator defaultFactory;
    private ArrayList<String> stopwords = new ArrayList();
    public static final EntityStringConverter SIMPLECONVERTER = new EntityStringConverter();
    private boolean isAllowQuote;

    public XMLTokener() {
        this.stopwords.add("?xml");
        this.stopwords.add("!--");
        this.stopwords.add("!DOCTYPE");
    }

    @Override
    public Object nextValue(Buffer buffer, BaseItem creator, boolean allowQuote, boolean allowDuppleMarks, char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                buffer.skip();
                CharacterBuffer v = this.nextString(buffer, new CharacterBuffer(), allowQuote, true, c);
                String g = EntityUtil.unQuote(v);
                return g;
            }
            case '<': {
                BaseItem element = creator.getNewList(false);
                if (element instanceof Entity) {
                    this.parseToEntity((Entity)element, buffer);
                }
                return element;
            }
        }
        return super.nextValue(buffer, creator, allowQuote, allowDuppleMarks, c);
    }

    @Override
    public boolean parseToEntity(Entity entity, Buffer buffer) {
        this.skipHeader(buffer);
        char c = buffer.getCurrentChar();
        if (c != '<') {
            c = buffer.nextClean(false);
        }
        if (!(entity instanceof XMLEntity)) {
            if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                throw new RuntimeException("Parse only XMLEntity");
            }
            return false;
        }
        XMLEntity xmlEntity = (XMLEntity)entity;
        if (c != '<') {
            if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                throw new RuntimeException("A XML text must begin with '<'");
            }
            return false;
        }
        xmlEntity.setType(buffer.nextToken(false, Buffer.STOPCHARSXMLEND).toString());
        while ((c = buffer.nextClean(true)) != '\u0000') {
            CharacterBuffer item;
            if (c == '>') {
                c = buffer.nextClean(false);
                if (c == '\u0000') {
                    return true;
                }
                if (c != '<') {
                    item = new CharacterBuffer();
                    buffer.nextString(item, false, false, '<');
                    char currentChar = buffer.getCurrentChar();
                    char nextChar = buffer.nextClean(false);
                    if (nextChar != '/') {
                        XMLEntity newChild = new XMLEntity();
                        newChild.withValue(item.toString());
                        xmlEntity.withChild(newChild);
                    } else {
                        xmlEntity.withValue(item.toString());
                    }
                    buffer.withLookAHead("" + currentChar + nextChar);
                    c = currentChar;
                }
            }
            if (c == '<') {
                char nextChar = buffer.getChar();
                if (nextChar == '/') {
                    buffer.skipTo('>', false);
                    break;
                }
                if (nextChar == '!') {
                    buffer.skipTo("-->", true, true);
                    buffer.skip();
                    continue;
                }
                buffer.withLookAHead(c);
                if (buffer.getCurrentChar() == '<') {
                    XMLEntity child = xmlEntity.getNewList(true);
                    if (!this.parseToEntity(child, buffer)) continue;
                    xmlEntity.with(child);
                    buffer.skip();
                    continue;
                }
                xmlEntity.withValue(this.nextString(buffer, new CharacterBuffer(), false, false, '<').toString());
                continue;
            }
            if (c == '/') {
                buffer.skip();
                break;
            }
            if (xmlEntity.sizeChildren() < 1) {
                Object value = this.nextValue(buffer, xmlEntity, false, true, c);
                if (value == null) {
                    return false;
                }
                String key = value.toString();
                if (key.length() <= 0) continue;
                xmlEntity.put(key, this.nextValue(buffer, xmlEntity, this.isAllowQuote, true, buffer.nextClean(false)));
                continue;
            }
            item = new CharacterBuffer();
            this.nextString(buffer, item, false, false, '<');
            XMLEntity newChild = new XMLEntity();
            newChild.withValue(item.toString());
            xmlEntity.withChild(newChild);
        }
        return true;
    }

    protected void skipEntity(Buffer buffer) {
        buffer.skipTo('>', false);
        buffer.nextClean(false);
    }

    public String skipHeader(Buffer buffer) {
        CharacterBuffer tag;
        boolean skip = false;
        do {
            if ((tag = buffer.getString(2)) == null) {
                tag = new CharacterBuffer();
                break;
            }
            if (tag.equals("<?")) {
                this.skipEntity(buffer);
                skip = true;
                continue;
            }
            if (tag.equals("<!")) {
                buffer.skipTo(">", true, true);
                buffer.nextClean(false);
                skip = true;
                continue;
            }
            skip = false;
        } while (skip);
        String item = tag.toString();
        if (buffer != null) {
            buffer.withLookAHead(item);
        }
        return item;
    }

    public String toString() {
        return "XMLTokener";
    }

    @Override
    public Entity newInstance() {
        return new XMLEntity();
    }

    @Override
    public EntityList newInstanceList() {
        return new XMLEntity();
    }

    public Object parse(XMLTokener tokener, Buffer buffer, MapEntity map) {
        this.parseAttribute(tokener, buffer, map);
        return this.parseChildren(tokener, buffer, map);
    }

    protected void parseAttribute(XMLTokener tokener, Buffer buffer, MapEntity map) {
        if (map == null) {
            return;
        }
        MapEntityStack stack = map.getStack();
        if (stack == null) {
            return;
        }
        Object entity = stack.getCurrentItem();
        SendableEntityCreator creator = stack.getCurrentCreator();
        if (entity != null) {
            char myChar;
            CharacterBuffer token = new CharacterBuffer();
            do {
                if (buffer.getCurrentChar() == ' ') {
                    buffer.getChar();
                }
                tokener.nextString(buffer, token, true, false, ' ', '=', '>', '/');
                myChar = buffer.getCurrentChar();
                if (myChar != '=') continue;
                String key = token.toString();
                token.clear();
                buffer.skip(2);
                tokener.nextString(buffer, token, true, false, '\"');
                String value = token.toString();
                token.clear();
                buffer.skip();
                creator.setValue(entity, key, value, "new");
                stack.setValue(key, value);
                myChar = buffer.getCurrentChar();
            } while (myChar != '>' && myChar != '\u0000' && myChar != '/');
        }
    }

    protected Object parseChildren(XMLTokener tokener, Buffer buffer, MapEntity map) {
        if (map == null) {
            return null;
        }
        MapEntityStack stack = map.getStack();
        if (stack == null) {
            return null;
        }
        Object entity = stack.getCurrentItem();
        SendableEntityCreator creator = stack.getCurrentCreator();
        if (creator == null) {
            return null;
        }
        if (buffer.skipTo("/>", false, false)) {
            if (buffer.getCurrentChar() == '/') {
                stack.popStack();
                buffer.getChar();
                tokener.nextToken(buffer, false, TOKEN);
                return entity;
            }
            char quote = '<';
            buffer.skip();
            CharacterBuffer valueItem = new CharacterBuffer();
            tokener.nextString(buffer, valueItem, false, false, quote);
            if (!valueItem.isEmptyCharacter()) {
                CharacterBuffer test = new CharacterBuffer();
                while (!buffer.isEnd()) {
                    if (buffer.getCurrentChar() == '<') {
                        test.with(buffer.getCurrentChar());
                        test.with(buffer.getChar());
                    }
                    if (buffer.getCurrentChar() == '/') {
                        CharacterBuffer endTag = tokener.nextToken(buffer, false, TOKEN);
                        String currentTag = stack.getCurrentTag();
                        if (currentTag == null || currentTag.equals(endTag.toString())) break;
                        valueItem.with(test);
                        valueItem.with(endTag);
                        valueItem.with(buffer.getCurrentChar());
                    } else if (test.length() > 0) {
                        valueItem.with(test);
                    } else {
                        char currentChar = buffer.getChar();
                        if (currentChar != '<') {
                            valueItem.with(currentChar);
                        }
                    }
                    test.clear();
                }
                if (entity != null) {
                    creator.setValue(entity, "value", valueItem.toString(), "new");
                }
                stack.setValue(".", valueItem.toString());
                stack.popStack();
                tokener.skipEntity(buffer);
                return entity;
            }
            if (buffer.getCurrentChar() == '<') {
                Object child;
                do {
                    if ((valueItem = this.parseEntity(tokener, buffer, map)) == null) {
                        if (buffer.getCurrentChar() == '/' && (valueItem = tokener.nextToken(buffer, false, '>')).equals(stack.getCurrentTag())) {
                            stack.popStack();
                            buffer.skip();
                        }
                        return entity;
                    }
                    if (!valueItem.isEmpty()) {
                        creator.setValue(entity, "value", valueItem.toString(), "new");
                        stack.setValue(".", valueItem.toString());
                        stack.popStack();
                        tokener.skipEntity(buffer);
                        return entity;
                    }
                    String childTag = stack.getCurrentTag();
                    child = this.parse(tokener, buffer, map);
                    if (childTag == null || child == null) continue;
                    creator.setValue(entity, childTag, child, CHILDREN);
                } while (child != null);
            }
        }
        return entity;
    }

    public CharacterBuffer parseEntity(XMLTokener tokener, Buffer buffer, MapEntity map) {
        CharacterBuffer tag;
        CharacterBuffer valueItem = new CharacterBuffer();
        if (tokener == null) {
            return valueItem;
        }
        boolean isEmpty = true;
        block0: do {
            if (buffer.getCurrentChar() != '<') {
                tokener.nextString(buffer, valueItem, false, false, '<');
                if (!valueItem.isEmpty()) {
                    valueItem.trim();
                    isEmpty = valueItem.isEmpty();
                }
            }
            if ((tag = tokener.nextToken(buffer, false, TOKEN)) == null) continue;
            for (String stopword : this.stopwords) {
                if (!tag.startsWith(stopword, 0, false)) continue;
                buffer.skipTo('>', false);
                buffer.skipTo('<', false);
                tag = null;
                continue block0;
            }
        } while (!buffer.isEnd() && tag == null);
        if (tag == null || tag.length() < 1) {
            return null;
        }
        if (tag.isEmpty() && isEmpty) {
            valueItem.clear();
        }
        IdMap idMap = this.getMap();
        SendableEntityCreator item = null;
        if (idMap != null) {
            item = idMap.getCreator(tag.toString(), false, null);
        }
        if (item != null && item instanceof SendableEntityCreatorTag) {
            this.addToStack((SendableEntityCreatorTag)item, tokener, tag, valueItem, map);
            return valueItem;
        }
        String startTag = tag.lastIndexOf('.') >= 0 ? tag.substring(0, tag.lastIndexOf('.')) : tag.toString();
        SimpleKeyValueList<String, SendableEntityCreatorTag> filter = new SimpleKeyValueList<String, SendableEntityCreatorTag>();
        if (idMap != null) {
            for (int i = 0; i < idMap.getCreators().size(); ++i) {
                String key = idMap.getCreators().getKeyByIndex(i);
                SendableEntityCreator value = idMap.getCreators().getValueByIndex(i);
                if (!key.startsWith(startTag) || !(value instanceof SendableEntityCreatorTag)) continue;
                filter.put(key, (SendableEntityCreatorTag)value);
            }
        }
        MapEntityStack stack = map.getStack();
        SendableEntityCreator defaultCreator = this.getDefaultFactory();
        SendableEntityCreatorTag creator = defaultCreator instanceof SendableEntityCreatorTag ? (SendableEntityCreatorTag)defaultCreator : new XMLEntityCreator();
        if (filter.size() < 1) {
            this.addToStack(creator, tokener, tag, valueItem, map);
            return valueItem;
        }
        StringBuilder sTag = new StringBuilder(startTag);
        while (filter.size() > 0) {
            this.addToStack(creator, tokener, tag, valueItem, map);
            this.parseAttribute(tokener, buffer, map);
            if (buffer.getCurrentChar() == '/') {
                stack.popStack();
                continue;
            }
            buffer.skip();
            if (buffer.getCurrentChar() != '<') {
                tokener.nextString(buffer, valueItem, false, false, '<');
                if (!valueItem.isEmpty()) {
                    valueItem.trim();
                    Object entity = stack.getCurrentItem();
                    creator.setValue(entity, "value", valueItem.toString(), "new");
                }
            }
            creator = (item = idMap.getCreator((tag = tokener.nextToken(buffer, false, TOKEN)).toString(), false, null)) instanceof SendableEntityCreatorTag ? (SendableEntityCreatorTag)item : (SendableEntityCreatorTag)defaultCreator;
            sTag.append('.').append(tag.toString());
            for (int i = filter.size() - 1; i >= 0; ++i) {
                String key = (String)filter.getKeyByIndex(i);
                if (key.equals(sTag.toString())) {
                    creator = (SendableEntityCreatorTag)filter.getValueByIndex(i);
                    this.addToStack(creator, tokener, tag, valueItem, map);
                    return valueItem;
                }
                if (key.startsWith(sTag.toString())) continue;
                filter.removePos(i);
            }
            this.addToStack(creator, tokener, tag, valueItem, map);
        }
        return valueItem;
    }

    @Override
    public Entity createLink(Entity parent, String property, String className, String id) {
        if (parent != null) {
            parent.put(property, id);
        }
        return null;
    }

    protected Object addToStack(SendableEntityCreatorTag creator, XMLTokener tokener, CharacterBuffer tag, CharacterBuffer value, MapEntity map) {
        if (creator == null) {
            return null;
        }
        Object entity = creator.getSendableInstance(false);
        if (entity instanceof EntityList) {
            creator.setValue(entity, "value", value.toString(), "new");
            creator.setValue(entity, "tag", tag.toString(), "new");
        }
        map.getStack().withStack(tag.toString(), entity, creator);
        return entity;
    }

    @Override
    public Object transformValue(Object value, BaseItem reference) {
        return EntityUtil.valueToString(value, true, reference, SIMPLECONVERTER);
    }

    public SendableEntityCreator getDefaultFactory() {
        return this.defaultFactory;
    }

    public XMLTokener withDefaultFactory(SendableEntityCreator defaultFactory) {
        this.defaultFactory = defaultFactory;
        return this;
    }

    @Override
    public boolean isChild(Object writeValue) {
        return writeValue instanceof BaseItem;
    }

    public XMLTokener withAllowQuote(boolean value) {
        this.isAllowQuote = value;
        return this;
    }

    @Override
    public XMLTokener withMap(IdMap map) {
        super.withMap(map);
        return this;
    }
}

