/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui.controls;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.gui.Column;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleList;
import java.util.Collection;

public class TableComponent
extends Control {
    static final String TABLE = "table";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_SEARCHCOLUMNS = "searchColumns";
    protected IdMap map;
    private SimpleList<Column> columns = new SimpleList();
    private SimpleList<String> searchColumn = new SimpleList();
    private SimpleList<Object> items = new SimpleList();
    protected SendableEntityCreator sourceCreator;

    public TableComponent() {
        this.className = TABLE;
        this.addBaseElements(PROPERTY_COLUMNS);
        this.addBaseElements("elements");
        this.addBaseElements(PROPERTY_SEARCHCOLUMNS);
    }

    public boolean createFromCreator(SendableEntityCreator creator) {
        return false;
    }

    public TableComponent withColumn(Column ... columns) {
        this.addColumn(columns);
        return this;
    }

    public boolean addColumn(Column ... columns) {
        if (columns == null) {
            return false;
        }
        boolean changed = false;
        for (Column c : columns) {
            if (!this.columns.add(c)) continue;
            changed = true;
            this.firePropertyChange(PROPERTY_COLUMNS, null, c);
        }
        return changed;
    }

    public boolean addSearchProperties(String ... elements) {
        if (elements == null) {
            return false;
        }
        boolean changed = false;
        for (String c : elements) {
            if (!this.searchColumn.add(c)) continue;
            changed = true;
            this.firePropertyChange(PROPERTY_SEARCHCOLUMNS, null, c);
        }
        return changed;
    }

    public TableComponent withMap(IdMap map) {
        return this;
    }

    public TableComponent withSearchProperties(String ... elements) {
        this.addSearchProperties(elements);
        return this;
    }

    public TableComponent withList(Object entity, String property) {
        return this;
    }

    public TableComponent withList(Collection<Object> tableList) {
        return this;
    }

    public TableComponent withList(Object ... items) {
        this.addList(items);
        return this;
    }

    public boolean addList(Object ... elements) {
        if (elements == null) {
            return false;
        }
        boolean changed = false;
        for (Object c : elements) {
            if (!this.items.add(c)) continue;
            changed = true;
            this.firePropertyChange("elements", null, c);
        }
        return changed;
    }

    public SimpleList<String> getSearchColumn() {
        return this.searchColumn;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public Object getValue(String key) {
        if (PROPERTY_COLUMNS.equals(key)) {
            return this.columns;
        }
        if ("elements".equals(key)) {
            return this.items;
        }
        if (PROPERTY_SEARCHCOLUMNS.equals(key)) {
            return this.searchColumn;
        }
        return super.getValue(key);
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (PROPERTY_COLUMNS.equals(key)) {
            if (value instanceof Column[]) {
                return this.addColumn((Column[])value);
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                Column[] array = ((Collection)value).toArray(new Column[list.size()]);
                return this.addColumn(array);
            }
            return false;
        }
        if ("elements".equals(key)) {
            if (value instanceof Object[]) {
                return this.addList((Object[])value);
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                Object[] array = ((Collection)value).toArray(new Object[list.size()]);
                return this.addList(array);
            }
            return this.addList(value);
        }
        if (PROPERTY_SEARCHCOLUMNS.equals(key)) {
            if (value instanceof String) {
                return this.addSearchProperties((String)value);
            }
            if (value instanceof String[]) {
                return this.addSearchProperties((String[])value);
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                String[] array = ((Collection)value).toArray(new String[list.size()]);
                return this.addSearchProperties(array);
            }
            return false;
        }
        return super.setValue(key, value);
    }

    @Override
    public TableComponent newInstance() {
        return new TableComponent();
    }
}

