/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui.controls;

import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.list.SimpleList;
import java.util.Collection;

public class Group
extends Control {
    public static final String DIV = "div";
    public static final String ORIENTATION = "orientation";
    public static final String HORIZONTAL = "horizontal";
    public static final String VERTICAL = "vertical";
    private SimpleList<Control> elements;
    private String orientation = "horizontal";

    public Group() {
        this.className = DIV;
        this.addBaseElements("elements");
        this.addBaseElements(ORIENTATION);
    }

    public SimpleList<Control> getElements() {
        return this.elements;
    }

    public Group withElement(Control ... elements) {
        this.addElement(elements);
        return this;
    }

    public boolean addElement(Control ... elements) {
        if (elements == null) {
            return false;
        }
        boolean changed = false;
        if (this.elements == null) {
            this.elements = new SimpleList();
        }
        for (Control control : elements) {
            if (!this.elements.add(control)) continue;
            changed = true;
            this.firePropertyChange("elements", null, control);
        }
        return changed;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public boolean setOrientation(String value) {
        String oldValue = this.orientation;
        this.orientation = value;
        return this.firePropertyChange(ORIENTATION, oldValue, value);
    }

    public Group withOrientation(String value) {
        this.setOrientation(value);
        return this;
    }

    @Override
    public Object getValue(String key) {
        if (ORIENTATION.equals(key)) {
            return this.getOrientation();
        }
        if ("elements".equals(key)) {
            return this.getElements();
        }
        return super.getValue(key);
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (ORIENTATION.equals(key)) {
            return this.setOrientation("" + value);
        }
        if ("elements".equals(key)) {
            if (value instanceof Control) {
                return this.addElement((Control)value);
            }
            if (value instanceof Control[]) {
                return this.addElement((Control[])value);
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                Control[] array = ((Collection)value).toArray(new Control[list.size()]);
                return this.addElement(array);
            }
        }
        return super.setValue(key, value);
    }

    @Override
    public Group newInstance() {
        return new Group();
    }
}

