/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.sql;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.ext.sql.SQLCommand;
import de.uniks.networkparser.ext.sql.SQLStatement;
import de.uniks.networkparser.ext.sql.SQLStatementList;
import de.uniks.networkparser.ext.sql.SQLTable;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;

public class SQLTokener
extends Tokener {
    private SQLStatement sqlConnection;
    private Connection connection;
    public static String TABLE_FLAT = "table";
    public static String TABLE_PRIVOTISIERUNG = "pivotisierung";
    public static final byte FLAG_NONE = 0;
    public static final byte FLAG_CREATE = 1;
    public static final byte FLAG_DROP = 2;
    private String TYPE_INTEGER = "INTEGER";
    private String TYPE_STRING = "STRING";
    private String TYPE_OBJECT = "OBJECT";
    private byte flag = 1;
    private String stragety = TABLE_FLAT;

    public SQLTokener(SQLStatement connection) {
        this.sqlConnection = connection;
    }

    public SQLTokener(SQLStatement connection, String stragety) {
        this.sqlConnection = connection;
        this.stragety = stragety;
    }

    public SQLStatementList encode(GraphList model) {
        SQLStatementList result = new SQLStatementList();
        result.add(this.sqlConnection);
        for (Clazz clazz : model.getClazzes(new Condition[0])) {
            result.add(new SQLStatement(SQLCommand.DROPTABLE, clazz.getName()));
            SQLStatement createClass = new SQLStatement(SQLCommand.CREATETABLE, clazz.getName(), this.TYPE_STRING);
            if (TABLE_FLAT.equalsIgnoreCase(this.stragety)) {
                this.parseAssociations(clazz, createClass);
                this.parseAttributes(clazz, createClass);
            } else {
                createClass.with("PROP", this.TYPE_STRING);
                createClass.with("VALUE", this.TYPE_OBJECT);
            }
            result.add(createClass);
        }
        return result;
    }

    private void parseAttributes(Clazz clazz, SQLStatement sqlClass) {
        for (Attribute attribute : clazz.getAttributes(new Condition[0])) {
            sqlClass.with(attribute.getName(), EntityUtil.convertPrimitiveToObjectType(attribute.getType().getName(true)).toUpperCase());
        }
    }

    private void parseAssociations(Clazz clazz, SQLStatement sqlClass) {
        String type = "";
        for (Association association : clazz.getAssociations(new Condition[0])) {
            type = association.getCardinality() == Cardinality.MANY ? this.TYPE_INTEGER : "INTEGER[]";
            sqlClass.with(association.getOther().getName(), type);
        }
    }

    public boolean executeStatements(SQLStatementList statements) {
        return this.executeStatements(statements, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStatements(SQLStatementList statements, SimpleList<SQLTable> results, boolean dynamicTable) {
        boolean result = true;
        Connection connection = null;
        for (SQLStatement statement : statements) {
            if (!statement.isEnable()) continue;
            Statement query = null;
            try {
                if (statement.getCommand() == SQLCommand.CONNECTION) {
                    if (connection != null) {
                        this.disconnect(connection);
                    }
                    connection = this.connect(statement);
                    continue;
                }
                if (connection == null) {
                    connection = this.connect(this.sqlConnection);
                }
                query = connection.createStatement();
                if (statement.getCommand() == SQLCommand.SELECT) {
                    ResultSet executeQuery = query.executeQuery(statement.toString());
                    if (results != null) {
                        results.add(SQLTable.create(executeQuery, statement, dynamicTable));
                    }
                    result = true;
                    continue;
                }
                if (!statement.isAutoStatement() || statement.getCommand() == SQLCommand.INSERT || statement.getCommand() == SQLCommand.UPDATE) {
                    // empty if block
                }
                query.execute(statement.toString());
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                if (query == null) continue;
                try {
                    query.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (connection != null && (this.connection == null || this.connection != connection)) {
            result &= this.disconnect(connection);
        }
        return result;
    }

    public boolean disconnect(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.connection == null) {
            return true;
        }
        Connection con = this.connection;
        this.connection = null;
        return this.disconnect(con);
    }

    public Connection connect(SQLStatement connect) {
        if (connect == null) {
            return null;
        }
        if (this.connection != null) {
            return this.connection;
        }
        String string = connect.toString();
        try {
            return DriverManager.getConnection(string);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public SQLTokener withConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public SQLStatementList encode(Object entity, MapEntity map) {
        SQLStatementList statements = new SQLStatementList();
        statements.add(this.sqlConnection);
        map.withTokenerFlag(this.flag);
        this.parseModel(map, entity, statements);
        SimpleList<SQLTable> results = new SimpleList<SQLTable>();
        this.validateStatements(statements, results);
        return statements;
    }

    public SQLStatementList update(Object entity, String id, String property, Object newValue) {
        SQLStatementList statements = new SQLStatementList();
        statements.add(this.sqlConnection);
        SQLStatement command = SQLStatement.update(entity.getClass().getSimpleName(), id, property, newValue);
        statements.add(command);
        return statements;
    }

    private void addTableCreate(String tableName, Object item, SendableEntityCreator creator, SQLStatementList statements, MapEntity map) {
        if (!map.contains(tableName)) {
            if (map.isTokenerFlag((byte)2)) {
                statements.add(new SQLStatement(SQLCommand.DROPTABLE, tableName));
            }
            if (map.isTokenerFlag((byte)1)) {
                SQLStatement dataStatement = new SQLStatement(SQLCommand.CREATETABLE, tableName, this.TYPE_STRING);
                String[] properties = null;
                if (TABLE_PRIVOTISIERUNG.equalsIgnoreCase(this.stragety)) {
                    dataStatement.with("PROP", this.TYPE_STRING);
                    dataStatement.with("VALUE", this.TYPE_OBJECT);
                } else {
                    properties = creator.getProperties();
                }
                if (properties != null) {
                    for (int i = 0; i < properties.length; ++i) {
                        if (properties[i].indexOf(46) >= 0 || properties[i] == "dynamic") continue;
                        String type = null;
                        Object value = creator.getValue(item, properties[i]);
                        if (value instanceof Collection) {
                            Object child;
                            String simpleName;
                            SendableEntityCreator currentCreator;
                            Collection collection = (Collection)value;
                            if (collection.size() > 0 && (currentCreator = this.map.getCreator(simpleName = (child = collection.iterator().next()).getClass().getName(), true, null)) != null) {
                                type = "INTEGER[]";
                            }
                            if (type == null) {
                                type = "OBJECT[]";
                            }
                        } else {
                            String simpleName;
                            SendableEntityCreator currentCreator;
                            type = value == null ? this.TYPE_STRING : ((currentCreator = this.map.getCreator(simpleName = value.getClass().getSimpleName(), true, null)) != null ? this.TYPE_INTEGER : simpleName);
                        }
                        dataStatement.with(properties[i], EntityUtil.convertPrimitiveToObjectType(type).toUpperCase());
                    }
                }
                statements.add(dataStatement);
            }
            map.add(tableName);
        }
    }

    private String parseModel(MapEntity map, Object item, SQLStatementList statements) {
        if (map.contains(item)) {
            return this.map.getKey(item);
        }
        String id = this.map.getId(item, true);
        map.with(item);
        String className = item.getClass().getName();
        Grammar grammar = map.getGrammar();
        SendableEntityCreator creator = grammar.getCreator("new", item, map, className);
        if (creator == null) {
            return item.toString();
        }
        String tableName = EntityUtil.shortClassName(className);
        this.addTableCreate(tableName, item, creator, statements, map);
        if (TABLE_PRIVOTISIERUNG.equalsIgnoreCase(this.stragety)) {
            this.parseModelPrivotisierung(map, tableName, id, creator, item, statements);
        } else {
            this.parseModelFlat(map, tableName, id, creator, item, statements);
        }
        return id;
    }

    private void parseModelPrivotisierung(MapEntity map, String tableName, String id, SendableEntityCreator creator, Object item, SQLStatementList statements) {
        String[] properties = creator.getProperties();
        Object prototype = creator.getSendableInstance(true);
        for (String property : properties) {
            SQLStatement insertStatement;
            Object value = creator.getValue(item, property);
            if (value == null || property == "dynamic" || value.equals(creator.getValue(prototype, property))) continue;
            if (value instanceof Collection) {
                Collection children = (Collection)value;
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    String neighbourId = this.parseModel(map, i.next(), statements);
                    insertStatement = new SQLStatement(SQLCommand.INSERT, tableName, id);
                    insertStatement.with("PROP", property);
                    insertStatement.with("VALUE", neighbourId);
                    statements.add(insertStatement);
                }
                continue;
            }
            insertStatement = new SQLStatement(SQLCommand.INSERT, tableName, id);
            insertStatement.with("PROP", property);
            SendableEntityCreator childCreator = this.map.getCreator(value.getClass().getName(), true, null);
            if (childCreator != null) {
                insertStatement.with("VALUE", this.parseModel(map, value, statements));
            } else {
                insertStatement.with("VALUE", value);
            }
            statements.add(insertStatement);
        }
    }

    private void parseModelFlat(MapEntity map, String tableName, String id, SendableEntityCreator creator, Object item, SQLStatementList statements) {
        SQLStatement insertStatement = new SQLStatement(SQLCommand.INSERT, tableName);
        insertStatement.with("_ID", id);
        for (String property : creator.getProperties()) {
            Object value = creator.getValue(item, property);
            if (value == null || property == "dynamic") continue;
            if (value instanceof Collection) {
                Collection children = (Collection)value;
                SimpleSet<String> values = new SimpleSet<String>();
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    values.add(this.parseModel(map, i.next(), statements));
                }
                insertStatement.with(property, values);
                continue;
            }
            SendableEntityCreator childCreator = this.map.getCreator(value.getClass().getName(), true, null);
            if (childCreator != null) {
                insertStatement.with(property, this.parseModel(map, value, statements));
                continue;
            }
            insertStatement.with(property, value);
        }
        statements.add(insertStatement);
    }

    public boolean validateStatements(SQLStatementList result, SimpleList<SQLTable> results) {
        SelectSearcher values;
        SimpleKeyValueList<String, SelectSearcher> foundKeys = new SimpleKeyValueList<String, SelectSearcher>();
        for (SQLStatement statement : result) {
            String table = statement.getTable();
            values = (SelectSearcher)foundKeys.get(table);
            if (values == null) {
                values = new SelectSearcher();
                foundKeys.put(table, values);
            }
            if (statement.getCommand() == SQLCommand.DROPTABLE) {
                values.clear();
                values.drop = true;
                continue;
            }
            if (statement.getCommand() == SQLCommand.CREATETABLE) {
                if (!values.drop) continue;
                values.create = true;
                continue;
            }
            String primaryKey = statement.getPrimaryId();
            if (statement.getCommand() == SQLCommand.INSERT) {
                if (values.create) continue;
                if (values.drop) {
                    if (statement.autoDisable()) continue;
                    values.addId(primaryKey);
                    continue;
                }
                if (values.addId(primaryKey)) {
                    values.mayBeStatements.add(statement);
                    continue;
                }
                if (!statement.isAutoStatement()) continue;
                statement.withCommand(SQLCommand.UPDATE);
                statement.withCondition("_ID", primaryKey);
                statement.without("_ID");
                continue;
            }
            if (statement.getCommand() == SQLCommand.UPDATE) {
                if (values.create) {
                    if (values.getIds().contains(primaryKey) || !statement.isAutoStatement()) continue;
                    statement.withCommand(SQLCommand.INSERT);
                    statement.withoutCondition("_ID");
                    statement.with("_ID", primaryKey);
                    values.addId(primaryKey);
                    continue;
                }
                if (values.drop) {
                    if (statement.isAutoStatement()) {
                        statement.withEnable(false);
                        continue;
                    }
                    values.addId(primaryKey);
                    continue;
                }
                values.mayBeStatements.add(statement);
                if (!statement.isAutoStatement() || values.getIds().contains(statement.getPrimaryId()) || primaryKey == null) continue;
                statement.withCommand(SQLCommand.INSERT);
                statement.withoutCondition("_ID");
                statement.with("_ID", primaryKey);
                values.addId(primaryKey);
                continue;
            }
            if (statement.getCommand() == SQLCommand.DELETE) {
                if (values.create) {
                    if (values.getIds().contains(primaryKey)) continue;
                    if (statement.isAutoStatement()) {
                        statement.withEnable(false);
                        continue;
                    }
                    if (primaryKey == null) continue;
                    values.addId(primaryKey);
                    values.addDeletedId(primaryKey);
                    continue;
                }
                if (primaryKey == null) continue;
                values.addId(primaryKey);
                values.addDeletedId(primaryKey);
                continue;
            }
            if (statement.getCommand() != SQLCommand.SELECT) continue;
            if (!values.create && values.drop) {
                statement.autoDisable();
                continue;
            }
            if (values.getDeletedIds().contains(primaryKey)) {
                statement.autoDisable();
                continue;
            }
            if (values.getIds().contains(primaryKey)) continue;
            values.mayBeStatements.add(statement);
        }
        SQLStatementList selectList = new SQLStatementList();
        SimpleIteratorSet i = new SimpleIteratorSet(foundKeys);
        while (i.hasNext()) {
            Object entity = i.next();
            values = (SelectSearcher)entity.getValue();
            if (values.mayBeStatements.size() < 1) continue;
            String tableName = (String)entity.getKey();
            SQLStatement selectStatement = new SQLStatement(SQLCommand.SELECT, tableName).withValues("_ID").withCondition("_ID", values.getIds());
            selectList.add(selectStatement);
        }
        if (selectList.size() < 1) {
            return false;
        }
        this.executeStatements(selectList, results, true);
        for (SQLTable sqlTable : results) {
            SelectSearcher selectSearcher = (SelectSearcher)foundKeys.get(sqlTable.getTable());
            SimpleList<Object> idValues = sqlTable.getColumnValue("_ID");
            for (Object v : idValues) {
                for (int i2 = selectSearcher.mayBeStatements.size() - 1; i2 >= 0; --i2) {
                    SQLStatement statement = (SQLStatement)selectSearcher.mayBeStatements.get(i2);
                    String primaryId = statement.getPrimaryId();
                    if (primaryId == null || !primaryId.equals(v) || !statement.getCommand().equals((Object)SQLCommand.INSERT)) continue;
                    statement.withCommand(SQLCommand.UPDATE);
                    statement.withCondition("_ID", primaryId);
                    statement.without("_ID");
                    selectSearcher.mayBeStatements.remove(i2);
                }
            }
        }
        return true;
    }

    public byte getFlag() {
        return this.flag;
    }

    public SQLTokener withFlag(byte flag) {
        this.flag = flag;
        return this;
    }

    static final class SelectSearcher {
        private SimpleList<String> ids = new SimpleList();
        private SimpleList<String> deleteIds = new SimpleList();
        private boolean drop;
        private boolean create;
        private SimpleList<SQLStatement> mayBeStatements = new SimpleList();

        SelectSearcher() {
        }

        public void clear() {
            this.ids.clear();
        }

        public boolean addId(String primaryId) {
            return this.ids.add(primaryId);
        }

        public SimpleList<String> getIds() {
            return this.ids;
        }

        public void addDeletedId(String primaryId) {
            this.deleteIds.add(primaryId);
        }

        public SimpleList<String> getDeletedIds() {
            return this.deleteIds;
        }
    }
}

