/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.filter;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleKeyValueList;

public class ProxyFilter
implements ObjectCondition {
    private SimpleKeyValueList<String, NodeProxy> nodeProxyList = new SimpleKeyValueList();

    private String getClassName(NodeProxy proxy) {
        if (proxy == null) {
            return null;
        }
        Object reference = proxy.getSendableInstance(true);
        if (reference != null) {
            if (reference instanceof Class) {
                return ((Class)reference).getName();
            }
            return reference.getClass().getName();
        }
        return null;
    }

    public ProxyFilter with(NodeProxy ... values) {
        if (values == null) {
            return this;
        }
        for (NodeProxy proxy : values) {
            String className = this.getClassName(proxy);
            if (className == null) continue;
            this.nodeProxyList.add(className, proxy);
        }
        return this;
    }

    public ProxyFilter without(NodeProxy ... values) {
        if (values == null) {
            return this;
        }
        for (NodeProxy proxy : values) {
            String className = this.getClassName(proxy);
            if (className == null) continue;
            this.nodeProxyList.remove(className);
        }
        return this;
    }

    public NodeProxy getCreator(String clazz) {
        NodeProxy creator = this.nodeProxyList.get(clazz);
        if (creator != null) {
            return creator;
        }
        return null;
    }

    @Override
    public boolean update(Object value) {
        String[] sendableProperties;
        SimpleEvent evt = (SimpleEvent)value;
        NodeProxy creator = null;
        if (evt.getModelValue() != null) {
            creator = this.getCreator(evt.getModelValue().getClass().getName());
        }
        if (creator == null) {
            return false;
        }
        for (String prop : sendableProperties = creator.getUpdateProperties()) {
            if (!prop.equals(evt.getPropertyName())) continue;
            return true;
        }
        return false;
    }
}

