/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyServer;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Server;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Server_UPD
extends Thread
implements Server {
    protected boolean run = true;
    protected DatagramSocket socket;
    private NodeProxyServer proxy;

    public Server_UPD(NodeProxyServer proxy, boolean asyn) {
        this.proxy = proxy;
        if (this.init() && asyn) {
            this.start();
        }
    }

    @Override
    public boolean close() {
        this.run = false;
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        return true;
    }

    @Override
    public boolean isRun() {
        return this.socket != null && !this.socket.isClosed();
    }

    @Override
    public void run() {
        if (NodeProxy.isInput(this.proxy.getType())) {
            this.runServer();
        } else {
            DatagramPacket data = this.runClient();
            if (this.proxy != null) {
                this.proxy.getSpace().firePropertyChange("BROADCAST", null, data);
            }
        }
    }

    public DatagramPacket createSendPacket() {
        byte[] sendData = new byte[this.proxy.getBufferSize()];
        if (this.proxy.getSpace() != null) {
            sendData = this.proxy.getSpace().getReplicationInfo().toString().getBytes();
        }
        InetAddress IPAddress = null;
        try {
            IPAddress = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, this.proxy.getPort());
        return sendPacket;
    }

    public DatagramPacket runClient() {
        DatagramPacket receivePacket;
        DatagramPacket message = this.createSendPacket();
        try {
            this.socket.send(message);
            byte[] receiveData = new byte[this.proxy.getBufferSize()];
            receivePacket = new DatagramPacket(receiveData, receiveData.length);
            this.socket.receive(receivePacket);
        }
        catch (IOException e) {
            return null;
        }
        return receivePacket;
    }

    public void runServer() {
        Thread.currentThread().setName(this.proxy.getPort() + " broadcast server");
        while (!this.isInterrupted() && this.run) {
            try {
                byte[] receiveData = new byte[this.proxy.getBufferSize()];
                DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                this.socket.receive(receivePacket);
                InetAddress IPAddress = receivePacket.getAddress();
                int port = receivePacket.getPort();
                Entity answer = this.proxy.getSpace().getReplicationInfo();
                byte[] sendData = answer.toString().getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, port);
                this.socket.send(sendPacket);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean init() {
        boolean success = true;
        try {
            this.socket = this.proxy != null && NodeProxy.isInput(this.proxy.getType()) ? new DatagramSocket(this.proxy.getPort()) : new DatagramSocket();
        }
        catch (SocketException e) {
            success = false;
        }
        return success;
    }
}

