/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.git;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class GitRevision {
    public static final String MAYOR = "mayor";
    public static final String MINOR = "minor";
    public static final String HASH = "hash";
    public static final String TAG = "tag";
    public static final String BRANCHNAME = "branchname";
    public static final String LASTCOMMIT = "lastcommit";
    public static final String REVISIONNUMBER = "revisionnumber";
    public static final String COMMITS = "commits";
    private boolean full = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject execute(int maxCommit) throws IOException {
        int count;
        JsonObject info;
        JsonArray map;
        String id;
        LinkedHashSet<String> branches;
        Map allRefs;
        block14: {
            if (ReflectionLoader.FILEREPOSITORYBUILDER == null) {
                return null;
            }
            File file = new File("");
            Object builder = ReflectionLoader.newInstance(ReflectionLoader.FILEREPOSITORYBUILDER, new Object[0]);
            Object repository = null;
            allRefs = null;
            branches = new LinkedHashSet<String>();
            id = null;
            Object headID = null;
            map = new JsonArray();
            info = new JsonObject();
            count = 0;
            try {
                Object repoBuilder = ReflectionLoader.call(builder, "setWorkTree", File.class, file);
                repository = ReflectionLoader.callChain(repoBuilder, "readEnvironment", "findGitDir", "build");
                this.calcGitTag(repository, info);
                allRefs = (Map)ReflectionLoader.call(repository, "getAllRefs", new Object[0]);
                headID = ReflectionLoader.call(repository, "resolve", String.class, "HEAD");
                if (headID != null) {
                    id = (String)ReflectionLoader.call(headID, "name", new Object[0]);
                }
                this.commitInfo(map, repository, headID, null);
                String string = (String)ReflectionLoader.call(repository, "getBranch", new Object[0]);
                branches.add(string);
                while (headID != null) {
                    Object oldId = headID;
                    String name = (String)ReflectionLoader.call(headID, "getName", new Object[0]);
                    headID = ReflectionLoader.call(repository, "resolve", String.class, name + "^1");
                    if (maxCommit >= 0 && ++count >= maxCommit) continue;
                    this.commitInfo(map, repository, headID, oldId);
                }
                if (repository == null) break block14;
            }
            catch (Exception repoBuilder) {
                if (repository != null) {
                    ReflectionLoader.call(repository, "close", new Object[0]);
                }
                break block14;
                catch (Throwable throwable) {
                    if (repository != null) {
                        ReflectionLoader.call(repository, "close", new Object[0]);
                    }
                    throw throwable;
                }
            }
            ReflectionLoader.call(repository, "close", new Object[0]);
        }
        if (allRefs != null) {
            if (id == null) {
                id = "";
            }
            for (Map.Entry entry : allRefs.entrySet()) {
                Object value = entry.getValue();
                String newId = (String)ReflectionLoader.callChain(value, false, "getObjectId", "getName");
                if (!id.equals(newId) || branches.contains(entry.getKey())) continue;
                branches.add((String)entry.getKey());
            }
        }
        Iterator<Object> i = branches.iterator();
        StringBuilder stringBuilder = new StringBuilder((String)i.next());
        while (true) {
            if (!i.hasNext()) {
                info.put(BRANCHNAME, stringBuilder.toString());
                info.put(LASTCOMMIT, id);
                info.put(REVISIONNUMBER, count);
                info.put(COMMITS, map);
                return info;
            }
            stringBuilder.append(" ").append((String)i.next());
        }
    }

    public boolean setFull(boolean full) {
        if (full != this.full) {
            this.full = full;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return this.full;
    }

    public int calcGitTag(Object repository, JsonObject info) {
        if (ReflectionLoader.REPOSITORY == null || repository == null || !ReflectionLoader.REPOSITORY.isAssignableFrom(repository.getClass())) {
            return -1;
        }
        int minor = -1;
        int mayor = -1;
        String tag = null;
        String tagHash = "";
        Map tags = (Map)ReflectionLoader.call(repository, "getTags", new Object[0]);
        int versionNumber = 0;
        for (Map.Entry entry : tags.entrySet()) {
            try {
                Integer value;
                String id = ((String)entry.getKey()).trim();
                int start = id.indexOf(".");
                int vNumber = 0;
                int mayorNumber = 0;
                if (start > 0) {
                    mayorNumber = Integer.valueOf(id.substring(0, start));
                    if ((start = (id = id.substring(start + 1)).indexOf(".")) > 0) {
                        try {
                            vNumber = Integer.valueOf(id.substring(start + 1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        id = id.substring(0, start);
                    }
                }
                if ((value = Integer.valueOf(id)) <= 0) continue;
                if (mayorNumber > mayor) {
                    tag = ((String)entry.getKey()).trim();
                    mayor = mayorNumber;
                    tagHash = (String)ReflectionLoader.call(entry.getValue(), "getName", new Object[0]);
                    versionNumber = vNumber;
                    minor = value;
                    continue;
                }
                if (value > minor) {
                    tag = ((String)entry.getKey()).trim();
                    tagHash = (String)ReflectionLoader.call(entry.getValue(), "getName", new Object[0]);
                    versionNumber = vNumber;
                    minor = value;
                    continue;
                }
                if (value != minor) continue;
                if (versionNumber == 0) {
                    tagHash = (String)ReflectionLoader.call(entry.getValue(), "getName", new Object[0]);
                    versionNumber = vNumber;
                    tag = ((String)entry.getKey()).trim();
                } else if (vNumber > versionNumber) {
                    tag = ((String)entry.getKey()).trim();
                    versionNumber = vNumber;
                    tagHash = (String)ReflectionLoader.call(entry.getValue(), "getName", new Object[0]);
                }
                minor = value;
            }
            catch (Exception exception) {}
        }
        info.put(MAYOR, mayor);
        info.put(MINOR, minor);
        info.put(HASH, tagHash);
        info.put(TAG, tag);
        return minor;
    }

    private JsonObject commitInfo(JsonArray map, Object repository, Object objectID, Object newerrId) throws Exception {
        try {
            JsonObject jsonObject = new JsonObject();
            Object walk = ReflectionLoader.newInstance(ReflectionLoader.REVWALK, ReflectionLoader.REPOSITORY, repository);
            Object commit = null;
            if (objectID != null) {
                commit = ReflectionLoader.call(walk, "parseCommit", ReflectionLoader.ANYOBJECTID, objectID);
            }
            if (commit != null) {
                String msg;
                jsonObject.put("ID", ReflectionLoader.call(objectID, "getName", new Object[0]));
                jsonObject.put("TIME", "" + ReflectionLoader.call(commit, "getCommitTime", new Object[0]));
                Object temp = ReflectionLoader.call(commit, "getCommitterIdent", new Object[0]);
                if (temp != null) {
                    jsonObject.put("COMMITER", ReflectionLoader.call(temp, "getName", new Object[0]));
                }
                if ((msg = (String)ReflectionLoader.call(commit, "getFullMessage", new Object[0])) != null) {
                    if ((msg = msg.trim()).endsWith("\\u000a")) {
                        msg = msg.substring(0, msg.length() - 6);
                    }
                    jsonObject.put("MESSAGE", msg);
                }
                if (newerrId != null && this.full) {
                    Object newerCommit = ReflectionLoader.call(walk, "parseCommit", newerrId);
                    Object reader = ReflectionLoader.call(repository, "newObjectReader", new Object[0]);
                    Object newerTreeIter = ReflectionLoader.newInstance(ReflectionLoader.CANONICALTREEPARSER, new Object[0]);
                    List diffs = null;
                    Object tree = ReflectionLoader.call(newerCommit, "getTree", new Object[0]);
                    if (tree != null) {
                        ReflectionLoader.call(newerTreeIter, "reset", tree);
                        Object newTreeIter = ReflectionLoader.newInstance(ReflectionLoader.CANONICALTREEPARSER, new Object[0]);
                        Object newtree = ReflectionLoader.call(commit, "getTree", new Object[0]);
                        if (newtree != null) {
                            ReflectionLoader.call(newTreeIter, "reset", reader, newtree);
                            Object git = ReflectionLoader.newInstance(ReflectionLoader.GIT, repository);
                            git = ReflectionLoader.call(git, "diff", new Object[0]);
                            git = ReflectionLoader.call(git, "setNewTree", newerTreeIter);
                            git = ReflectionLoader.call(git, "setOldTree", newTreeIter);
                            diffs = (List)ReflectionLoader.call(git, "call", new Object[0]);
                        }
                    }
                    if (diffs != null) {
                        JsonArray files = new JsonArray();
                        Object refmode = ReflectionLoader.getField("MISSING", ReflectionLoader.FILEMODE);
                        for (Object entry : diffs) {
                            Object mode = ReflectionLoader.call(entry, "getNewMode", new Object[0]);
                            String value = (String)ReflectionLoader.call(entry, "getNewPath", new Object[0]);
                            if (mode == refmode) {
                                files.add(new JsonObject().withValue("REM", value));
                                continue;
                            }
                            files.add(new JsonObject().withValue("CHANGE", value));
                        }
                        jsonObject.put("FILES", files);
                    }
                }
                map.add(jsonObject);
            }
            ReflectionLoader.call(walk, "close", new Object[0]);
            return jsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected SimpleKeyValueList<String, Integer> createdComment(String sourcePath, String licenceFile) {
        SimpleKeyValueList<String, Integer> values = new SimpleKeyValueList<String, Integer>();
        values.put("LOC", 0);
        CharacterBuffer licence = FileBuffer.readFile(licenceFile);
        this.createdComment(sourcePath, licence, values);
        return values;
    }

    private void createdComment(String sourcePath, CharacterBuffer licence, SimpleKeyValueList<String, Integer> values) {
        File path = new File(sourcePath);
        File[] listFiles = path.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File child : listFiles) {
            if (child == null) continue;
            if (child.isDirectory()) {
                this.createdComment(sourcePath + child.getName() + "/", licence, values);
                continue;
            }
            if (child.getAbsolutePath().endsWith(".java")) continue;
        }
    }
}

