/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import java.util.List;

public class EMFParser {
    protected Object value;

    public EMFParser(Object value) {
        this.value = value;
    }

    public static final void addAttributes(EMFParser eclass, Clazz sdmClass) {
        List<Object> callList = EMFParser.getEAttributes(eclass);
        for (Object item : callList) {
            if (item == null) continue;
            String name = EMFParser.getName(item);
            EMFParser eClassifier = new EMFParser(ReflectionLoader.call(item, "getEType", new Object[0]));
            sdmClass.withAttribute(name, DataType.create(EntityUtil.shortClassName(EMFParser.getInstanceClassName(eClassifier))));
        }
    }

    public static final ClassModel getClassModelFromEPackage(Object epackage, String packageName, boolean withImpl) {
        ClassModel model = new ClassModel(packageName);
        if (epackage == null) {
            return model;
        }
        if (!ReflectionLoader.EPACKAGE.isAssignableFrom(epackage.getClass())) {
            return model;
        }
        SimpleKeyValueList<EMFParser, Clazz> classMap = new SimpleKeyValueList<EMFParser, Clazz>();
        List<EMFParser> eClasses = EMFParser.getEClasses(epackage);
        for (EMFParser eclass : eClasses) {
            String fullClassName = EMFParser.getName(eclass);
            Clazz sdmClass = model.createClazz(fullClassName).enableInterface();
            if (withImpl) {
                sdmClass.enableInterface();
                String implClassName = GraphUtil.getPackage(fullClassName) + ".impl." + EMFParser.getName(eclass) + "Impl";
                model.createClazz(implClassName).withSuperClazz(sdmClass);
            }
            classMap.put(eclass, sdmClass);
            EMFParser.addAttributes(eclass, sdmClass);
        }
        SimpleSet<Object> doneERefs = new SimpleSet<Object>();
        for (EMFParser eclass : eClasses) {
            if (!EMFParser.getESuperTypes(eclass).isEmpty()) {
                EMFParser eSuperClass = (EMFParser)EMFParser.getESuperTypes(eclass).get(0);
                Clazz sdmSuperClass = (Clazz)classMap.get(eSuperClass);
                Clazz sdmClass = (Clazz)classMap.get(eclass);
                sdmClass.withSuperClazz(sdmSuperClass);
            }
            List<Object> eReferences = EMFParser.getEReferences(eclass);
            for (Object eref : eReferences) {
                Clazz tgtSDMClass;
                Clazz srcSDMClass;
                EMFParser tgtEClass;
                EMFParser srcEClass;
                if (doneERefs.contains(eref)) continue;
                Object oppositeERef = EMFParser.getEOpposite(eref);
                if (oppositeERef != null) {
                    srcEClass = EMFParser.getEType(oppositeERef);
                    tgtEClass = EMFParser.getEType(eref);
                    srcSDMClass = (Clazz)classMap.get(srcEClass);
                    tgtSDMClass = (Clazz)classMap.get(tgtEClass);
                    Cardinality srcCard = EMFParser.getUpperBound(oppositeERef) == 1 ? Cardinality.ONE : Cardinality.MANY;
                    Cardinality tgtCard = EMFParser.getUpperBound(eref) == 1 ? Cardinality.ONE : Cardinality.MANY;
                    srcSDMClass.withBidirectional(tgtSDMClass, EMFParser.getName(eref), tgtCard, EMFParser.getName(oppositeERef), srcCard);
                    doneERefs.add(eref);
                    doneERefs.add(oppositeERef);
                    continue;
                }
                srcEClass = eclass;
                tgtEClass = EMFParser.getEType(eref);
                srcSDMClass = (Clazz)classMap.get(srcEClass);
                tgtSDMClass = (Clazz)classMap.get(tgtEClass);
                Cardinality tgtCard = EMFParser.getUpperBound(eref) == 1 ? Cardinality.ONE : Cardinality.MANY;
                srcSDMClass.withUniDirectional(tgtSDMClass, EMFParser.getName(eref), tgtCard);
                doneERefs.add(eref);
            }
        }
        return model;
    }

    public static final List<Object> getEAttributes(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getEAttributes(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return null;
        }
        List<Object> callList = ReflectionLoader.callList(eref, "getEAttributes", new Object[0]);
        return callList;
    }

    public static final List<Object> getEReferences(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getEReferences(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return null;
        }
        List<Object> callList = ReflectionLoader.callList(eref, "getEReferences", new Object[0]);
        return callList;
    }

    public static final SimpleList<EMFParser> getESuperTypes(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getESuperTypes(((EMFParser)eref).getValue());
        }
        SimpleList<EMFParser> list = new SimpleList<EMFParser>();
        if (!EMFParser.isEMF(eref)) {
            return list;
        }
        List<Object> callList = ReflectionLoader.callList(eref, "getESuperTypes", new Object[0]);
        for (Object item : callList) {
            if (item == null) continue;
            list.add(new EMFParser(item));
        }
        return list;
    }

    public static final List<EMFParser> getEClasses(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getEClasses(((EMFParser)eref).getValue());
        }
        SimpleList<EMFParser> items = new SimpleList<EMFParser>();
        if (!EMFParser.isEMF(eref)) {
            return items;
        }
        List<Object> callList = ReflectionLoader.callList(eref, "getEClassifiers", new Object[0]);
        for (Object item : callList) {
            if (item == null || !ReflectionLoader.ECLASS.isAssignableFrom(item.getClass())) continue;
            items.add(new EMFParser(item));
        }
        return items;
    }

    public static final String getInstanceClassName(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getInstanceClassName(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return "";
        }
        return "" + ReflectionLoader.call(eref, "getInstanceClassName", new Object[0]);
    }

    public static final EMFParser getEType(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getEType(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return null;
        }
        return new EMFParser(ReflectionLoader.call(eref, "getEType", new Object[0]));
    }

    public static final Integer getUpperBound(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getUpperBound(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return -1;
        }
        Object call = ReflectionLoader.call(eref, "getUpperBound", new Object[0]);
        if (call instanceof Integer) {
            return (Integer)call;
        }
        return -1;
    }

    public static final String getName(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getName(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return "";
        }
        return "" + ReflectionLoader.call(eref, "getName", new Object[0]);
    }

    public static final boolean isEMF(Object eref) {
        if (ReflectionLoader.EOBJECT == null || eref == null) {
            return false;
        }
        return ReflectionLoader.EOBJECT.isAssignableFrom(eref.getClass());
    }

    public static final Object getEOpposite(Object eref) {
        if (eref instanceof EMFParser) {
            return EMFParser.getEOpposite(((EMFParser)eref).getValue());
        }
        if (!EMFParser.isEMF(eref)) {
            return "";
        }
        return ReflectionLoader.call(eref, "getEOpposite", new Object[0]);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof EMFParser)) {
            return false;
        }
        EMFParser other = (EMFParser)obj;
        return this.value.equals(other.getValue());
    }

    public Object getValue() {
        return this.value;
    }
}

