/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.TextItems;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.Feature;
import de.uniks.networkparser.graph.FeatureProperty;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.graph.util.FeatureSet;
import de.uniks.networkparser.graph.util.MethodSet;
import de.uniks.networkparser.graph.util.ParameterSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.And;
import de.uniks.networkparser.logic.FeatureCondition;
import de.uniks.networkparser.logic.ForeachCondition;
import de.uniks.networkparser.logic.IfCondition;
import de.uniks.networkparser.logic.ImportCondition;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.logic.Or;
import de.uniks.networkparser.logic.TemplateFragmentCondition;
import de.uniks.networkparser.parser.ParserEntity;
import de.uniks.networkparser.parser.Template;
import de.uniks.networkparser.parser.TemplateResultFile;
import de.uniks.networkparser.parser.TemplateResultFragment;
import de.uniks.networkparser.parser.TemplateResultModel;
import de.uniks.networkparser.parser.generator.BasicGenerator;
import de.uniks.networkparser.parser.generator.cpp.CppClazz;
import de.uniks.networkparser.parser.generator.java.JavaClazz;
import de.uniks.networkparser.parser.generator.java.JavaCreator;
import de.uniks.networkparser.parser.generator.java.JavaCreatorCreator;
import de.uniks.networkparser.parser.generator.java.JavaSet;
import de.uniks.networkparser.parser.generator.logic.DebugCondition;
import de.uniks.networkparser.parser.generator.logic.JavaListCondition;
import de.uniks.networkparser.parser.generator.logic.JavaMethodBodyCondition;
import de.uniks.networkparser.parser.generator.typescript.TypescriptClazz;

public class ModelGenerator
extends BasicGenerator {
    private FeatureSet features = Feature.getAll();
    private GraphModel defaultModel;
    public SimpleKeyValueList<String, ParserCondition> customTemplate;
    private boolean useSDMLibParser = true;
    private String defaultRootDir;
    private SimpleList<BasicGenerator> javaGeneratorTemplates = (SimpleList)new SimpleList().with(new JavaCreatorCreator(), new JavaClazz(), new JavaSet(), new JavaCreator());
    private SimpleList<BasicGenerator> typeScriptTemplates = (SimpleList)new SimpleList().with(new TypescriptClazz());
    private SimpleList<BasicGenerator> cppScriptTemplates = (SimpleList)new SimpleList().with(new CppClazz());

    public SimpleKeyValueList<String, ParserCondition> getTemplates() {
        if (this.customTemplate == null) {
            this.customTemplate = new SimpleKeyValueList();
            this.addParserCondition(new FeatureCondition());
            this.addParserCondition(new ImportCondition());
            this.addParserCondition(new ForeachCondition());
            this.addParserCondition(new TemplateFragmentCondition());
            this.addParserCondition(new IfCondition());
            this.addParserCondition(new IfCondition().withKey("ifnot"));
            this.addParserCondition(new JavaMethodBodyCondition());
            this.addParserCondition(new JavaListCondition());
            this.addParserCondition(new And());
            this.addParserCondition(new Or());
            this.addParserCondition(new DebugCondition());
            this.addParserCondition(new Not());
        }
        return this.customTemplate;
    }

    protected void addParserCondition(ParserCondition condition) {
        String key = condition.getKey();
        if (key != null) {
            this.customTemplate.add(key.toLowerCase(), condition);
        }
    }

    public SendableEntityCreator generate(GraphMember item) {
        if (!(item instanceof GraphModel)) {
            return null;
        }
        return this.generate("src", (GraphModel)item);
    }

    public SendableEntityCreator generate(GraphMember item, TextItems parameters) {
        if (!(item instanceof GraphModel)) {
            return null;
        }
        return this.generateJava("src", (GraphModel)item, parameters);
    }

    public SendableEntityCreator generate(String rootDir, GraphModel model) {
        return this.generateJava(rootDir, model, null);
    }

    public SendableEntityCreator generateJava(String rootDir, GraphModel model, TextItems parameters) {
        return this.generating(rootDir, model, parameters, this.javaGeneratorTemplates, true, true);
    }

    public SendableEntityCreator generateTypescript(String rootDir, GraphModel model) {
        return this.generateTypescript(rootDir, model, null);
    }

    public SendableEntityCreator generateTypescript(String rootDir, GraphModel model, TextItems parameters) {
        return this.generating(rootDir, model, parameters, this.typeScriptTemplates, true, true);
    }

    public TemplateResultModel getResultModel() {
        TemplateResultModel resultModel = new TemplateResultModel();
        resultModel.withTemplate(this.getTemplates());
        resultModel.withFeatures(this.features);
        return resultModel;
    }

    SendableEntityCreator generating(String rootDir, String type, GraphModel model) {
        if ("java".equalsIgnoreCase(type)) {
            return this.generating(rootDir, model, null, this.javaGeneratorTemplates, true, true);
        }
        if ("typescript".equalsIgnoreCase(type)) {
            return this.generating(rootDir, model, null, this.typeScriptTemplates, true, false);
        }
        if ("cpp".equalsIgnoreCase(type)) {
            return this.generating(rootDir, model, null, this.cppScriptTemplates, true, true);
        }
        return null;
    }

    private String getFileName(String path, String file) {
        if (path == null) {
            path = "";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + file.replaceAll("\\.", "/") + "/";
        return path;
    }

    public SendableEntityCreator generating(String rootDir, GraphModel model, TextItems parameters, SimpleList<BasicGenerator> templates, boolean writeFiles, boolean enableParser) {
        model.fixClassModel();
        String name = model.getName();
        if (name == null) {
            name = "i.love.sdmlib";
        }
        rootDir = this.getFileName(rootDir, name);
        TemplateResultModel resultModel = this.getResultModel();
        if (parameters == null) {
            parameters = new TextItems();
            parameters.withDefaultLabel(false);
        }
        resultModel.withLanguage(parameters);
        for (BasicGenerator template : templates) {
            template.withOwner(this);
        }
        FeatureProperty codeStyle = this.getFeature(Feature.CODESTYLE, new Clazz[0]);
        ClazzSet clazzes = model.getClazzes(new Condition[0]);
        for (Clazz clazz : clazzes) {
            for (BasicGenerator template : templates) {
                boolean isStandard;
                TemplateResultFile resultFile = template.executeClazz(clazz, resultModel, isStandard = codeStyle.match(clazz));
                if (resultFile == null) continue;
                resultFile.withMetaModel(template.isMetaModel());
                template.executeTemplate(resultFile, resultModel, clazz);
                resultModel.add(resultFile);
            }
        }
        for (BasicGenerator template : templates) {
            TemplateResultFile resultFile = template.executeEntity(model, resultModel, true);
            if (resultFile == null) continue;
            resultFile.withMetaModel(template.isMetaModel());
            template.executeTemplate(resultFile, resultModel, model);
            resultModel.add(resultFile);
        }
        if (writeFiles) {
            if (this.useSDMLibParser && enableParser) {
                for (TemplateResultFile file : resultModel) {
                    ParserEntity parser;
                    if (!file.isMetaModell() || (parser = this.parse(rootDir, file)) == null) continue;
                    parser.addMemberToModel();
                }
            }
            for (TemplateResultFile file : resultModel) {
                this.write(rootDir, file);
            }
        }
        return resultModel;
    }

    public boolean write(String rootPath, TemplateResultFile entity) {
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        return FileBuffer.writeFile(rootPath + entity.getFileName(), entity.toString()) >= 0;
    }

    public ParserEntity parse(String rootPath, TemplateResultFile entity) {
        CharacterBuffer content;
        if (entity == null || !(entity.getMember() instanceof Clazz)) {
            return null;
        }
        String fileName = entity.getFileName();
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((content = FileBuffer.readFile(rootPath + fileName)) != null) {
            ParserEntity parser = new ParserEntity();
            try {
                parser.parse(content, (Clazz)entity.getMember(), fileName);
                return parser;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Cant parse File:" + fileName);
            }
        }
        return null;
    }

    public boolean isSDMLibParser() {
        return this.useSDMLibParser;
    }

    public void withEnableSDMLibParser(boolean value) {
        this.useSDMLibParser = value;
    }

    @Override
    public FeatureProperty getFeature(Feature value, Clazz ... clazzes) {
        if (this.features != null) {
            for (FeatureProperty item : this.features) {
                if (!item.getName().equals((Object)value)) continue;
                if (clazzes == null) {
                    return item;
                }
                if (!item.match(clazzes)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return GraphModel.class;
    }

    public ModelGenerator withoutFeature(Feature feature) {
        this.features.without(new Object[]{feature});
        return this;
    }

    public ModelGenerator withFeature(FeatureProperty feature) {
        this.features.with(feature);
        return this;
    }

    public ModelGenerator withDefaultModel(GraphModel model) {
        this.defaultModel = model;
        return this;
    }

    public void testGeneratedCode(String type) {
        if (this.defaultModel != null) {
            if (type == null) {
                type = "java";
            }
            String rootDir = null;
            if ("java".equalsIgnoreCase(type)) {
                rootDir = "build/gen/java";
            } else if ("typescript".equalsIgnoreCase(type)) {
                rootDir = "build/gen/js";
            } else if ("cpp".equalsIgnoreCase(type)) {
                rootDir = "build/gen/cpp";
            }
            if (rootDir != null) {
                this.removeAllGeneratedCode(this.defaultModel, rootDir);
                this.generating(rootDir, type, this.defaultModel);
            }
        }
    }

    public void removeAllGeneratedCode(GraphModel model, String rootDir) {
        FeatureProperty codeStyle = this.getFeature(Feature.CODESTYLE, new Clazz[0]);
        if (!rootDir.endsWith("/")) {
            rootDir = rootDir + "/";
        }
        for (Clazz clazz : model.getClazzes(new Condition[0])) {
            boolean isStandard = codeStyle.match(clazz);
            for (BasicGenerator generator : this.javaGeneratorTemplates) {
                TemplateResultFile templateResult = generator.createResultFile(clazz, isStandard);
                templateResult.withPath(model.getName().replaceAll("\\.", "/"));
                FileBuffer.deleteFile(rootDir + templateResult.getFileName());
            }
        }
        String path = rootDir + (model.getName() + "/util").replaceAll("\\.", "/") + "/";
        String fileName = path + "CreatorCreator.java";
        FileBuffer.deleteFile(fileName);
    }

    public TemplateResultFragment parseTemplate(String templateString, GraphMember member) {
        Template template = new Template().withTemplate(templateString);
        return this.parseTemplate(template, member);
    }

    public TemplateResultFragment parseTemplate(Template template, GraphMember member) {
        TemplateResultModel model = new TemplateResultModel();
        model.withTemplate(this.getTemplates());
        model.withFeatures(this.features);
        TextItems parameters = new TextItems();
        parameters.withDefaultLabel(false);
        model.withLanguage(parameters);
        TemplateResultFragment generate = template.generate(model, parameters, member);
        return generate;
    }

    public Clazz parseSourceCode(CharacterBuffer content) {
        Clazz clazz = ParserEntity.create(content);
        return clazz;
    }

    public ModelGenerator withRootDir(String rootDir) {
        this.defaultRootDir = rootDir;
        return this;
    }

    public String getRootDir() {
        return this.defaultRootDir;
    }

    public Clazz findClazz(String name) {
        Clazz clazz = (Clazz)this.defaultModel.getChildByName(name, Clazz.class);
        if (clazz != null) {
            return clazz;
        }
        if (this.defaultRootDir == null) {
            return null;
        }
        CharacterBuffer buffer = FileBuffer.readFile(this.getFileName(this.defaultRootDir, name));
        return this.parseSourceCode(buffer);
    }

    public Attribute findAttribute(Clazz clazz, String name) {
        if (name == null) {
            return null;
        }
        AttributeSet attributes = clazz.getAttributes(new Condition[0]);
        for (Attribute a : attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Method findMethod(Clazz clazz, String name) {
        if (name == null) {
            return null;
        }
        MethodSet methods = clazz.getMethods(new Condition[0]);
        for (Method m : methods) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public Parameter findParameter(Method method, String name) {
        if (name == null) {
            return null;
        }
        ParameterSet parameters = method.getParameters(new Condition[0]);
        for (Parameter p : parameters) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public Clazz createClazz(String name) {
        return this.defaultModel.createClazz(name);
    }

    public boolean removeClazz(Clazz clazz) {
        return this.defaultModel.remove(clazz);
    }

    public void applyChange() {
        this.generate(this.defaultRootDir, this.defaultModel);
    }
}

