/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;

public class ByteConverterHex
extends ByteConverter {
    private static final String HEXVAL = "0123456789ABCDEF";
    public static String CONTROLCHARACTER = "abtnvfr";

    @Override
    public String toString(BufferedBuffer values) {
        return this.toString(values, 0);
    }

    public String toString(BufferedBuffer values, int space) {
        if (values == null) {
            return null;
        }
        CharacterBuffer returnValue = new CharacterBuffer().withBufferLength(values.length() << 1 + values.length() * space);
        String step = EntityUtil.repeat(' ', space);
        for (int i = 0; i < values.length(); ++i) {
            int value = values.byteAt(i);
            if (value < 0) {
                value += 256;
            }
            returnValue.with(HEXVAL.charAt(value / 16));
            returnValue.with(HEXVAL.charAt(value % 16));
            returnValue.with(step);
        }
        return returnValue.toString();
    }

    @Override
    public byte[] decode(CharSequence value) {
        if (value == null) {
            return null;
        }
        return ByteConverterHex.decoding(value, 0, value.length());
    }

    public static byte[] decoding(CharSequence value, int pos, int len) {
        byte[] out = new byte[len / 2];
        int n = len;
        for (int i = pos; i < n; i += 2) {
            int hn = HEXVAL.indexOf(value.charAt(i));
            int ln = HEXVAL.indexOf(value.charAt(i + 1));
            out[i / 2] = (byte)(hn << 4 | ln);
        }
        return out;
    }

    public static char fromHex(CharSequence value, int pos, int len) {
        byte[] bytes = ByteConverterHex.decoding(value, pos, len);
        if (len == 4) {
            return (char)((HEXVAL.indexOf(bytes[0]) << 24) + (HEXVAL.indexOf(bytes[1]) << 16) + (HEXVAL.indexOf(bytes[2]) << 8) + HEXVAL.indexOf(bytes[3]));
        }
        return (char)((HEXVAL.indexOf(bytes[1]) << 16) + (HEXVAL.indexOf(bytes[2]) << 8) + HEXVAL.indexOf(bytes[3]));
    }

    public static final String unQuoteControlCharacter(CharSequence value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length());
        int i = 0;
        int len = value.length();
        if (value.charAt(0) == '\"') {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\\') {
                int pos;
                if (i + 1 == len) {
                    sb.append('\\');
                    break;
                }
                if ((pos = CONTROLCHARACTER.indexOf(c = value.charAt(++i))) >= 0) {
                    sb.append(pos + 7);
                } else if (c == '\"') {
                    sb.append('\"');
                } else if (c == '9') {
                    sb.append(57);
                } else if (c == 'u') {
                    sb.append(ByteConverterHex.fromHex(value, i, i + 4));
                    i += 4;
                } else if (c == 'o') {
                    sb.append(ByteConverterHex.fromHex(value, i, i + 3));
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

