/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.ByteList;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.converter.ByteConverterHex;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class ByteEntity
implements ByteItem {
    public static final int BITOFBYTE = 8;
    public static final int TYPEBYTE = 1;
    public static final String TYPE = "TYPE";
    public static final String VALUE = "VALUE";
    protected byte type;
    protected byte[] values;

    public String toBinaryString() {
        if (this.values == null || this.values.length < 1) {
            return "";
        }
        byte[] result = new byte[this.values.length * 9 + 9];
        for (int z = 0; z < 8; ++z) {
            result[7 - z] = (byte)(this.type >> z & 1);
        }
        result[8] = 32;
        for (int i = 0; i < this.values.length; ++i) {
            for (int z = 0; z < 8; ++z) {
                result[i * 9 + 7 - z + 9] = (byte)(this.values[i] >> z & 1);
            }
            result[i * 9 + 8 + 9] = 32;
        }
        return new String(result);
    }

    public byte[] getValue() {
        if (this.values == null) {
            return null;
        }
        return EntityUtil.clone(this.values);
    }

    public ByteEntity withValue(byte type, byte[] value) {
        this.type = type;
        if (value != null) {
            this.values = EntityUtil.clone(value);
        }
        return this;
    }

    public ByteEntity withValue(byte type, byte value) {
        this.type = type;
        this.values = new byte[]{value};
        return this;
    }

    public ByteEntity withType(byte type) {
        this.type = type;
        return this;
    }

    public ByteEntity withValue(byte type, int value) {
        this.type = type;
        ByteBuffer msgValue = new ByteBuffer().withBufferLength(4);
        msgValue.put(value);
        this.values = msgValue.flip(true).array();
        return this;
    }

    public byte byteToUnsignedByte(int n) {
        if (n < 128) {
            return (byte)n;
        }
        return (byte)(n - 256);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Converter converter) {
        if (converter instanceof ByteConverter) {
            return this.toString((ByteConverter)converter, false);
        }
        return this.toString(new ByteConverterHex(), false);
    }

    @Override
    public String toString(ByteConverter converter, boolean dynamic) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        return converter.toString(this.getBytes(dynamic));
    }

    @Override
    public void writeBytes(ByteBuffer buffer, boolean isDynamic, boolean isLast, boolean isPrimitive) {
        byte[] value = this.values;
        int type = this.getType();
        if (value == null) {
            type = EntityUtil.getType((byte)type, 0, isLast);
            EntityUtil.writeByteHeader(buffer, (byte)type, 0);
            return;
        }
        if (isDynamic) {
            if (type == 48) {
                short bufferValue = new ByteBuffer().with(value).flip(true).getShort();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    type = 54;
                    value = new byte[]{(byte)bufferValue};
                }
            } else if (type == 49 || type == 50) {
                int bufferValue = new ByteBuffer().with(value).flip(true).getInt();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    type = 54;
                    value = new byte[]{(byte)bufferValue};
                } else if (bufferValue >= Short.MIN_VALUE && bufferValue <= Short.MAX_VALUE) {
                    type = 54;
                    ByteBuffer bbShort = ByteBuffer.allocate(2);
                    bbShort.put((short)bufferValue);
                    bbShort.flip(true);
                    value = bbShort.array();
                }
            }
        }
        if (!isPrimitive || type == 68 || type == 69) {
            type = EntityUtil.getType((byte)type, value.length, isLast);
            EntityUtil.writeByteHeader(buffer, (byte)type, value.length);
        }
        buffer.put(value);
    }

    @Override
    public ByteBuffer getBytes(boolean isDynamic) {
        int len = this.calcLength(isDynamic, true);
        ByteBuffer buffer = EntityUtil.getBuffer(len);
        this.writeBytes(buffer, isDynamic, true, false);
        buffer.flip(true);
        return buffer;
    }

    public boolean setValues(Object value) {
        int type = 0;
        ByteBuffer msgValue = new ByteBuffer();
        if (value == null) {
            type = 34;
        }
        if (value instanceof Short) {
            type = 48;
            msgValue.withBufferLength(2);
            msgValue.put((Short)value);
        } else if (value instanceof Integer) {
            type = 49;
            msgValue.withBufferLength(4);
            msgValue.put((Integer)value);
        } else if (value instanceof Long) {
            type = 50;
            msgValue.withBufferLength(8);
            msgValue.put((Long)value);
        } else if (value instanceof Float) {
            type = 51;
            msgValue.withBufferLength(4);
            msgValue.put(((Float)value).floatValue());
        } else if (value instanceof Double) {
            type = 52;
            msgValue.withBufferLength(8);
            msgValue.put((Double)value);
        } else if (value instanceof Byte) {
            type = 54;
            msgValue.withBufferLength(1);
            msgValue.put((Byte)value);
        } else if (value instanceof Character) {
            type = 64;
            msgValue.withBufferLength(2);
            msgValue.put(((Character)value).charValue());
        } else if (value instanceof String) {
            type = 74;
            String newValue = (String)value;
            msgValue.withBufferLength(newValue.length());
            try {
                msgValue.put(newValue.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (value instanceof Date) {
            type = 53;
            msgValue.withBufferLength(4);
            Date newValue = (Date)value;
            msgValue.put((int)newValue.getTime());
        } else if (value instanceof Byte[] || value instanceof byte[]) {
            type = 58;
            if (value != null) {
                byte[] newValue = (byte[])value;
                msgValue.withBufferLength(newValue.length);
                msgValue.put(newValue);
            }
        }
        if (type != 0) {
            this.type = (byte)type;
            msgValue.flip(true);
            this.values = msgValue.array();
            return true;
        }
        return false;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int calcLength(boolean isDynamic, boolean isLast) {
        if (this.values == null) {
            return 1;
        }
        if (isDynamic) {
            if (this.type == 48) {
                Short bufferValue = new ByteBuffer().with(this.values).flip(true).getShort();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    return 2;
                }
            } else if (this.type == 49 || this.type == 50) {
                Integer bufferValue = new ByteBuffer().with(this.values).flip(true).getInt();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    return 2;
                }
                if (bufferValue >= Short.MIN_VALUE && bufferValue <= Short.MAX_VALUE) {
                    return 3;
                }
            }
        }
        return 1 + EntityUtil.getTypeLen(this.type, this.values.length, isLast) + this.values.length;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new ByteEntity();
        }
        return new ByteList();
    }

    @Override
    public boolean isEmpty() {
        return this.getType() == 34;
    }

    @Override
    public int size() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public static ByteEntity create(Object value) {
        ByteEntity item = new ByteEntity();
        item.setValues(value);
        return item;
    }

    public static ByteEntity create(int type, Object value) {
        ByteEntity item = new ByteEntity();
        item.setValues(value);
        item.withType((byte)type);
        return item;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        if (values.length > 1) {
            byte[] value = new byte[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                value[i - 1] = (Byte)values[i];
            }
            this.withValue((byte)((Byte)values[0]), value);
        }
        return true;
    }

    public ByteEntity withValue(byte[] values) {
        if (values == null) {
            return this;
        }
        if (values.length > 1) {
            byte[] value = new byte[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                value[i - 1] = values[i];
            }
            this.type = values[0];
            this.values = value;
        }
        return this;
    }

    public Object getValue(Object key) {
        if (TYPE.equals(key)) {
            return this.type;
        }
        if (VALUE.equals(key)) {
            return this.values;
        }
        return null;
    }
}

