/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import java.util.List;

public class CharacterBuffer
extends BufferedBuffer
implements CharSequence,
BaseItem {
    char[] buffer;

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            return '\u0000';
        }
        return this.buffer[index += this.start];
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            return 0;
        }
        return (byte)this.buffer[(index += this.start) + this.start];
    }

    @Override
    public CharacterBuffer subSequence(int start, int end) {
        start += this.start;
        end += this.start;
        if (this.buffer == null) {
            return new CharacterBuffer();
        }
        if (start < 0) {
            start = this.position();
        }
        if (end < 0) {
            end = 0;
        }
        if (end > this.buffer.length) {
            end = this.buffer.length;
        }
        return new CharacterBuffer().with(this.buffer, start, end, false);
    }

    public CharacterBuffer withValue(String value) {
        if (value != null) {
            this.buffer = value.toCharArray();
            this.length = this.buffer.length;
            this.start = 0;
            this.position = 0;
        }
        return this;
    }

    public char[] toCharArray() {
        char[] result = new char[this.length];
        for (int i = this.start; i < this.length; ++i) {
            result[i] = this.buffer[i];
        }
        return result;
    }

    public boolean replace(int start, int end, String replace) {
        int pos = 0;
        int diff = replace.length() - (end - start);
        char[] oldChar = null;
        int oldStart = 0;
        int oldLen = 0;
        if (this.length + diff > this.buffer.length) {
            int newCapacity = (this.length + diff) * 2 + 2;
            oldChar = this.buffer;
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buffer, this.start, copy, 0, start);
            oldStart = end;
            oldLen = this.length - oldStart;
            this.buffer = copy;
            this.start = 0;
        }
        start += this.start;
        end += this.start;
        if (diff < 0) {
            while (start < end + diff) {
                this.buffer[start++] = replace.charAt(pos++);
            }
            System.arraycopy(this.buffer, end, this.buffer, start, this.length - end);
        } else {
            while (start < end) {
                this.buffer[start++] = replace.charAt(pos++);
            }
            if (diff > 0) {
                if (oldChar == null) {
                    oldLen = this.length + this.start - start;
                    oldChar = new char[oldLen];
                    System.arraycopy(this.buffer, start, oldChar, 0, oldLen);
                }
                for (int no = 0; no < diff; ++no) {
                    this.buffer[start++] = replace.charAt(pos++);
                }
                if (oldLen > 0) {
                    System.arraycopy(oldChar, oldStart, this.buffer, start, oldLen);
                }
            }
        }
        this.length += diff;
        this.position = 0;
        return true;
    }

    public void replace(char search, char replace) {
        int pos;
        int len = this.length + this.start;
        if (replace > '\u0000') {
            for (pos = this.position + this.start; pos < len; ++pos) {
                if (this.buffer[pos] != search) continue;
                this.buffer[pos] = replace;
            }
        } else {
            int offset = pos;
            while (pos < len) {
                if (this.buffer[pos] == search) {
                    --this.length;
                } else {
                    this.buffer[offset] = this.buffer[pos];
                    ++offset;
                }
                ++pos;
            }
        }
    }

    public boolean replace(String search, String replace) {
        if (search == null || search.length() < 1) {
            return false;
        }
        int deleted = 0;
        BufferedBuffer inserts = null;
        int pos = this.position + this.start;
        int len = this.length + this.start;
        int startSet = 0;
        while (pos < len) {
            int i;
            for (i = 0; i < search.length() && this.buffer[pos + i] == search.charAt(i); ++i) {
            }
            if (i == search.length()) {
                int diff = replace.length() - search.length();
                if (diff < 0) {
                    for (i = 0; i < replace.length(); ++i) {
                        this.buffer[pos + deleted + i] = replace.charAt(i);
                    }
                    deleted += diff;
                    pos += search.length();
                    continue;
                }
                if (inserts == null) {
                    for (i = 0; i < search.length(); ++i) {
                        this.buffer[pos + i] = replace.charAt(i);
                    }
                    inserts = new CharacterBuffer();
                    deleted += replace.length() - i;
                    startSet = pos += i;
                } else {
                    i = 0;
                    deleted += replace.length() - search.length();
                    pos += search.length();
                }
                while (i < replace.length()) {
                    ((CharacterBuffer)inserts).with(replace.charAt(i));
                    ++i;
                }
                continue;
            }
            if (deleted != 0) {
                if (deleted < 0) {
                    this.buffer[pos + deleted] = this.buffer[pos];
                } else {
                    ((CharacterBuffer)inserts).with(this.buffer[pos + i]);
                }
            }
            ++pos;
        }
        pos = pos + deleted - this.start;
        if (inserts != null) {
            if (this.length < pos) {
                char[] copy = new char[pos];
                System.arraycopy(this.buffer, this.start, copy, 0, startSet -= this.start);
                this.buffer = copy;
                this.start = 0;
            }
            for (int i = 0; i < inserts.length(); ++i) {
                this.buffer[startSet + i] = ((CharacterBuffer)inserts).charAt(i);
            }
        }
        this.length = pos;
        return true;
    }

    @Override
    public char getChar() {
        if (this.buffer == null) {
            return '\u0000';
        }
        if (this.position + this.start >= this.buffer.length) {
            return '\u0000';
        }
        if (this.position < this.length) {
            ++this.position;
        }
        if (this.position + this.start == this.buffer.length) {
            return '\u0000';
        }
        char c = this.buffer[this.position + this.start];
        return c;
    }

    public CharacterBuffer with(byte[] values) {
        if (values == null) {
            return this;
        }
        this.buffer = new char[values.length];
        this.start = 0;
        this.length = values.length;
        this.position = 0;
        for (int i = 0; i < values.length; ++i) {
            this.buffer[i] = (char)values[i];
        }
        return this;
    }

    public CharacterBuffer withLine(CharSequence value) {
        this.with(value);
        this.with("\r\n");
        return this;
    }

    @Override
    public CharacterBuffer withLength(int len) {
        this.withBufferLength(len);
        super.withLength(len);
        return this;
    }

    public CharacterBuffer withBufferLength(int len) {
        if (this.buffer == null) {
            this.buffer = new char[len];
        } else if (len + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[len];
            System.arraycopy(oldValue, this.start, this.buffer, 0, this.length);
            this.start = 0;
            this.position = 0;
        }
        return this;
    }

    public CharacterBuffer withStartPosition(int pos) {
        if (pos < 0) {
            return this;
        }
        int diff = pos - this.start;
        this.start = pos;
        this.length = this.length > diff ? (this.length -= diff) : 0;
        return this;
    }

    public CharacterBuffer with(char[] values, int start, int end, boolean copy) {
        if (copy) {
            this.buffer = new char[end];
            this.start = 0;
            this.position = 0;
            this.length = end;
            System.arraycopy(values, start, this.buffer, 0, end);
        } else {
            this.buffer = values;
            this.start = start;
            this.length = end - start;
        }
        return this;
    }

    @Override
    public CharacterBuffer with(char[] values, int start, int length) {
        if (values == null || start + length > values.length) {
            return this;
        }
        if (this.length < 0) {
            this.length = this.buffer.length;
        }
        int newLen = length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        System.arraycopy(values, start, this.buffer, this.length, length);
        this.length = newLen;
        return this;
    }

    public CharacterBuffer with(byte[] values, int start, int length) {
        int newLen = length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        int minusTag = 0;
        for (int i = start; i < length; ++i) {
            if (values[i] >= 0) {
                this.buffer[this.length + i - minusTag] = (char)values[i];
                continue;
            }
            byte b1 = values[i];
            byte b2 = values[i + 1];
            this.buffer[this.length + i - minusTag] = (char)(b1 << 6 ^ b2 ^ 0xF80);
            ++i;
            ++minusTag;
        }
        this.length = newLen - minusTag;
        return this;
    }

    public CharacterBuffer write(byte[] values, int length) {
        if (values == null) {
            return this;
        }
        if (this.length < 0) {
            this.length = this.buffer.length;
        }
        if (length > values.length) {
            length = values.length;
        }
        int newLen = length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, this.start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        for (int i = this.length; i < newLen; ++i) {
            this.buffer[i] = (char)values[i - this.length];
        }
        this.length = newLen;
        return this;
    }

    public CharacterBuffer with(CharSequence values, int start, int end) {
        if (values == null) {
            return this;
        }
        if (this.length < 0) {
            this.length = this.buffer.length;
        }
        if (this.buffer == null) {
            this.buffer = new char[end - start];
            this.length = this.buffer.length;
            this.position = 0;
            System.arraycopy(values, start, this.buffer, 0, this.length);
            start = 0;
        } else {
            if (this.length + values.length() > this.buffer.length) {
                int newCapacity = (this.length + values.length()) * 2 + 2;
                char[] copy = new char[newCapacity];
                System.arraycopy(this.buffer, this.start, copy, 0, this.length);
                this.buffer = copy;
                this.start = 0;
            }
            int len = values.length();
            for (int c = 0; c < len; ++c) {
                this.buffer[this.length + start + c] = values.charAt(c);
            }
            this.length += len;
        }
        return this;
    }

    @Override
    public CharacterBuffer with(CharSequence ... items) {
        if (items == null) {
            return this;
        }
        if (this.buffer == null) {
            int newCapubility = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                newCapubility += items[i].length();
            }
            this.buffer = new char[newCapubility];
            this.start = 0;
            this.length = this.buffer.length;
            int pos = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                int len = items[i].length();
                for (int c = 0; c < len; ++c) {
                    this.buffer[pos++] = items[i].charAt(c);
                }
            }
        } else {
            for (CharSequence item : items) {
                if (item == null) continue;
                this.with(item, 0, item.length());
            }
        }
        return this;
    }

    public CharacterBuffer with(int value) {
        String bytes = "" + value;
        this.with(bytes);
        return this;
    }

    public CharacterBuffer with(long value) {
        String bytes = "" + value;
        this.with(bytes);
        return this;
    }

    public CharacterBuffer withCollection(String splitter, Object ... values) {
        if (values == null) {
            return this;
        }
        int len = values.length;
        if (len < 1) {
            return this;
        }
        if (len == 1 && values[0] instanceof List) {
            List collection = (List)values[0];
            len = collection.size();
            this.add(collection.get(0));
            for (int i = 1; i < len; ++i) {
                this.with(splitter);
                this.add(collection.get(i));
            }
            return this;
        }
        this.add(values[0]);
        for (int i = 1; i < len; ++i) {
            this.with(splitter);
            this.add(values[i]);
        }
        return this;
    }

    public CharacterBuffer withStart(char item) {
        if (this.start > 0) {
            if (this.start > this.buffer.length) {
                this.start = this.buffer.length - 1;
            }
            this.buffer[--this.start] = item;
            return this;
        }
        char[] oldValue = this.buffer;
        this.buffer = new char[this.buffer.length + 1];
        this.buffer[0] = item;
        this.position = 0;
        System.arraycopy(oldValue, this.start, this.buffer, 1, this.length);
        ++this.length;
        return this;
    }

    public CharacterBuffer withStart(CharSequence item, boolean newLine) {
        if (item == null) {
            return this;
        }
        int len = item.length();
        if (newLine) {
            len += 2;
        }
        if (this.start > len) {
            if (newLine) {
                this.buffer[--this.start] = 10;
                this.buffer[--this.start] = 13;
            }
            for (int i = item.length() - 1; i >= 0; --i) {
                this.buffer[--this.start] = item.charAt(i);
            }
            return this;
        }
        char[] oldValue = this.buffer;
        this.buffer = this.buffer != null ? new char[this.buffer.length + len] : new char[len];
        for (int i = 0; i < item.length(); ++i) {
            this.buffer[i] = item.charAt(i);
        }
        if (newLine) {
            this.buffer[item.length()] = 13;
            this.buffer[item.length() + 1] = 10;
        }
        this.position = 0;
        if (oldValue != null) {
            System.arraycopy(oldValue, this.start, this.buffer, len, this.length);
            this.start = 0;
        }
        this.length += len;
        return this;
    }

    public CharacterBuffer set(CharSequence value) {
        this.start = 0;
        this.length = value.length();
        if (this.buffer == null || this.buffer.length < value.length()) {
            this.buffer = new char[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            this.buffer[i] = value.charAt(i);
        }
        return this;
    }

    public CharacterBuffer set(char value) {
        this.start = 0;
        this.length = 1;
        if (this.buffer.length < 1) {
            this.buffer = new char[1];
        }
        this.buffer[0] = value;
        return this;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0, false);
    }

    public boolean startsWith(CharSequence prefix, int toffset, boolean ignoreCase) {
        if (this.buffer == null) {
            return false;
        }
        char[] ta = this.buffer;
        int to = toffset + this.start;
        int pc = prefix.length();
        if (toffset < 0 || toffset > this.buffer.length - pc) {
            return false;
        }
        int po = 0;
        while (--pc >= 0) {
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = prefix.charAt(po++)) || ignoreCase && Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.start;
    }

    public char remove(int position) {
        char oldChar = this.buffer[position];
        if (position == this.start) {
            ++this.start;
            return this.buffer[position];
        }
        if (position != this.length - 1) {
            char[] copy = new char[this.buffer.length - 1];
            System.arraycopy(this.buffer, this.start, copy, 0, position);
            if (this.length - position - 1 > 0) {
                System.arraycopy(this.buffer, position + 1, copy, position, this.length - position - 1);
            }
            this.start = 0;
        }
        --this.length;
        return oldChar;
    }

    public CharacterBuffer trimStart(int pos) {
        this.start += pos;
        this.length -= pos;
        return this;
    }

    public CharacterBuffer trimEnd(int pos) {
        this.length -= pos;
        return this;
    }

    public CharacterBuffer rtrim(char ... items) {
        if (items != null) {
            while (this.length > 0) {
                if (this.buffer[this.length + this.start - 1] <= ' ') {
                    --this.length;
                    continue;
                }
                boolean found = false;
                for (int z = 0; z < items.length; ++z) {
                    if (this.buffer[this.length + this.start - 1] != items[z]) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                --this.length;
            }
            return this;
        }
        while (this.length > 0 && this.buffer[this.length + this.start - 1] <= ' ') {
            --this.length;
        }
        return this;
    }

    public CharacterBuffer trim() {
        while (this.length > 0 && this.buffer[this.length + this.start - 1] <= ' ') {
            --this.length;
        }
        while (this.start < this.length && this.buffer[this.start] <= ' ') {
            ++this.start;
            --this.length;
        }
        return this;
    }

    public boolean equalsText(char ... other) {
        if (other == null) {
            return true;
        }
        int pos = this.start;
        int l = 0;
        while (pos < this.length && l != other.length) {
            if (this.buffer[pos] == ' ' || this.buffer[pos] == '\t') {
                if (l == 0) {
                    ++pos;
                    continue;
                }
                if (other[l] != this.buffer[pos]) break;
                ++pos;
                ++l;
                continue;
            }
            if (other[l] == this.buffer[pos]) {
                ++pos;
                ++l;
                continue;
            }
            return false;
        }
        return l == other.length;
    }

    public double equalsLevenshtein(CharacterBuffer t) {
        int i;
        if (t == null || t.length() < 1) {
            return this.length();
        }
        if (this.length() < 1) {
            return t.length();
        }
        int n = this.length();
        int m = t.length();
        CharacterBuffer s = this;
        if (n > m) {
            s = t;
            t = this;
            n = m;
            m = this.length();
        }
        double[] p = new double[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        int containsPos = 1;
        boolean search = true;
        for (int j = 1; j <= m; ++j) {
            double upper_left = p[0];
            char t_j = t.charAt(j - 1);
            p[0] = j;
            search = true;
            for (i = 1; i <= n; ++i) {
                double cost;
                double upper = p[i];
                if (s.charAt(i - 1) == t_j) {
                    cost = 0.0;
                    if (containsPos == i) {
                        ++containsPos;
                        search = false;
                    }
                } else if (CharacterBuffer.toLower(t_j) == CharacterBuffer.toLower(s.charAt(i - 1))) {
                    containsPos = s.charAt(0) == t_j ? 2 : 1;
                    cost = 0.01;
                } else {
                    cost = 1.0;
                    if (containsPos == i && search) {
                        containsPos = s.charAt(0) == t_j ? 2 : 1;
                    }
                }
                p[i] = Math.min(Math.min(p[i - 1] + 1.0, p[i] + 1.0), upper_left + cost);
                upper_left = upper;
            }
        }
        if (containsPos > n) {
            return p[n] * -1.0;
        }
        return p[n];
    }

    private static char toLower(char item) {
        if (item >= 'A' && item <= 'Z') {
            item = (char)(item + 32);
            return item;
        }
        return item;
    }

    public boolean isEmptyCharacter() {
        int len;
        if (super.isEmpty()) {
            return true;
        }
        int pos = this.start;
        for (len = this.length; len > 0 && this.buffer[len + pos - 1] <= ' '; --len) {
        }
        while (pos < len && this.buffer[pos] <= ' ') {
            ++pos;
            --len;
        }
        return len == 0;
    }

    public void withRepeat(String string, int rest) {
        int newCapacity = this.length + rest * string.length();
        if (this.buffer == null) {
            this.buffer = new char[newCapacity];
            this.start = 0;
            this.length = 0;
        } else if (newCapacity > this.buffer.length) {
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buffer, this.start, copy, 0, this.length);
            this.buffer = copy;
            this.start = 0;
        }
        for (int i = 0; i < rest; ++i) {
            for (int c = 0; c < string.length(); ++c) {
                this.buffer[this.length++] = string.charAt(c);
            }
        }
    }

    public CharacterBuffer withObjects(Object ... items) {
        if (items == null) {
            return this;
        }
        if (this.buffer == null) {
            int newCapubility = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                if (!(items[i] instanceof CharSequence)) {
                    items[i] = items[i].toString();
                }
                newCapubility += ((CharSequence)items[i]).length();
            }
            this.buffer = new char[newCapubility];
            this.start = 0;
            this.length = this.buffer.length;
            int pos = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                CharSequence value = (CharSequence)items[i];
                int len = value.length();
                for (int c = 0; c < len; ++c) {
                    this.buffer[pos++] = value.charAt(c);
                }
            }
        } else {
            for (Object item : items) {
                CharSequence value = null;
                if (item instanceof CharSequence) {
                    value = (CharSequence)item;
                } else if (item != null) {
                    value = item.toString();
                }
                if (value == null) continue;
                this.with(value, 0, value.length());
            }
        }
        return this;
    }

    public CharacterBuffer with(char src) {
        if (this.buffer == null) {
            this.buffer = new char[5];
            this.start = 0;
            this.length = 1;
            this.buffer[0] = src;
        } else {
            if (this.length + 1 > this.buffer.length) {
                int newCapacity = this.buffer.length * 2 + 2;
                char[] copy = new char[newCapacity];
                System.arraycopy(this.buffer, this.start, copy, 0, this.length);
                this.buffer = copy;
                this.start = 0;
            }
            this.buffer[this.length++] = src;
        }
        return this;
    }

    public void trimSize() {
        char[] array = new char[this.length];
        System.arraycopy(this.buffer, this.start, array, 0, this.length);
        this.buffer = array;
        this.position = 0;
        this.start = 0;
    }

    @Override
    public String toString() {
        if (this.length < 1) {
            return "";
        }
        return new String(this.buffer, this.start, this.length);
    }

    public boolean equals(CharSequence other) {
        if (other == null || other.length() != this.length) {
            return false;
        }
        return this.startsWith(other, 0, false);
    }

    public boolean equalsIgnoreCase(CharSequence other) {
        if (other == null || other.length() != this.length) {
            return false;
        }
        return this.startsWith(other, 0, true);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(CharSequence value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.length) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (this.buffer[i + this.start] != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(CharSequence str, int fromIndex) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.length) {
            return -1;
        }
        if (str == null || str.length() == 0) {
            return -1;
        }
        int len = str.length() - 1;
        int pos = 0;
        for (int i = fromIndex; i < max; ++i) {
            if (this.buffer[i + this.start] == str.charAt(pos)) {
                if (pos == len) {
                    return i - pos;
                }
                ++pos;
                continue;
            }
            pos = 0;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        for (int i = this.length - 1; i >= this.start; --i) {
            if (this.buffer[i] != ch) continue;
            return i - this.start;
        }
        return -1;
    }

    public String getStringPart(Character start, Character end) {
        int count = 1;
        Character current = null;
        int pos = this.getCurrentChar() == start.charValue() ? this.position() : this.position() - 1;
        while (!this.isEnd()) {
            current = Character.valueOf(this.getChar());
            if (current.compareTo(end) == 0) {
                if (--count != 0) continue;
                this.skip();
                return this.subSequence(pos, this.position()).toString();
            }
            if (current.compareTo(start) != 0) continue;
            ++count;
        }
        return null;
    }

    public boolean endsWith(CharSequence string, boolean ignoreCase) {
        int pos = this.length() - string.length();
        if (pos < 0) {
            return false;
        }
        return this.startsWith(string, pos, ignoreCase);
    }

    public void setNextString(CharSequence property, int pos) {
        this.withLength(pos);
        this.start = 0;
        this.with(property);
    }

    public static CharacterBuffer create(CharSequence value) {
        if (value instanceof CharacterBuffer) {
            return (CharacterBuffer)value;
        }
        CharacterBuffer buffer = new CharacterBuffer();
        if (value instanceof String) {
            buffer.with(value);
        }
        return buffer;
    }

    public String toCurrentString() {
        if (this.length < 1) {
            return "";
        }
        return new String(this.buffer, this.position, this.length - this.position);
    }

    public CharacterBuffer insert(int offset, String values) {
        int len;
        if (offset < 0 || offset > this.length()) {
            return this;
        }
        if (values == null) {
            values = "null";
        }
        if (this.length + (len = values.length()) > this.buffer.length) {
            int newCapacity = (this.length + len) * 2 + 2;
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buffer, this.start, copy, 0, this.length);
            this.buffer = copy;
            this.start = 0;
        }
        System.arraycopy(this.buffer, offset, this.buffer, offset + len, this.length - offset);
        values.getChars(0, len, this.buffer, offset);
        this.length += len;
        return this;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return true;
        }
        boolean addValues = true;
        for (Object item : values) {
            if (item instanceof CharSequence) {
                this.with((CharSequence)item);
                continue;
            }
            if (item instanceof Character) {
                this.with(((Character)item).charValue());
                continue;
            }
            addValues = false;
        }
        return addValues;
    }

    @Override
    public void printError(String msg) {
        int endPos;
        int startPos = 0;
        if (this.position >= 10) {
            startPos = this.position - 10;
        }
        if ((endPos = this.position + 20) >= this.length()) {
            endPos = this.length();
        }
        if (msg != null && msg.length() > 0) {
            System.err.println(this.substring(startPos, this.position) + "<--" + msg + "-->" + this.substring(this.position, endPos));
        }
    }

    @Override
    public CharacterBuffer getNewList(boolean keyValue) {
        return new CharacterBuffer();
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public String toString(Converter converter) {
        return this.toString();
    }

    public CharacterBuffer newLine() {
        this.with("\r\n");
        return this;
    }

    public CharacterBuffer getLine(int pos) {
        CharacterBuffer buffer = new CharacterBuffer();
        if (pos > 0 && pos < this.length()) {
            int end;
            int start;
            for (start = pos; this.buffer[start] != '\r' && this.buffer[start] != '\n' && start > 0; --start) {
            }
            if (start > 0) {
                ++start;
            }
            for (end = pos; this.buffer[end] != '\r' && this.buffer[end] != '\n' && end < this.length; ++end) {
            }
            buffer.with(this.buffer, start, end - start);
        }
        return buffer;
    }
}

