/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.XMLEntity;

public class SoapObject
implements BaseItem,
SendableEntityCreatorTag {
    public static String XMLNS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static String XMLNS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static String XMLNS_SOAP = "http://schemas.xmlsoap.org/soap/envelope/";
    private String nameSpace = "s";
    public static final String PROPERTY_HEADER = "Header";
    public static final String PROPERTY_BODY = "BODY";
    private SimpleKeyValueList<String, String> headers;
    protected XMLEntity children;

    public SoapObject withBody(XMLEntity body) {
        this.children = body;
        return this;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public SoapObject withNameSpace(String value) {
        this.nameSpace = value;
        return this;
    }

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    protected String parseItem(EntityStringConverter converter) {
        if (converter == null) {
            return null;
        }
        CharacterBuffer sb = new CharacterBuffer();
        sb.with("<", this.nameSpace, ":Envelope xmlns:xsi=\"", XMLNS_XSI, "\" xmlns:xsd=\"", XMLNS_XSD, "\"");
        sb.with(" xmlns:", this.nameSpace, "=\"", XMLNS_SOAP, "\">");
        converter.add();
        sb.with(converter.getPrefix());
        sb.with("<", this.nameSpace, ":Body>");
        if (this.children != null) {
            sb.with(this.children.toString(converter));
        }
        sb.with("</", this.nameSpace, ":Body>");
        converter.minus();
        sb.with(converter.getPrefix());
        sb.with("</", this.nameSpace, ":Envelope>");
        return sb.toString();
    }

    public SoapObject withHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new SimpleKeyValueList();
        }
        this.headers.add(key, value);
        return this;
    }

    public SimpleKeyValueList<String, String> getHeader() {
        return this.headers;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        for (Object item : values) {
            if (item instanceof String) {
                this.withNameSpace((String)item);
                continue;
            }
            if (!(item instanceof XMLEntity)) continue;
            this.withBody((XMLEntity)item);
        }
        return true;
    }

    @Override
    public SoapObject getNewList(boolean keyValue) {
        return new SoapObject();
    }

    public Object getValue(Object key) {
        if (PROPERTY_HEADER.equals(key)) {
            return this.headers;
        }
        if (PROPERTY_BODY.equals(key)) {
            return this.children;
        }
        return null;
    }

    public XMLEntity getBody() {
        return this.children;
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof EntityStringConverter) {
            return this.parseItem((EntityStringConverter)converter);
        }
        return converter.encode(this);
    }

    @Override
    public String[] getProperties() {
        return new String[]{"." + this.nameSpace + ":" + PROPERTY_HEADER, "." + this.nameSpace + ":" + PROPERTY_BODY};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new SoapObject();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (attribute == null || !(entity instanceof SoapObject)) {
            return false;
        }
        if (attribute.endsWith(":Header")) {
            return ((SoapObject)entity).getHeader();
        }
        if (attribute.endsWith(":BODY")) {
            return ((SoapObject)entity).getBody();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (attribute == null || !(entity instanceof SoapObject)) {
            return false;
        }
        if ("<CHILDREN>".equals(type)) {
            ((SoapObject)entity).add(value);
            return true;
        }
        if (attribute.toLowerCase().endsWith(":" + PROPERTY_BODY.toLowerCase())) {
            ((SoapObject)entity).withBody(new XMLEntity().withValue("" + value));
            return true;
        }
        return false;
    }

    @Override
    public String getTag() {
        return this.nameSpace + ":Envelope";
    }

    @Override
    public int size() {
        if (this.children == null) {
            return 0;
        }
        return this.children.sizeChildren();
    }
}

