/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.Value;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.graph.util.MethodSet;
import de.uniks.networkparser.graph.util.ParameterSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorIndexId;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.xml.XMLContainer;
import de.uniks.networkparser.xml.XMLEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class EMFTokener
extends Tokener {
    public static final String ECORE = "ecore";
    public static final String EPACKAGE = "ecore:EPackage";
    public static final String EAttribute = "eAttributes";
    public static final String ECLASS = "eClassifiers";
    public static final String EANNOTATIONS = "eAnnotations";
    public static final String EREFERENCE = "eReferences";
    public static final String ETYPE = "eType";
    public static final String EDATATYPE = "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//";
    public static final String TYPE_ECLASS = "ecore:EClass";
    public static final String TYPE_EAttribute = "ecore:EAttribute";
    public static final String TYPE_EReferences = "ecore:EReference";
    public static final String TYPE_ESUPERTYPE = "eSuperTypes";
    public static final String TYPE_EEnum = "ecore:EEnum";
    public static final String EOpposite = "eOpposite";
    public static final String ATTRIBUTE_URL = "http://www.eclipse.org/emf/2002/Ecore#//";
    public static final String UPPERBOUND = "upperBound";
    public static final String XMI_TYPE = "xmi:type";
    public static final String XSI_TYPE = "xsi:type";
    public static final String XMI_ID = "xmi:id";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    SimpleKeyValueList<String, Integer> runningNumbers = new SimpleKeyValueList();
    SimpleKeyValueList<XMLEntity, SimpleKeyValueList<String, String>> notKey = new SimpleKeyValueList();

    protected void skipEntity(Buffer buffer) {
        buffer.skipTo('>', false);
        buffer.nextClean(false);
    }

    public String skipHeader(Buffer buffer) {
        CharacterBuffer tag;
        boolean skip = false;
        while ((tag = buffer.getString(2)) != null) {
            if (tag.equals("<?")) {
                this.skipEntity(buffer);
                skip = true;
            } else if (tag.equals("<!")) {
                this.skipEntity(buffer);
                skip = true;
            } else {
                skip = false;
            }
            if (skip) continue;
        }
        if (tag != null) {
            String item = tag.toString();
            buffer.withLookAHead(item);
            return item;
        }
        return "";
    }

    @Override
    public XMLEntity encode(Object entity, MapEntity map) {
        if (entity == null || map == null) {
            return null;
        }
        if (entity instanceof GraphList) {
            return this.encodeClassModel((GraphList)entity, map);
        }
        XMLEntity result = new XMLEntity();
        String typetag = entity.getClass().getName().replaceAll("\\.", ":");
        result.setType(typetag);
        this.encodeChildren(entity, result, map);
        return result;
    }

    public XMLEntity encodeClassModel(GraphList entity, MapEntity map) {
        String id;
        XMLContainer container = new XMLContainer();
        container.withStandardPrefix();
        if (entity == null || map == null) {
            return container;
        }
        XMLEntity root = container.createChild(EPACKAGE);
        root.withKeyValue("xmi:version", "2.0");
        root.withKeyValue("xmlns:xmi", "http://www.omg.org/XMI");
        root.withKeyValue("xmlns:ecore", "http://www.eclipse.org/emf/2002/Ecore");
        String name = "model";
        if (entity.getName() != null) {
            id = EntityUtil.shortClassName(entity.getName());
            name = entity.getName();
        } else {
            id = name;
        }
        root.withKeyValue(NAME, id);
        root.withKeyValue("nsURI", "http:///" + name.replace(".", "/") + ".ecore");
        root.withKeyValue("nsPrefix", name);
        for (Clazz child : entity.getClazzes(new Condition[0])) {
            XMLEntity ecoreClass = root.createChild(ECLASS);
            ecoreClass.withKeyValue(XSI_TYPE, TYPE_ECLASS);
            ecoreClass.withKeyValue(NAME, child.getName());
            for (Attribute attribute : child.getAttributes(new Condition[0])) {
                DataType type = attribute.getType();
                if (!EntityUtil.isPrimitiveType(type.getName(false))) continue;
                XMLEntity ecoreAttribute = ecoreClass.createChild(EAttribute);
                ecoreAttribute.withKeyValue(NAME, attribute.getName());
                ecoreAttribute.withKeyValue(ETYPE, "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//E" + EntityUtil.upFirstChar(type.getName(true)));
            }
            for (Association assoc : child.getAssociations(new Condition[0])) {
                XMLEntity ecoreAssociation = ecoreClass.createChild(EREFERENCE);
                ecoreAssociation.withKeyValue(NAME, assoc.getOther().getName());
                ecoreAssociation.withKeyValue(ETYPE, "#//" + assoc.getOtherClazz().getName());
                ecoreAssociation.withKeyValue(EOpposite, "#//" + assoc.getOtherClazz().getName() + "/" + assoc.getName());
                if (Cardinality.MANY.equals((Object)assoc.getCardinality())) {
                    ecoreAssociation.withKeyValue(UPPERBOUND, "-1");
                    continue;
                }
                ecoreAssociation.withKeyValue(UPPERBOUND, "1");
            }
        }
        return container;
    }

    private void encodeChildren(Object entity, XMLEntity parent, MapEntity map) {
        SendableEntityCreator creatorClass = this.getCreatorClass(entity);
        if (creatorClass == null) {
            return;
        }
        for (String propertyName : creatorClass.getProperties()) {
            Object propertyValue = creatorClass.getValue(entity, propertyName);
            if (EntityUtil.isPrimitiveType(EntityUtil.shortClassName(propertyValue.getClass().getName()))) {
                parent.put(propertyName, propertyValue);
                continue;
            }
            if (propertyValue instanceof Collection) {
                for (Object childValue : (Collection)propertyValue) {
                    XMLEntity child = new XMLEntity();
                    parent.withChild(child);
                    child.setType(propertyName);
                    String typetag = childValue.getClass().getName().replaceAll("\\.", ":");
                    child.put(XSI_TYPE, typetag);
                    this.encodeChildren(childValue, child, map);
                }
                continue;
            }
            XMLEntity child = new XMLEntity();
            parent.withChild(child);
            child.setType(propertyName);
            String typetag = propertyValue.getClass().getName().replaceAll("\\.", ":");
            child.put(XSI_TYPE, typetag);
            this.encodeChildren(propertyValue, child, map);
        }
    }

    public Object decode(MapEntity map, Buffer buffer, Object root) {
        SendableEntityCreator rootFactory;
        this.skipHeader(buffer);
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue(buffer);
        if (EPACKAGE.equals(xmlEntity.getTag())) {
            if (root instanceof GraphList) {
                return this.decoding(xmlEntity, (GraphList)((Object)root));
            }
            return this.decoding(xmlEntity, null);
        }
        String tag = xmlEntity.getTag();
        if (tag == null) {
            return null;
        }
        String[] splitTag = tag.split("\\:");
        if (splitTag.length < 2) {
            return null;
        }
        if (ECORE.equalsIgnoreCase(splitTag[0]) || root instanceof GraphModel) {
            GraphModel model = root == null || !(root instanceof GraphModel) ? new GraphList() : (GraphModel)((Object)root);
            return this.decodingClassModel(xmlEntity, model);
        }
        Object rootObject = null;
        if (root == null) {
            String className = splitTag[1];
            rootFactory = this.getCreator(className, false, null);
            rootObject = rootFactory != null ? rootFactory.getSendableInstance(false) : new ArrayList();
        } else {
            rootObject = root;
            rootFactory = this.getCreatorClass(root);
        }
        this.parsing(xmlEntity, rootFactory, rootObject, null);
        for (int i = 0; i < this.notKey.size(); ++i) {
            XMLEntity itemXmlEntity = (XMLEntity)this.notKey.get(i);
            SimpleKeyValueList<String, String> myRefs = this.notKey.getValueByIndex(i);
            String id = itemXmlEntity.getString(XMI_ID);
            Object item = this.getObject(id);
            SendableEntityCreator creator = this.getCreator(item.getClass().getName(), false, null);
            for (int r = 0; r < myRefs.size(); ++r) {
                String prop = (String)myRefs.get(r);
                String value = myRefs.getValueByIndex(r);
                SimpleList<String> refs = this.getRef(value, itemXmlEntity, creator);
                for (String ref : refs) {
                    Object object = this.getObject(ref);
                    if (object == null) continue;
                    creator.setValue(item, prop, object, "");
                }
            }
        }
        return rootObject;
    }

    private Object decodingClassModel(XMLEntity values, GraphModel model) {
        if (values == null || model == null) {
            return null;
        }
        SimpleKeyValueList<String, Clazz> items = new SimpleKeyValueList<String, Clazz>();
        for (int c = 0; c < values.sizeChildren(); ++c) {
            BaseItem item = values.getChild(c);
            if (!(item instanceof XMLEntity)) continue;
            XMLEntity child = (XMLEntity)item;
            String[] splitTag = child.getTag().split("\\:");
            String className = splitTag[1];
            Clazz clazz = (Clazz)items.get(className);
            if (clazz == null) {
                clazz = model.createClazz(className);
                items.add(className, clazz);
            }
            for (int i = 0; i < child.size(); ++i) {
                String key = (String)child.get(i);
                String value = (String)child.getValueByIndex(i);
                if (value == null) {
                    value = "";
                }
                if (!value.startsWith("/")) continue;
                AssociationSet associations = clazz.getAssociations(new Condition[0]);
                Association found = null;
                for (Association assoc : associations) {
                    if (!key.equals(assoc.getName())) continue;
                    found = assoc;
                    break;
                }
                if (found == null) {
                    found = new Association(clazz);
                    found.with(key);
                    SimpleList<String> refs = this.getRef(key, child, null);
                    for (String ref : refs) {
                        Association back = new Association((GraphEntity)items.get(ref));
                        found.with(back);
                    }
                }
                if (value.indexOf("/", 1) <= 0) continue;
                found.with(Cardinality.MANY);
            }
        }
        return model;
    }

    private SimpleList<String> getRef(String value, XMLEntity xmlEntity, SendableEntityCreator rootFactory) {
        SimpleList<String> result;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (value == null) {
                            return null;
                        }
                        result = new SimpleList<String>();
                        if (!value.startsWith("//@")) break block5;
                        for (String ref : value.split(" ")) {
                            String myRef = "_" + ref.substring(3);
                            myRef = myRef.indexOf(46) > 0 ? myRef.replaceAll("\\.|/@", "") : "_" + myRef.subSequence(0, 1) + "0";
                            result.add(myRef);
                        }
                        break block6;
                    }
                    if (!value.startsWith("/")) break block7;
                    String tagChar = xmlEntity.getTag().substring(0, 1);
                    for (String ref : value.split(" ")) {
                        ref = "_" + tagChar + ref.substring(1);
                        if (this.getObject(ref) == null) continue;
                        result.add(ref);
                    }
                    break block6;
                }
                if (value.indexOf(95) <= 0) break block8;
                for (String ref : value.split(" ")) {
                    if (this.getObject(ref) == null) continue;
                    result.add(ref);
                }
                break block6;
            }
            if (!value.startsWith("$")) break block6;
            for (String ref : value.split(" ")) {
                String myRef = "_" + ref.substring(1);
                if (rootFactory == null || this.getObject(myRef) == null) continue;
                result.add(myRef);
            }
        }
        return result;
    }

    private void parsing(XMLEntity xmlEntity, SendableEntityCreator entityFactory, Object entityObject, String rootId) {
        String tag;
        if (xmlEntity == null || this.map == null) {
            return;
        }
        String id = (String)xmlEntity.getValue(XMI_ID);
        Collection rootCollection = null;
        if (id == null) {
            String temp;
            tag = xmlEntity.getTag();
            if (rootId != null) {
                Integer num = this.runningNumbers.get(rootId = rootId + tag);
                if (num == null) {
                    num = 0;
                } else {
                    Integer n = num;
                    Integer n2 = num = Integer.valueOf(num + 1);
                }
                this.runningNumbers.put(rootId, num);
                rootId = rootId + num;
            } else {
                rootId = "$";
            }
            if (xmlEntity.has("href")) {
                String objectId;
                String refString = xmlEntity.getString("href");
                String[] split = refString.split("#//");
                if (split.length == 2) {
                    objectId = split[1];
                    objectId = objectId.replace('@', '_');
                    Iterator object = this.getObject(objectId = objectId.replace(".", ""));
                    if (object != null) {
                        if (entityObject instanceof Collection) {
                            rootCollection = (Collection)entityObject;
                        }
                        if (rootCollection != null) {
                            rootCollection.add(object);
                        } else {
                            entityFactory.setValue(entityObject, tag, object, "");
                        }
                        return;
                    }
                }
                if (split.length == 2) {
                    objectId = split[1];
                    objectId = objectId.replace('@', '$');
                    objectId = objectId.replace(".", "");
                    xmlEntity.put(XMI_ID, objectId);
                }
            }
            if (entityFactory instanceof SendableEntityCreatorIndexId && (temp = xmlEntity.getString("id")) != null) {
                rootId = temp;
            }
        }
        if (rootId.startsWith("$")) {
            rootId = "_" + rootId.substring(1);
        }
        this.map.put(rootId, entityObject, true);
        if (!xmlEntity.has(XMI_ID)) {
            xmlEntity.put(XMI_ID, rootId);
        }
        if (entityFactory != null) {
            block0: for (int i = 0; i < xmlEntity.size(); ++i) {
                String key = (String)xmlEntity.getKeyByIndex(i);
                String value = xmlEntity.getString(key);
                if (value == null || "".equals(value = value.trim()) || XMI_ID.equals(key)) continue;
                SimpleList<String> myRefs = this.getRef(value, xmlEntity, entityFactory);
                if (myRefs.size() == 0) {
                    entityFactory.setValue(entityObject, key, value, "");
                }
                for (String myRef : myRefs) {
                    Object object = this.getObject(myRef);
                    if (object != null) {
                        entityFactory.setValue(entityObject, key, object, "");
                        continue;
                    }
                    SimpleKeyValueList<String, String> list = this.notKey.get(xmlEntity);
                    if (list == null) {
                        list = new SimpleKeyValueList();
                        this.notKey.put(xmlEntity, list);
                    }
                    list.put(key, value);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < xmlEntity.sizeChildren(); ++i) {
            String typeName = null;
            XMLEntity kid = (XMLEntity)xmlEntity.getChild(i);
            tag = kid.getTag();
            if (entityObject instanceof Collection) {
                rootCollection = (Collection)entityObject;
                int pos = tag.indexOf(":");
                typeName = pos > 0 ? tag.substring(pos + 1) : tag;
            }
            if (kid.has(XSI_TYPE)) {
                typeName = kid.getString(XSI_TYPE);
                typeName = typeName.replaceAll(":", ".");
            }
            if (typeName == null) {
                Object value = entityFactory.getValue(entityObject, tag);
                if (value != null) {
                    if (value instanceof SimpleSet) {
                        SimpleSet set = (SimpleSet)value;
                        typeName = set.getTypClass().getName();
                    } else {
                        typeName = value.getClass().getName();
                    }
                } else {
                    typeName = tag;
                }
            }
            if (typeName == null) continue;
            SendableEntityCreator kidFactory = this.getCreator(typeName, false, null);
            if (kidFactory == null && typeName.endsWith("s")) {
                kidFactory = this.getCreator(typeName.substring(0, typeName.length() - 1), false, null);
            }
            if (kidFactory == null) continue;
            Object kidObject = kidFactory.getSendableInstance(false);
            this.parsing(kid, kidFactory, kidObject, rootId);
            if (rootCollection != null) {
                rootCollection.add(kidObject);
                continue;
            }
            entityFactory.setValue(entityObject, tag, kidObject, "");
        }
    }

    public GraphList decoding(String content) {
        return this.decoding(new XMLEntity().withValue(content), null);
    }

    public GraphList decoding(Tokener content, Buffer buffer) {
        return this.decoding(new XMLEntity().withValue(this, buffer), null);
    }

    /*
     * WARNING - void declaration
     */
    private GraphList decoding(XMLEntity ecore, GraphList model) {
        void var6_11;
        if (model == null) {
            model = new GraphList();
        }
        if (ecore == null) {
            return model;
        }
        SimpleList<XMLEntity> superClazzes = new SimpleList<XMLEntity>();
        SimpleKeyValueList parentList = new SimpleKeyValueList();
        for (int i = 0; i < ecore.sizeChildren(); ++i) {
            Entity childItem;
            BaseItem child;
            int c;
            XMLEntity xml;
            BaseItem baseItem = ecore.getChild(i);
            if (!(baseItem instanceof XMLEntity) || !(xml = (XMLEntity)baseItem).has(XSI_TYPE)) continue;
            if (xml.getString(XSI_TYPE).equalsIgnoreCase(TYPE_ECLASS)) {
                Clazz clazz = new Clazz(xml.getString(NAME));
                model.with(clazz);
                for (c = 0; c < xml.sizeChildren(); ++c) {
                    child = xml.getChild(c);
                    if (!(child instanceof Entity)) continue;
                    childItem = (Entity)child;
                    String typ = childItem.getString(XSI_TYPE);
                    if (typ.equals(TYPE_EAttribute)) {
                        String etyp = EntityUtil.getId(childItem.getString(ETYPE));
                        if (EntityUtil.isEMFType(etyp)) {
                            etyp = etyp.substring(1);
                        }
                        if (EntityUtil.isPrimitiveType(etyp.toLowerCase())) {
                            etyp = etyp.toLowerCase();
                        }
                        clazz.withAttribute(EntityUtil.toValidJavaId(childItem.getString(NAME)), DataType.create(etyp));
                        continue;
                    }
                    if (!typ.equals(TYPE_EReferences)) continue;
                    parentList.add(new Object[]{childItem, baseItem});
                }
                if (!xml.has(TYPE_ESUPERTYPE)) continue;
                superClazzes.add(xml);
                continue;
            }
            if (!xml.getString(XSI_TYPE).equals(TYPE_EEnum)) continue;
            Clazz graphEnum = new Clazz(xml.getString(NAME));
            GraphUtil.setClazzType(graphEnum, "enum");
            for (c = 0; c < xml.sizeChildren(); ++c) {
                child = ecore.getChild(i);
                if (!(child instanceof Entity)) continue;
                childItem = (Entity)child;
                Literal literal = new Literal(childItem.getString(NAME));
                for (int z = 0; z < childItem.size(); ++z) {
                    String key = childItem.getKeyByIndex(z);
                    if (key.equals(NAME)) continue;
                    literal.withValue(childItem.getValue(key));
                    GraphUtil.setLiteral(graphEnum, literal);
                }
            }
        }
        for (Entity entity : superClazzes) {
            String id = EntityUtil.getId(entity.getString(TYPE_ESUPERTYPE));
            Clazz kidClazz = model.getNode(entity.getString(NAME));
            if (kidClazz == null) continue;
            Clazz superClazz = model.getNode(id);
            kidClazz.withSuperClazz(superClazz);
        }
        SimpleKeyValueList<String, Association> items = new SimpleKeyValueList<String, Association>();
        boolean bl = false;
        while (var6_11 < parentList.size()) {
            Object upperValue;
            Entity eref = (Entity)parentList.get((int)var6_11);
            String tgtClassName = eref.getString(ETYPE);
            if (tgtClassName.indexOf("#") >= 0) {
                tgtClassName = tgtClassName.substring(tgtClassName.indexOf("#") + 3);
            }
            String tgtRoleName = eref.getString(NAME);
            Association tgtAssoc = this.getOrCreate(items, model, tgtClassName, tgtRoleName);
            if (eref.has(UPPERBOUND) && (upperValue = eref.getValue(UPPERBOUND)) instanceof Number && ((Number)upperValue).intValue() != 1) {
                tgtAssoc.with(Cardinality.MANY);
            }
            String srcRoleName = null;
            XMLEntity parent = (XMLEntity)parentList.getValueByIndex((int)var6_11);
            String srcClassName = parent.getString(NAME);
            if (eref.has(EOpposite)) {
                srcRoleName = EntityUtil.getId(eref.getString(EOpposite));
            }
            Association srcAssoc = this.getOrCreate(items, model, srcClassName, srcRoleName);
            tgtAssoc.with(srcAssoc);
            srcAssoc.with(AssociationTypes.EDGE);
            GraphUtil.setAssociation(tgtAssoc.getClazz(), tgtAssoc);
            GraphUtil.setAssociation(srcAssoc.getClazz(), srcAssoc);
            GraphUtil.setAssociation(model, tgtAssoc);
            ++var6_11;
        }
        return model;
    }

    private Association getOrCreate(SimpleKeyValueList<String, Association> items, GraphList model, String className, String roleName) {
        int pos;
        if (items == null) {
            return null;
        }
        if (className != null && (pos = className.indexOf("/")) > 0) {
            className = className.substring(pos + 1);
        }
        roleName = EntityUtil.toValidJavaId(roleName);
        String assocName = className + ":" + roleName;
        Association edge = (Association)items.getValue(assocName);
        if (edge == null) {
            Clazz clazz = model.getNode(className);
            if (clazz == null) {
                clazz = model.createClazz(className);
            }
            if (clazz != null) {
                edge = new Association(clazz).with(Cardinality.ONE).with(roleName);
                GraphUtil.setAssociation(clazz, edge);
                if (roleName != null) {
                    items.add(assocName, edge);
                }
            }
        }
        return edge;
    }

    public XMLEntity toXMI(GraphList list) {
        XMLContainer container = new XMLContainer();
        container.withStandardPrefix();
        if (list == null) {
            return container;
        }
        XMLEntity root = container.createChild("uml:Model");
        root.withKeyValue("xmlns:xmi", "http://www.omg.org/XMI");
        root.withKeyValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.withKeyValue("xmlns:uml", "http://www.eclipse.org/uml2/5.0.0/UML");
        root.withKeyValue("xmi:version", "2.0");
        root.withKeyValue(XMI_ID, list.getName());
        root.withKeyValue(NAME, "model");
        this.encodeAnnotations(root.createChild(null));
        ClazzSet clazzes = list.getClazzes(new Condition[0]);
        for (Clazz clazz : clazzes) {
            this.encodePackagedElementClass(root.createChild(null), clazz);
        }
        AssociationSet associations = list.getAssociations(new Condition[0]);
        for (Association assoc : associations) {
            this.encodeAssoc(root.createChild(null), assoc);
        }
        return container;
    }

    public XMLEntity toUML(GraphList list) {
        return this.toXMI(list);
    }

    public void encodePackagedElementClass(XMLEntity root, Clazz clazz) {
        if (clazz == null || root == null) {
            return;
        }
        root.setType("packagedElement");
        root.withKeyValue(XMI_ID, clazz.getId());
        root.withKeyValue(NAME, clazz.getName());
        root.withKeyValue("isAbstract", clazz.getModifier().has(Modifier.ABSTRACT));
        if ("interface".equals(clazz.getType())) {
            root.withKeyValue(XMI_TYPE, "uml:Interface");
        } else {
            root.withKeyValue(XMI_TYPE, clazz.getName());
            ClazzSet interfaces = clazz.getInterfaces(false);
            if (interfaces.size() > 0) {
                CharacterBuffer value = new CharacterBuffer();
                for (Clazz interfaceClazz : interfaces) {
                    if (value.length() > 0) {
                        value.with(' ');
                    }
                    value.with(interfaceClazz.getId());
                    XMLEntity interfaceChild = root.createChild("interfaceRealization");
                    interfaceChild.withKeyValue(XMI_TYPE, "uml:InterfaceRealization");
                    interfaceChild.withKeyValue(XMI_ID, interfaceClazz.getId());
                    interfaceChild.withKeyValue("supplier", clazz.getId());
                    interfaceChild.withKeyValue("client", interfaceClazz.getId());
                    interfaceChild.withKeyValue("contract", interfaceClazz.getId());
                }
                root.withKeyValue("clientDependency", value.toString());
            }
            ClazzSet superClazzes = clazz.getSuperClazzes(false);
            Iterator iterator = superClazzes.iterator();
            while (iterator.hasNext()) {
                Clazz superClazzesClazz = (Clazz)iterator.next();
                XMLEntity superClassChild = root.createChild("generalization");
                superClassChild.withKeyValue(XMI_TYPE, "uml:Generalization");
                superClassChild.withKeyValue(XMI_ID, superClazzesClazz.getId());
                superClassChild.withKeyValue("general", clazz.getId());
            }
        }
        AttributeSet attributes = clazz.getAttributes(new Condition[0]);
        for (Attribute attribute : attributes) {
            this.encodeOwnedValue(root.createChild(null), attribute);
        }
        MethodSet methods = clazz.getMethods(new Condition[0]);
        for (Method method : methods) {
            this.encodeOwnedOperation(root.createChild(null), method);
        }
    }

    public void encodeOwnedValue(XMLEntity root, Value value) {
        XMLEntity child;
        if (root == null || value == null) {
            return;
        }
        if (value instanceof Attribute) {
            root.setType("ownedAttribute");
        } else {
            root.setType("ownedParameter");
        }
        root.withKeyValue(XMI_TYPE, value.getType());
        root.withKeyValue(XMI_ID, value.getName());
        root.withKeyValue(NAME, value.getName());
        root.withKeyValue("visibility", value.getModifier());
        if (EntityUtil.isPrimitiveType(value.getType().getName(false))) {
            child = root.createChild("type");
            child.withKeyValue(XMI_TYPE, "uml:PrimitiveType");
            child.withKeyValue("href", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi" + value.getType().getName(false));
        } else {
            root.withKeyValue("type", value.getType().getName(false));
        }
        child = root.createChild("lowerValue");
        child.withKeyValue(XMI_TYPE, "uml:LiteralInteger");
        child.withKeyValue(XMI_ID, "_lv" + value.getName());
        child.withKeyValue(VALUE, "1");
        child = root.createChild("upperValue");
        child.withKeyValue(XMI_TYPE, "uml:LiteralUnlimitedNatural");
        child.withKeyValue(XMI_ID, "_uv" + value.getName());
        child.withKeyValue(VALUE, "1");
    }

    public void encodeOwnedOperation(XMLEntity root, Method method) {
        if (root == null || method == null) {
            return;
        }
        root.setType("ownedOperation");
        root.withKeyValue(XMI_ID, method.getName());
        root.withKeyValue(NAME, method.getName());
        root.withKeyValue("visibility", method.getModifier());
        ParameterSet parameter = method.getParameters(new Condition[0]);
        for (Parameter param : parameter) {
            this.encodeOwnedValue(root.createChild(null), param);
        }
        DataType returnType = method.getReturnType();
        if (!method.getReturnType().equals(DataType.VOID)) {
            XMLEntity child;
            XMLEntity returnChild = root.createChild("ownedParameter");
            returnChild.withKeyValue(XMI_ID, method.getReturnType().toString());
            returnChild.withKeyValue("direction", "return");
            if (EntityUtil.isPrimitiveType(returnType.toString())) {
                child = root.createChild("type");
                child.withKeyValue(XMI_TYPE, "uml:PrimitiveType");
                child.withKeyValue("href", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi" + returnType.toString());
            } else {
                returnChild.withKeyValue("type", returnType.toString());
            }
            child = root.createChild("lowerValue");
            child.withKeyValue(XMI_TYPE, "uml:LiteralInteger");
            child.withKeyValue(XMI_ID, "_lv" + returnType.toString());
            child.withKeyValue(VALUE, "1");
            child = root.createChild("upperValue");
            child.withKeyValue(XMI_TYPE, "uml:LiteralUnlimitedNatural");
            child.withKeyValue(XMI_ID, "_uv" + returnType.toString());
            child.withKeyValue(VALUE, "1");
        }
    }

    public void encodeAssoc(XMLEntity root, Association assoc) {
        if (root == null || assoc == null || assoc.getOther() == null) {
            return;
        }
        root.setType("packagedElement");
        root.withKeyValue(XMI_TYPE, (Object)assoc.getType());
        root.withKeyValue(XMI_ID, assoc.getName());
        root.withKeyValue(NAME, assoc.getName());
        root.withKeyValue("memberEnd", "_end-" + assoc.getName() + " _end-" + assoc.getOther().getName());
        this.encodeSubAssoc(root, assoc);
        this.encodeSubAssoc(root, assoc.getOther());
    }

    public void encodeSubAssoc(XMLEntity root, Association assoc) {
        if (root == null || assoc == null || assoc.getClazz() == null) {
            return;
        }
        XMLEntity child = root.createChild("ownedEnd");
        root.withKeyValue(XMI_TYPE, "uml:Property");
        root.withKeyValue(XMI_ID, assoc.getName());
        root.withKeyValue(NAME, assoc.getName());
        root.withKeyValue("type", assoc.getClazz().getId());
        root.withKeyValue("association", assoc.getName());
        XMLEntity childChild = child.createChild("lowerValue");
        childChild.withKeyValue(XMI_TYPE, "uml:LiteralInteger");
        childChild.withKeyValue(XMI_ID, assoc.getClazz().getId());
        childChild.withKeyValue(VALUE, "1");
        childChild = child.createChild("upperValue");
        childChild.withKeyValue(XMI_TYPE, "uml:LiteralUnlimitedNatural");
        childChild.withKeyValue(XMI_ID, assoc.getClazz().getId());
        if (assoc.getCardinality() == Cardinality.ONE) {
            childChild.withKeyValue(VALUE, "1");
        } else {
            childChild.withKeyValue(VALUE, "*");
        }
    }

    private void encodeAnnotations(XMLEntity child) {
        if (child == null) {
            return;
        }
        String modelid = "_modelid";
        child.setType(EANNOTATIONS);
        child.withKeyValue(XMI_ID, modelid);
        child.withKeyValue("source", "Objing");
        XMLEntity content = child.createChild("contents");
        content.withKeyValue(XMI_TYPE, "uml:Property");
        content.withKeyValue(XMI_ID, modelid);
        content.withKeyValue(NAME, "exporterVersion");
        XMLEntity value = content.createChild("defaultValue");
        value.withCloseTag();
        value.withKeyValue(XMI_TYPE, "uml:LiteralString");
        value.withKeyValue(XMI_ID, modelid);
        value.withKeyValue(VALUE, "3.0.0");
    }
}

