/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.AbstractList;
import java.util.Collection;
import java.util.Set;

public class SimpleSet<V>
extends AbstractList<V>
implements Set<V> {
    public static final String PROPERTY = "items";
    private ObjectCondition listener;

    @Override
    public SimpleSet<V> getNewList(boolean keyValue) {
        return new SimpleSet<V>();
    }

    @Override
    public boolean remove(Object o) {
        return super.removeByObject(o) >= 0;
    }

    public SimpleSet<V> clone() {
        return (SimpleSet)((AbstractArray)this.getNewList(false)).init(this);
    }

    @Override
    public SimpleSet<V> subList(int fromIndex, int toIndex) {
        return (SimpleSet)super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> values) {
        return super.addAll(index, values);
    }

    @Override
    public String toString() {
        CharacterBuffer buffer = new CharacterBuffer();
        buffer.with('(');
        return this.toBuffer(buffer, ", ").with(')').toString();
    }

    public String toString(String separator) {
        CharacterBuffer buffer = new CharacterBuffer();
        return this.toBuffer(buffer, separator).toString();
    }

    CharacterBuffer toBuffer(CharacterBuffer buffer, String separator) {
        int len = this.size();
        for (Object elem : this) {
            buffer.with(elem.toString());
            if (len > 1) {
                buffer.with(separator);
            }
            --len;
        }
        return buffer;
    }

    @Override
    public V set(int index, V element) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("set(" + index + ")");
        }
        return super.set(index, element);
    }

    @Override
    public void add(int index, V element) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("add(" + index + ")");
        }
        super.add(index, element);
    }

    @Override
    public V remove(int index) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("remove(" + index + ")");
        }
        return super.remove(index);
    }

    @Override
    public boolean add(V newValue) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("add()");
        }
        return super.add(newValue);
    }

    public <ST extends SimpleSet<V>> ST union(Collection<? extends V> other) {
        BaseItem result = this.getNewList(false);
        ((AbstractList)result).addAll(this);
        ((AbstractList)result).addAll(other);
        return (ST)result;
    }

    public <ST extends SimpleSet<V>> ST intersection(Collection<? extends V> other) {
        BaseItem result = this.getNewList(false);
        ((AbstractList)result).addAll(this);
        ((AbstractArray)result).retainAll(other);
        return (ST)result;
    }

    public <ST extends AbstractList<?>> ST instanceOf(ST target) {
        for (Object obj : this) {
            if (obj == null || obj.getClass() != target.getTypClass()) continue;
            target.with(obj);
        }
        return target;
    }

    public <ST extends SimpleSet<V>> ST minus(Object other) {
        BaseItem result = this.getNewList(false);
        ((AbstractList)result).addAll(this);
        if (other instanceof Collection) {
            ((AbstractArray)result).removeAll((Collection)other);
        } else {
            ((SimpleSet)result).remove(other);
        }
        return (ST)result;
    }

    public SimpleSet<V> withListener(ObjectCondition listener) {
        this.listener = listener;
        return this;
    }

    @Override
    protected boolean fireProperty(String type, Object oldElement, Object newElement, Object beforeElement, int index, Object value) {
        if (this.listener != null) {
            this.listener.update(new SimpleEvent(type, this, PROPERTY, index, newElement, oldElement, value, beforeElement));
        }
        return super.fireProperty(type, oldElement, newElement, beforeElement, index, value);
    }
}

