/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.CharacterBuffer;

public class StringContainer
implements CharSequence {
    CharSequence value;
    private static final String EMPTY = "";

    @Override
    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        return this.value.length() == 0;
    }

    @Override
    public int length() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length();
    }

    public int capacity() {
        return this.value.length();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return EMPTY;
        }
        return this.value.toString();
    }

    public CharSequence getValue() {
        return this.value;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public CharSequence substring(int start) {
        return this.substring(start, this.value.length());
    }

    public CharSequence substring(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > this.value.length()) {
            end = this.value.length();
        }
        if (start > end) {
            return EMPTY;
        }
        return new CharacterBuffer().with(this.value, start, end);
    }

    public CharSequence split(int start) {
        if (this.value instanceof CharacterBuffer) {
            ((CharacterBuffer)this.value).trimStart(start);
        } else {
            this.value = new CharacterBuffer().with(this.value, start, this.value.length());
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.value.length() - suffix.length());
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        if (this.value instanceof String) {
            return ((String)this.value).startsWith(prefix, toffset);
        }
        if (this.value instanceof CharacterBuffer) {
            return ((CharacterBuffer)this.value).startsWith(prefix, toffset, false);
        }
        return this.value.toString().startsWith(prefix, toffset);
    }

    public final StringContainer with(CharSequence src) {
        if (this.value == null) {
            this.value = src;
        } else if (this.value instanceof CharacterBuffer) {
            ((CharacterBuffer)this.value).with(src);
        } else {
            this.value = new CharacterBuffer().with(this.value).with(src);
        }
        return this;
    }

    public final StringContainer with(char src) {
        if (this.value == null) {
            this.value = new CharacterBuffer().with(src);
        } else if (this.value instanceof CharacterBuffer) {
            ((CharacterBuffer)this.value).with(src);
        } else {
            this.value = new CharacterBuffer().with(this.value).with(src);
        }
        return this;
    }

    public char remove(int position) {
        if (this.value == null) {
            return '\u0000';
        }
        if (this.value instanceof CharacterBuffer) {
            return ((CharacterBuffer)this.value).remove(position);
        }
        String newString = this.value.toString();
        char oldChar = newString.charAt(position);
        this.value = position == 0 ? newString.substring(1) : (position == this.value.length() ? newString.substring(0, position - 1) : newString.substring(0, position - 1) + newString.substring(position + 1));
        return oldChar;
    }

    public CharSequence trim() {
        if (this.value == null) {
            return this.value;
        }
        if (this.value instanceof CharacterBuffer) {
            return ((CharacterBuffer)this.value).trim();
        }
        this.value = this.value.toString().trim();
        return this.value;
    }
}

