/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.list.SimpleList;
import java.util.List;

public class TextDiff {
    public static final char NEW = '+';
    public static final char NONE = ' ';
    public static final char CHANGE = '#';
    public static final char REMOVE = '-';
    public static final String TO = "->";
    private String key;
    private char type;
    private Object left;
    private Object right;
    private SimpleList<TextDiff> children;

    public TextDiff with(String key, Object left, Object right) {
        this.left = left;
        this.right = right;
        this.key = key;
        this.type = left == null ? (right == null ? (char)32 : (char)43) : (right == null ? (char)45 : (left.equals(right) ? (char)32 : (char)35));
        return this;
    }

    public TextDiff replaceChild(TextDiff last, String key, Object left, Object right) {
        TextDiff lastChild = null;
        if (this.children != null) {
            TextDiff child = new TextDiff();
            child.with(key, left, right);
            int size = this.children.size();
            int pos = 0;
            if (last != null) {
                pos = this.children.indexOf(last);
            }
            for (int i = pos; i < size; ++i) {
                lastChild = (TextDiff)this.children.get(pos);
                this.children.remove(pos);
                child.withChild(lastChild);
            }
            this.children.add(child);
        }
        return lastChild;
    }

    public TextDiff getLast() {
        if (this.children != null) {
            return (TextDiff)this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public TextDiff withChild(TextDiff child) {
        if (this.children == null) {
            this.children = new SimpleList();
        }
        this.children.add(child);
        return this;
    }

    public TextDiff withChild(String key, char type, TextDiff child) {
        if (this.children == null) {
            this.children = new SimpleList();
        }
        this.key = key;
        this.type = type;
        this.children.add(child);
        return this;
    }

    public TextDiff createChild(String key, Object left, Object right) {
        TextDiff child = new TextDiff();
        if (this.children == null) {
            this.children = new SimpleList();
        }
        this.children.add(child);
        child.with(key, left, right);
        return child;
    }

    public Object getLeft() {
        return this.left;
    }

    public Object getRight() {
        return this.right;
    }

    public char getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString(0, true));
        return sb.toString();
    }

    public String toString(int indentFactor, boolean splitAddAndRemove) {
        CharacterBuffer sb = new CharacterBuffer();
        if (this.children != null) {
            int newIndent = indentFactor;
            if (this.type != '\u0000' && this.key != null) {
                sb.with(this.type);
                sb.withRepeat(" ", indentFactor);
                sb.with(this.key);
                sb.with("\r\n");
                newIndent += 2;
            }
            for (TextDiff diff : this.children) {
                sb.with(diff.toString(newIndent, splitAddAndRemove));
            }
        } else {
            if (this.key != null) {
                sb.with(this.type);
                sb.withRepeat(" ", indentFactor);
                sb.with(this.key + ":");
            }
            if ('#' == this.type) {
                sb.with("" + this.left);
                sb.with(TO);
                sb.with("" + this.right);
            } else if ('+' == this.type) {
                if (splitAddAndRemove) {
                    sb.with(this.splitValue(this.right, this.type).toString(indentFactor, false));
                } else {
                    sb.with("" + this.right);
                }
            } else if (splitAddAndRemove) {
                sb.with(this.splitValue(this.left, this.type).toString(indentFactor, false));
            } else {
                sb.with("" + this.left);
            }
            sb.with("\r\n");
        }
        return sb.toString();
    }

    private TextDiff splitValue(Entity item, char type) {
        TextDiff diff = new TextDiff();
        for (int i = 0; i < item.size(); ++i) {
            String key = item.getKeyByIndex(i);
            Object value = item.getValue(key);
            if (value instanceof Entity) {
                diff.withChild(key, type, this.splitValue((Entity)value, type));
                continue;
            }
            if (value instanceof List) {
                diff.withChild(key, type, this.splitValue((List)value, type));
                continue;
            }
            if ('+' == type) {
                diff.createChild(key, null, value);
                continue;
            }
            diff.createChild(key, value, null);
        }
        return diff;
    }

    private TextDiff splitValue(Object item, char type) {
        if (item instanceof Entity) {
            return this.splitValue((Entity)item, type);
        }
        if (item instanceof List) {
            return this.splitValue((List)item, type);
        }
        TextDiff diff = new TextDiff();
        if ('+' == type) {
            diff.createChild(null, null, item);
        } else {
            diff.createChild(null, item, null);
        }
        return diff;
    }

    private TextDiff splitValue(List<?> item, char type) {
        TextDiff diff = new TextDiff();
        for (int i = 0; i < item.size(); ++i) {
            Object value = item.get(i);
            if (value instanceof Entity) {
                diff.withChild(null, type, this.splitValue((Entity)value, type));
                continue;
            }
            if (value instanceof List) {
                diff.withChild(null, type, this.splitValue((List)value, type));
                continue;
            }
            if ('+' == type) {
                diff.createChild(null, null, value);
                continue;
            }
            diff.createChild(null, value, null);
        }
        return diff;
    }
}

