/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.sql;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.ext.sql.SQLStatement;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLTable
extends SimpleList<Object> {
    private String table;
    private boolean simple;

    public static SQLTable create(ResultSet executeQuery, SQLStatement statement, boolean dynamic) {
        AbstractArray<?> values = statement.getValues();
        String[] properties = new String[values.size()];
        String property = null;
        int counter = 0;
        SimpleIterator i = new SimpleIterator(values);
        while (i.hasNext()) {
            properties[counter] = property = (String)i.next();
            ++counter;
        }
        return SQLTable.create(executeQuery, properties, statement.getTable(), dynamic);
    }

    public static SQLTable create(ResultSet executeQuery, SendableEntityCreator creator) {
        Object prototype = creator.getSendableInstance(true);
        String tableName = prototype instanceof Class ? EntityUtil.shortClassName(((Class)prototype).getName()) : EntityUtil.shortClassName(prototype.getClass().getName());
        return SQLTable.create(executeQuery, creator.getProperties(), tableName, false);
    }

    public SimpleList<Object> getColumnValue(String column) {
        SimpleList<Object> values = new SimpleList<Object>();
        if (this.simple) {
            return this;
        }
        for (Object item : this) {
            if (!(item instanceof SimpleKeyValueList)) continue;
            SimpleKeyValueList row = (SimpleKeyValueList)item;
            values.add(row.get(column));
        }
        return values;
    }

    public static SQLTable create(ResultSet executeQuery, String[] properties, String table, boolean isDynamicResult) {
        SQLTable sqlTable = new SQLTable();
        sqlTable.withTable(table);
        if (isDynamicResult && properties.length != 1) {
            isDynamicResult = false;
        }
        if (properties != null) {
            try {
                if (isDynamicResult) {
                    String prop = properties[0];
                    while (executeQuery.next()) {
                        sqlTable.add(executeQuery.getObject(prop));
                    }
                    sqlTable.withSimple(true);
                } else {
                    while (executeQuery.next()) {
                        SimpleKeyValueList<String, Object> row = new SimpleKeyValueList<String, Object>();
                        for (String prop : properties) {
                            row.add(prop, executeQuery.getObject(prop));
                        }
                        sqlTable.add(row);
                    }
                }
            }
            catch (SQLException e) {
                System.out.println(e);
            }
        }
        return sqlTable;
    }

    private SQLTable withTable(String value) {
        this.table = value;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public SQLTable withSimple(boolean value) {
        this.simple = value;
        return this;
    }
}

