/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.interfaces.ObjectCondition;

public class NodeProxyLocal
extends NodeProxy {
    public static final String PROPERTY_ID = "id";
    private String id;
    private ObjectCondition listener;

    @Override
    protected boolean sending(Message msg) {
        boolean result = super.sending(msg);
        if (this.listener != null) {
            String blob = this.space.convertMessage(msg);
            SimpleEvent evt = new SimpleEvent(msg, "sendtime", null, blob);
            return this.listener.update(evt);
        }
        return result;
    }

    public String getID() {
        return this.id;
    }

    public NodeProxyLocal withListener(ObjectCondition value) {
        this.listener = value;
        return this;
    }

    public NodeProxyLocal withID(String value) {
        String oldValue = value;
        this.id = value;
        this.firePropertyChange(PROPERTY_ID, oldValue, value);
        return this;
    }

    @Override
    public String getKey() {
        return this.id;
    }

    @Override
    public Object getValue(Object element, String attrName) {
        if (element instanceof NodeProxyLocal) {
            NodeProxyLocal nodeProxy = (NodeProxyLocal)element;
            if (PROPERTY_ID.equals(attrName)) {
                return nodeProxy.getID();
            }
        }
        return super.getValue(element, attrName);
    }

    @Override
    public boolean setValue(Object element, String attrName, Object value, String type) {
        if (element instanceof NodeProxyLocal) {
            NodeProxyLocal nodeProxy = (NodeProxyLocal)element;
            if (PROPERTY_ID.equals(attrName)) {
                nodeProxy.withID((String)value);
                return true;
            }
        }
        return super.setValue(element, attrName, value, type);
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    protected boolean initProxy() {
        this.type = "OUT";
        return true;
    }

    @Override
    public boolean isSendable() {
        return false;
    }

    public static NodeProxyLocal create(ObjectCondition listener) {
        NodeProxyLocal proxy = new NodeProxyLocal();
        proxy.withListener(listener);
        return proxy;
    }

    @Override
    public Object getSendableInstance(boolean reference) {
        return new NodeProxyLocal();
    }
}

