/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.petaf.Space;
import java.util.TimerTask;

public class SimpleTimerTask
extends TimerTask {
    protected final ErrorHandler handler = new ErrorHandler();
    protected Runnable task;
    protected Space space;
    protected DateTimeEntity lastRun;
    private Thread simpleExit;

    public SimpleTimerTask(Thread simpleExit) {
        this.simpleExit = simpleExit;
    }

    public SimpleTimerTask(Space space) {
        this.handler.addListener(space);
        this.space = space;
    }

    public SimpleTimerTask withDateTime(DateTimeEntity entity) {
        this.lastRun = entity;
        return this;
    }

    public SimpleTimerTask withSimpleExit(Thread value) {
        this.simpleExit = value;
        return this;
    }

    public DateTimeEntity getLastRun() {
        return this.lastRun;
    }

    @Override
    public void run() {
        if (this.simpleExit != null) {
            this.simpleExit.interrupt();
        }
        try {
            this.updateLastRun();
            this.runTask();
        }
        catch (Exception e) {
            this.handler.saveException(e, false);
        }
    }

    public void updateLastRun() {
        if (this.lastRun != null) {
            this.lastRun.withValue(System.currentTimeMillis());
        }
        if (this.space != null) {
            this.space.withLastTimerRun(this.lastRun);
        }
    }

    public boolean runTask() throws Exception {
        if (this.task != null) {
            this.task.run();
            return true;
        }
        return false;
    }

    public SimpleTimerTask withTask(Runnable task) {
        this.task = task;
        return this;
    }

    public Space getSpace() {
        return this.space;
    }
}

