/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.controller;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.controller.ModelListenerInterface;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.SendableEntity;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.Collection;

public class ModelListenerProperty
implements ModelListenerInterface {
    protected Object item;
    protected String property;
    protected SendableEntityCreator creator;
    private SimpleSet<Object> listeners = new SimpleSet();
    private SimpleSet<Object> invalidationListeners = new SimpleSet();
    protected Object observable = null;
    protected Condition<SimpleEvent> callBack;
    protected PROPERTYTYPE type;

    public ModelListenerProperty(SendableEntityCreator creator, Object item, String property, PROPERTYTYPE type) {
        this.creator = creator;
        this.property = property;
        this.item = item;
        this.type = type;
        if (item == null) {
            return;
        }
        if (item instanceof SendableEntity) {
            ((SendableEntity)item).addPropertyChangeListener(property, this);
            return;
        }
        if (item instanceof PropertyChangeSupport) {
            ((PropertyChangeSupport)item).addPropertyChangeListener(property, this);
            return;
        }
        try {
            Method method = item.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            method.invoke(item, property, this);
            return;
        }
        catch (ReflectiveOperationException method) {
            try {
                Method method2 = item.getClass().getMethod("getPropertyChangeSupport", new Class[0]);
                PropertyChangeSupport pc = (PropertyChangeSupport)method2.invoke(item, new Object[0]);
                pc.addPropertyChangeListener(property, this);
                return;
            }
            catch (ReflectiveOperationException method2) {
                try {
                    Method method3 = item.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    method3.invoke(item, this);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    @Override
    public Object getBean() {
        return this.item;
    }

    @Override
    public boolean setBean(Object value) {
        if (value != this.item) {
            this.item = value;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.property;
    }

    @Override
    public void addListener(Object listener) {
        if (ReflectionLoader.CHANGELISTENER != null && ReflectionLoader.CHANGELISTENER.isAssignableFrom(listener.getClass())) {
            this.listeners.add(listener);
        }
        if (ReflectionLoader.INVALIDATIONLISTENER != null && ReflectionLoader.INVALIDATIONLISTENER.isAssignableFrom(listener.getClass())) {
            this.invalidationListeners.add(listener);
        }
    }

    @Override
    public void removeListener(Object listener) {
        if (ReflectionLoader.CHANGELISTENER != null && ReflectionLoader.CHANGELISTENER.isAssignableFrom(listener.getClass())) {
            this.listeners.remove(listener);
        }
        if (ReflectionLoader.INVALIDATIONLISTENER != null && ReflectionLoader.INVALIDATIONLISTENER.isAssignableFrom(listener.getClass())) {
            this.invalidationListeners.remove(listener);
        }
    }

    @Override
    public void bind(Object newObservable) {
        if (newObservable == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (!newObservable.equals(this.observable)) {
            this.unbind();
            this.observable = newObservable;
            ReflectionLoader.call(this.observable, "addListener", ReflectionLoader.INVALIDATIONLISTENER, this);
        }
    }

    @Override
    public void bindBidirectional(Object other) {
        ReflectionLoader.call("bindBidirectional", null, ReflectionLoader.PROPERTY, this, ReflectionLoader.PROPERTY, other);
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            ReflectionLoader.call(this.observable, "removeListener", ReflectionLoader.OBSERVABLEVALUE, this);
            this.observable = null;
        }
    }

    @Override
    public void unbindBidirectional(Object other) {
        ReflectionLoader.call("unbindBidirectional", null, ReflectionLoader.PROPERTY, this, ReflectionLoader.PROPERTY, other);
    }

    @Override
    public Object getItemValue() {
        Object value = this.creator.getValue(this.item, this.property);
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (Object v : this.listeners) {
            Object event = ReflectionLoader.newInstance(ReflectionLoader.SIMPLEOBJECTPROPERTY, new Object[0]);
            Object oldValue = this.parseValue(evt.getOldValue());
            Object newValue = this.parseValue(evt.getNewValue());
            ReflectionLoader.call(v, "changed", ReflectionLoader.OBSERVABLEVALUE, event, Object.class, oldValue, Object.class, newValue);
        }
        for (Object v : this.invalidationListeners) {
            ReflectionLoader.call(v, "invalidated", ReflectionLoader.INVALIDATIONLISTENER, this);
        }
        this.executeCallBack();
    }

    @Override
    public void executeCallBack() {
        SimpleEvent event;
        if (this.callBack != null && this.callBack.update(event = new SimpleEvent(this.item, this.property, null, this.getItemValue()))) {
            ReflectionLoader.call(this.observable, "set", String.class, "" + event.getModelValue());
        }
    }

    @Override
    public ModelListenerProperty withCallBack(Condition<SimpleEvent> listener) {
        this.callBack = listener;
        return this;
    }

    @Override
    public void invalidated(Object observable) {
    }

    @Override
    public Object getValue() {
        return this.getItemValue();
    }

    public Object parseValue(Object value) {
        if (this.type == PROPERTYTYPE.COLOR) {
            if (value != null && ReflectionLoader.COLOR.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (value instanceof String) {
                return ReflectionLoader.call((Object)PROPERTYTYPE.COLOR, "web", String.class, value);
            }
            return ReflectionLoader.call((Object)PROPERTYTYPE.COLOR, "web", String.class, "#FFFFFF");
        }
        if (this.type == PROPERTYTYPE.STRING) {
            return "" + value;
        }
        if (this.type == PROPERTYTYPE.BOOLEAN) {
            if (value instanceof Boolean) {
                return value;
            }
            return Boolean.valueOf("" + value);
        }
        if (this.type == PROPERTYTYPE.INTEGER) {
            if (value instanceof Integer) {
                return value;
            }
            return Integer.valueOf("" + value);
        }
        if (this.type == PROPERTYTYPE.LONG) {
            if (value instanceof Long) {
                return value;
            }
            return Long.valueOf("" + value);
        }
        if (this.type == PROPERTYTYPE.FLOAT) {
            if (value instanceof Float) {
                return value;
            }
            return Float.valueOf("" + value);
        }
        if (this.type == PROPERTYTYPE.DOUBLE) {
            if (value instanceof Double) {
                return value;
            }
            return Double.valueOf("" + value);
        }
        if (value instanceof Number) {
            return value;
        }
        return value;
    }

    @Override
    public Object getProxy() {
        return ReflectionLoader.createProxy(this, ModelListenerInterface.class, ReflectionLoader.PROPERTY);
    }

    @Override
    public void setValue(Object value) {
        this.creator.setValue(this.item, this.property, value, "new");
    }

    public static enum PROPERTYTYPE {
        STRING,
        COLOR,
        BOOLEAN,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        OBJECT;

    }
}

