/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.ext.JSEditor;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.JsonObjectLazy;
import de.uniks.networkparser.gui.BridgeCommand;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.gui.JavaBridge;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.File;
import java.util.concurrent.CountDownLatch;

public class JavaAdapter
implements JavaViewAdapter,
Runnable {
    private SimpleKeyValueList<Object, String> callBack = new SimpleKeyValueList();
    protected JavaBridge owner;
    protected Object webView;
    protected Object webEngine;
    private SimpleList<String> queue = new SimpleList();
    public static final String TYPE_EXPORT = "EXPORT";
    public static final String TYPE_EDITOR = "EDITOR";
    public static final String TYPE_EXPORTALL = "EXPORTALL";
    public static final String TYPE_CONTENT = "CONTENT";
    protected String type = "EXPORT";
    private HTMLEntity entity;

    @Override
    public JavaAdapter withOwner(JavaBridge owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public boolean load(Object item) {
        if (item instanceof String) {
            ReflectionLoader.call(this.webEngine, "load", item);
            return true;
        }
        if (item instanceof File) {
            File file = (File)item;
            if (!file.exists()) {
                System.out.println("FILE NOT FOUND");
            }
            ReflectionLoader.call(this.webEngine, "load", file.toURI().toString());
            return true;
        }
        if (!(item instanceof HTMLEntity)) {
            return false;
        }
        HTMLEntity entity = (HTMLEntity)item;
        if (TYPE_CONTENT.equalsIgnoreCase(this.type)) {
            ReflectionLoader.call(this.webEngine, "loadContent", entity.toString());
            return true;
        }
        XMLEntity headers = entity.getHeader();
        for (int i = 0; i < headers.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)headers.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag())) continue;
            Object value = child.getValue("src");
            if (value != null) {
                this._execute(this.readFile("" + value), false);
                continue;
            }
            this._execute(child.getValue(), false);
        }
        XMLEntity body = entity.getHeader();
        for (int i = 0; i < body.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)body.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag()) || child.has("src")) continue;
            this._execute(child.getValue(), false);
        }
        Object engine = this.getWebEngine();
        if (engine == null) {
            this.entity = entity;
            try {
                ReflectionLoader.call(ReflectionLoader.PLATFORM, "startup", Runnable.class, this);
            }
            catch (Throwable e) {
                JavaAdapter.execute(this);
            }
            return true;
        }
        this.registerListener(this);
        ReflectionLoader.call(this.webEngine, "loadContent", String.class, entity.toString());
        return true;
    }

    @Override
    public void run() {
        this.registerListener(this);
        ReflectionLoader.call(this.webEngine, "loadContent", String.class, this.entity.toString());
    }

    public boolean registerListener(ObjectCondition listener) {
        Object engine = this.getWebEngine();
        if (engine != null) {
            Object stateProperty = ReflectionLoader.callChain(this.webEngine, "getLoadWorker", "stateProperty");
            GUIEvent eventListener = new GUIEvent().withListener(listener);
            Object proxy = ReflectionLoader.createProxy(eventListener, ReflectionLoader.CHANGELISTENER, ReflectionLoader.EVENTHANDLER);
            ReflectionLoader.call(stateProperty, "addListener", ReflectionLoader.CHANGELISTENER, proxy);
            ReflectionLoader.call(this.webEngine, "setOnError", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(this.webEngine, "setOnAlert", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(this.webView, "setOnDragExited", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(this.webView, "setOnDragOver", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(this.webView, "setOnDragDropped", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(this.webView, "setOnDragDone", ReflectionLoader.EVENTHANDLER, proxy);
        }
        return true;
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            JsonObject data = new JsonObject().withValue("" + value);
            this.owner.fireEvent(data);
            return true;
        }
        if (ReflectionLoader.JSOBJECT.isAssignableFrom(value.getClass())) {
            GUIEvent event = GUIEvent.create(value);
            this.owner.fireEvent(event);
            return true;
        }
        return false;
    }

    public boolean changed(SimpleEvent event) {
        if ("SUCCEEDED".equals("" + event.getNewValue())) {
            this.loadFinish();
            return true;
        }
        return false;
    }

    public void showAlert(String value) {
        if (value != null && value.length() > 0) {
            System.err.println(value);
        }
    }

    public boolean executeChange(String value) {
        this.owner.setApplyingChangeMSG(true);
        JsonObject json = JsonObject.create(value);
        IdMap map = this.owner.getMap();
        Object encode = map.decode(json);
        if (encode == null) {
            SimpleObject newItem = SimpleObject.create(json);
            map.put(newItem.getId(), newItem, false);
        }
        this.owner.setApplyingChangeMSG(false);
        return true;
    }

    @Override
    public String readFile(String file) {
        if (file == null) {
            return "";
        }
        FileBuffer buffer = new FileBuffer().withFile(file);
        return buffer.toString();
    }

    @Override
    public Object executeScript(String script) {
        this.owner.logScript(script, 4, this, "executeScript");
        if (this.queue != null) {
            this.queue.add(script);
        }
        if (!this.isFXThread()) {
            JavaAdapter.execute(new JSEditor(this).withScript(script));
            return null;
        }
        return this._execute(script, true);
    }

    public Object executeScript(String script, boolean convert) {
        this.owner.logScript(script, 4, this, "executeScript");
        if (this.queue != null) {
            this.queue.add(script);
        }
        return this._execute(script, convert);
    }

    private Object _execute(String script, boolean convert) {
        Object jsObject = ReflectionLoader.call(this.getWebEngine(), "executeScript", String.class, script);
        if (convert && jsObject != null && ReflectionLoader.JSOBJECT.isAssignableFrom(jsObject.getClass())) {
            JsonObject item = this.convertJSObject(jsObject);
            return item;
        }
        return jsObject;
    }

    private JsonObject convertJSObject(Object element) {
        JsonObjectLazy result = new JsonObjectLazy(element);
        result.lazyLoad();
        return result;
    }

    public boolean isFXThread() {
        Object result = ReflectionLoader.call(ReflectionLoader.PLATFORM, "isFxApplicationThread", new Object[0]);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public Object getWebView() {
        Object result;
        if (this.webView == null && ReflectionLoader.WEBVIEW != null && Boolean.TRUE.equals(result = ReflectionLoader.call(ReflectionLoader.PLATFORM, "isFxApplicationThread", new Object[0]))) {
            this.webView = ReflectionLoader.newInstance(ReflectionLoader.WEBVIEW, new Object[0]);
            this.webEngine = ReflectionLoader.call(this.webView, "getEngine", new Object[0]);
            ReflectionLoader.call(this.webView, "setMaxSize", Double.TYPE, Double.MAX_VALUE, Double.TYPE, Double.MAX_VALUE);
        }
        return this.webView;
    }

    @Override
    public Object getWebEngine() {
        if (this.webEngine == null) {
            this.getWebView();
        }
        return this.webEngine;
    }

    protected void addAdapter(ObjectCondition eventListener) {
        JsonObjectLazy executeScript = (JsonObjectLazy)this._execute("bridge.addAdapter(new DiagramJS.DelegateAdapter());", true);
        if (executeScript != null) {
            Object reference = executeScript.getReference();
            ReflectionLoader.call(reference, "setAdapter", Object.class, eventListener);
        }
    }

    @Override
    public void loadFinish() {
        this.addAdapter(this);
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                String command = (String)this.queue.remove(0);
                this._execute(command, false);
            }
        }
        this.queue = null;
    }

    public boolean addListener(Control control, EventTypes type, String functionName, Object callBackClazz) {
        this.owner.addControl(control);
        String id = control.getId();
        if (callBackClazz != null) {
            String callBackName = this.getCallBackName(callBackClazz);
            this.executeScript(BridgeCommand.register(type, id, callBackName + "." + functionName));
            return true;
        }
        this.executeScript("bridge.registerListener(" + (Object)((Object)type) + ", \"" + id + "\");");
        return true;
    }

    public String getCallBackName(Object clazz) {
        String callBackName = this.callBack.get(clazz);
        Object window = this._execute("window", false);
        if (callBackName == null) {
            callBackName = "_callBack" + (this.callBack.size() + 1);
            this.callBack.put(clazz, callBackName);
            ReflectionLoader.call(window, "setMember", String.class, callBackName, Object.class, clazz);
        }
        return callBackName;
    }

    public static void execute(Runnable runnable) {
        ReflectionLoader.call(ReflectionLoader.PLATFORM, "startup", Runnable.class, runnable);
    }

    public static void executeAndWait(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (((Boolean)ReflectionLoader.call(ReflectionLoader.PLATFORM, "isFxApplicationThread", new Object[0])).booleanValue()) {
            runnable.run();
            return;
        }
        final CountDownLatch doneLatch = new CountDownLatch(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    doneLatch.countDown();
                }
            }
        };
        JavaAdapter.execute(task);
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void enableDebug() {
        String firebugLite = "http://getfirebug.com/releases/lite/1.2/firebug-lite-compressed.js";
        String script = "if (!document.getElementById('FirebugLite')) {var E = document['createElementNS'] && document.documentElement.namespaceURI;E = E ? document.createElementNS(E, 'script') : document.createElement('script');E.setAttribute('id', 'FirebugLite');E.setAttribute('src', '" + firebugLite + "');E.setAttribute('FirebugLite', '4');(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(E);}";
        String script2 = "console.log = function(message) { java.log(message); }";
        Object result = ReflectionLoader.call(ReflectionLoader.PLATFORM, "isFxApplicationThread", new Object[0]);
        if (this.webEngine == null || !Boolean.TRUE.equals(result)) {
            JSEditor editor = new JSEditor(this).withScript(script);
            JavaAdapter.execute(editor);
            editor = new JSEditor(this).withScript(script2);
            JavaAdapter.execute(editor);
            return;
        }
        this.executeScript(script);
        this.executeScript(script2);
    }
}

