/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.bytes.ByteEntity;
import de.uniks.networkparser.bytes.ByteTokener;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyBroker;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RabbitMessage {
    public static final byte NULL = 0;
    public static final byte FRAME_METHOD = 1;
    public static final byte FRAME_HEADER = 2;
    public static final byte FRAME_BODY = 3;
    public static final byte FRAME_HEARTBEAT = 8;
    public static final short CONNECTION_CLASS = 10;
    public static final short CHANNEL_CLASS = 20;
    public static final short ACCESS_CLASS = 30;
    public static final short EXCHANGE_CLASS = 40;
    private static final short QUEUE_CLASS = 50;
    private static final short BASIC_CLASS = 60;
    private static final short CONFIRM_CLASS = 85;
    private static final short TX_CLASS = 90;
    public static final short STARTOK_METHOD = 11;
    public static final short TUNE_METHOD = 30;
    public static final short TUNEOK_METHOD = 31;
    public static final short OPEN_METHOD = 40;
    public static final short OPENCHANNEL_METHOD = 10;
    public static final short PUBLISH_METHOD = 40;
    public static final short CREATE_QUEUE_METHOD = 10;
    public static final short CONSUME_METHOD = 20;
    public static final byte BIT = 1;
    public static final byte BYTE = 2;
    public static final byte SHORT = 3;
    public static final byte INT = 4;
    public static final byte LONG = 5;
    public static final byte SHORTSTR = 6;
    public static final byte STRING = 7;
    public static final byte VERSION = 8;
    public static final byte TABLE = 9;
    private byte[] headers = new byte[3];
    private static final byte FRAME_END = -50;
    private ByteBuffer payload;
    private ByteBuffer accumulator;
    private Map<String, Object> table;
    private short classId;
    private short methodId;
    private SimpleKeyValueList<String, Object> payloadData = new SimpleKeyValueList();
    private boolean needBitFlush;
    private byte bitAccumulator;
    private int bitMask;

    public RabbitMessage withShortString(String value) {
        this.withValues(ByteEntity.create(75, value));
        return this;
    }

    public RabbitMessage withValues(Object ... args) {
        if (this.accumulator == null) {
            this.accumulator = new ByteBuffer();
            if (this.getType() != 3) {
                this.accumulator.insert(new byte[4], true);
            }
            if (this.table != null || 10 == this.classId && 11 == this.methodId) {
                this.writeMap(this.table);
            }
        }
        if (args != null) {
            for (Object item : args) {
                if (item instanceof Boolean) {
                    this.withBit((Boolean)item);
                    continue;
                }
                this.writeValue(item);
            }
        }
        return this;
    }

    public RabbitMessage withEmptyValues() {
        if (this.accumulator == null) {
            this.accumulator = new ByteBuffer();
            this.accumulator.insert(new byte[4], true);
        }
        this.writeValue(null);
        return this;
    }

    public RabbitMessage withMap(Map<String, Object> map) {
        this.table = map;
        return this;
    }

    public RabbitMessage writeMap(Map<?, ?> map) {
        if (map == null) {
            this.accumulator.insert((byte)0, true);
        } else {
            Set<?> keySet = map.keySet();
            for (Object key : keySet) {
                if (!(key instanceof String)) continue;
                byte[] keyStr = ((String)key).getBytes();
                this.accumulator.insert((byte)keyStr.length, true);
                this.accumulator.insert(keyStr, true);
                this.writeFieldValue(map.get(key));
            }
        }
        return this;
    }

    public boolean writeValue(Object value) {
        if (value == null) {
            this.accumulator.insert((byte)0, true);
            return true;
        }
        if (value instanceof ByteEntity) {
            ByteEntity entity = (ByteEntity)value;
            byte type = entity.getType();
            byte group = EntityUtil.getGroup(type);
            byte subgroup = EntityUtil.getSubGroup(type);
            if (group == 74) {
                byte[] bytes = entity.getValue();
                if (subgroup == 1) {
                    this.accumulator.insert((byte)bytes.length, true);
                } else {
                    this.accumulator.insert(bytes.length, true);
                }
                this.accumulator.insert(bytes, true);
            }
        }
        if (value instanceof String) {
            byte[] bytes = ((String)value).getBytes();
            this.accumulator.insert(bytes.length, true);
            this.accumulator.insert(bytes, true);
            return true;
        }
        if (value instanceof Integer || value instanceof Byte || value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Short || value instanceof Boolean) {
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            this.accumulator.insert(date.getTime() / 1000L, true);
            return true;
        }
        if (value instanceof Map) {
            this.writeMap((Map)value);
            return true;
        }
        if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            this.accumulator.insert(array.length, true);
            this.accumulator.insert(array, true);
            return true;
        }
        if (value instanceof List || value instanceof Object[]) {
            int pos = this.accumulator.position();
            this.accumulator.insert(1, true);
            if (value instanceof List) {
                List list = (List)value;
                for (Object item : list) {
                    this.writeFieldValue(item);
                }
            } else {
                Object[] list;
                for (Object item : list = (Object[])value) {
                    this.writeFieldValue(item);
                }
            }
            int newPos = this.accumulator.position();
            this.accumulator.withPosition(pos);
            this.accumulator.put(newPos - pos);
            this.accumulator.withPosition(newPos);
            return true;
        }
        return false;
    }

    public boolean writeFieldValue(Object value) {
        if (value == null) {
            this.accumulator.insert(Character.valueOf('V'), true);
            return true;
        }
        if (value instanceof String) {
            this.accumulator.insert(Character.valueOf('S'), true);
            byte[] bytes = ((String)value).getBytes();
            this.accumulator.insert(bytes.length, true);
            this.accumulator.insert(bytes, true);
            return true;
        }
        if (value instanceof Integer) {
            this.accumulator.insert(Character.valueOf('I'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Date) {
            this.accumulator.insert(Character.valueOf('T'), true);
            Date date = (Date)value;
            this.accumulator.insert(date.getTime() / 1000L, true);
            return true;
        }
        if (value instanceof Map) {
            this.accumulator.insert(Character.valueOf('F'), true);
            this.writeMap((Map)value);
            return true;
        }
        if (value instanceof Byte) {
            this.accumulator.insert(Character.valueOf('b'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Double) {
            this.accumulator.insert(Character.valueOf('d'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Float) {
            this.accumulator.insert(Character.valueOf('f'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Long) {
            this.accumulator.insert(Character.valueOf('l'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Short) {
            this.accumulator.insert(Character.valueOf('s'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof Boolean) {
            this.accumulator.insert(Character.valueOf('t'), true);
            this.accumulator.insert(value, true);
            return true;
        }
        if (value instanceof byte[]) {
            this.accumulator.insert(Character.valueOf('x'), true);
            byte[] array = (byte[])value;
            this.accumulator.insert(array.length, true);
            this.accumulator.insert(array, true);
            return true;
        }
        if (value instanceof List || value instanceof Object[]) {
            this.accumulator.insert(Character.valueOf('A'), true);
            int pos = this.accumulator.position();
            this.accumulator.insert(1, true);
            if (value instanceof List) {
                List list = (List)value;
                for (Object item : list) {
                    this.writeFieldValue(item);
                }
            } else {
                Object[] list;
                for (Object item : list = (Object[])value) {
                    this.writeFieldValue(item);
                }
            }
            int newPos = this.accumulator.position();
            this.accumulator.withPosition(pos);
            this.accumulator.put(newPos - pos);
            this.accumulator.withPosition(newPos);
            return true;
        }
        return false;
    }

    public RabbitMessage withFrame(short classId, short methodId) {
        this.classId = classId;
        this.methodId = methodId;
        return this;
    }

    public byte getType() {
        return this.headers[0];
    }

    public RabbitMessage withType(byte value) {
        this.headers[0] = value;
        return this;
    }

    public RabbitMessage withChannel(short value) {
        this.headers[1] = (byte)(value >>> 8);
        this.headers[2] = (byte)value;
        return this;
    }

    public short getChannel() {
        short result = this.headers[1];
        result = (short)(result << 8 + this.headers[2]);
        return result;
    }

    public boolean write(OutputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.write(this.headers);
            if (this.accumulator != null) {
                int length = this.accumulator.length();
                if (this.getType() != 3) {
                    this.accumulator.set(0, (byte)(this.classId >> 8 & 0xFF));
                    this.accumulator.set(1, (byte)(this.classId & 0xFF));
                    this.accumulator.set(2, (byte)(this.methodId >> 8 & 0xFF));
                    this.accumulator.set(3, (byte)(this.methodId & 0xFF));
                    stream.write(ByteTokener.intToByte(length));
                }
                stream.write(this.accumulator.array(), 0, length);
            } else if (this.payload != null) {
                stream.write(this.payload.length());
                stream.write(this.payload.array());
            }
            stream.write(-50);
            stream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("WRONG MESSGAE: " + this.getDebugString());
            return false;
        }
        return true;
    }

    public String getDebugString() {
        ByteBuffer errorMessage = new ByteBuffer();
        errorMessage.insert(this.headers, true);
        if (this.accumulator != null) {
            int length = this.accumulator.length();
            if (this.getType() != 3) {
                this.accumulator.set(0, (byte)(this.classId >> 8 & 0xFF));
                this.accumulator.set(1, (byte)(this.classId & 0xFF));
                this.accumulator.set(2, (byte)(this.methodId >> 8 & 0xFF));
                this.accumulator.set(3, (byte)(this.methodId & 0xFF));
                errorMessage.insert(ByteTokener.intToByte(length), true);
            }
            errorMessage.addBytes(this.accumulator.array(), length, false);
        } else if (this.payload != null) {
            errorMessage.insert(this.payload.length(), true);
            errorMessage.insert(this.payload.array(), true);
        }
        errorMessage.insert((byte)-50, false);
        errorMessage.flip(false);
        return errorMessage.toArrayString(new boolean[0]);
    }

    public static RabbitMessage readFrom(DataInputStream is) throws IOException {
        byte type = (byte)is.readUnsignedByte();
        if (type == 65) {
            return null;
        }
        short channel = (short)is.readUnsignedShort();
        int payloadSize = is.readInt();
        byte[] payload = new byte[payloadSize];
        is.readFully(payload);
        byte frameEndMarker = (byte)is.readUnsignedByte();
        if (frameEndMarker != -50) {
            return null;
        }
        RabbitMessage msg = new RabbitMessage();
        msg.withType(type);
        msg.withChannel(channel);
        msg.withPayload(payload);
        return msg;
    }

    public RabbitMessage withPayload(byte[] value) {
        this.payload = new ByteBuffer().with(value).flip(true);
        return this;
    }

    private void initValues(NodeProxyBroker broker) {
        Object[][] data = new Object[][]{{(short)10, 10, "version", (byte)8, "properties", (byte)9, "mechanisms", (byte)7, "locales", (byte)7}, {(short)10, (short)11, "clientProperties", (byte)9, "mechanisms", (byte)6, "response", (byte)7, "locale", (byte)6}, {(short)10, 20, "challenge", (byte)7}, {(short)10, 21, "challenge", (byte)7}, {(short)10, (short)30, "channelMax", (byte)3, "frameMax", (byte)4, "heartbeat", (byte)3}, {(short)10, (short)31, "channelMax", (byte)3, "frameMax", (byte)4, "heartbeat", (byte)3}, {(short)10, (short)40, "outOfBand", (byte)6}, {(short)10, 41, "outOfBand", (byte)7}, {(short)10, 50, "replyCode", (byte)3, "replyText", (byte)6, "classId", (byte)3, "methodId", (byte)3}, {(short)10, 51}, {(short)10, 60, "reason", (byte)6}, {(short)10, 61}, {(short)20, 10, "outOfBand", (byte)6}, {(short)20, 11, "outOfBand", (byte)7}, {(short)20, 20, "active", (byte)1}, {(short)20, 21, "active", (byte)1}, {(short)20, 40, "replyCode", (byte)3, "replyText", (byte)6, "classId", (byte)3, "methodId", (byte)3}, {(short)20, 41}, {(short)30, 10, "realm", (byte)6, "exclusive", (byte)1, "passive", (byte)1, "active", (byte)1, "write", (byte)1, "read", (byte)1}, {(short)30, 11, "ticket", (byte)3}, {(short)40, 10, "ticket", (byte)3, "exchange", (byte)6, "type", (byte)6, "passive", (byte)1, "durable", (byte)1, "autoDelete", (byte)1, "internal", (byte)1, "nowait", (byte)1, "arguments", (byte)9}, {(short)40, 11}, {(short)40, 20, "ticket", (byte)3, "exchange", (byte)6, "ifUnused", (byte)1, "nowait", (byte)1}, {(short)40, 21}, {(short)40, 30, "ticket", (byte)3, "destination", (byte)6, "source", (byte)6, "routingKey", (byte)6, "nowait", (byte)1, "arguments", (byte)9}, {(short)40, 31}, {(short)40, 40, "ticket", (byte)3, "destination", (byte)6, "source", (byte)6, "routingKey", (byte)6, "nowait", (byte)1, "arguments", (byte)9}, {(short)40, 51}, {(short)50, (short)10, "ticket", (byte)3, "queue", (byte)6, "passive", (byte)1, "durable", (byte)1, "exclusive", (byte)1, "autoDelete", (byte)1, "nowait", (byte)1, "arguments", (byte)9}, {(short)50, 11, "queue", (byte)6, "messageCount", (byte)4, "consumerCount", (byte)4}, {(short)50, 20, "ticket", (byte)3, "queue", (byte)6, "exchange", (byte)6, "routingKey", (byte)6, "nowait", (byte)1, "arguments", (byte)9}, {(short)50, 21}, {(short)50, 30, "ticket", (byte)3, "queue", (byte)6, "nowait", (byte)1}, {(short)50, 31, "messageCount", (byte)4}, {(short)50, 40, "ticket", (byte)3, "queue", (byte)6, "ifUnused", (byte)1, "ifEmpty", (byte)1, "nowait", (byte)1}, {(short)50, 41, "messageCount", (byte)4}, {(short)50, 50, "ticket", (byte)3, "queue", (byte)6, "exchange", (byte)6, "routingKey", (byte)6, "arguments", (byte)9}, {(short)50, 51}, {(short)60, 10, "prefetchSize", (byte)4, "prefetchCount", (byte)3, "global", (byte)1}, {(short)60, 11}, {(short)60, (short)20, "ticket", (byte)3, "queue", (byte)6, "consumerTag", (byte)6, "noLocal", (byte)1, "noAck", (byte)1, "exclusive", (byte)1, "nowait", (byte)1, "arguments", (byte)9}, {(short)60, 21, "consumerTag", (byte)6}, {(short)60, 30, "consumerTag", (byte)6, "nowait", (byte)1}, {(short)60, 31, "consumerTag", (byte)6}, {(short)60, (short)40, "ticket", (byte)3, "exchange", (byte)6, "routingKey", (byte)6, "mandatory", (byte)1, "immediate", (byte)1}, {(short)60, 50, "replyCode", (byte)3, "replyText", (byte)6, "exchange", (byte)6, "routingKey", (byte)6}, {(short)60, 60, "consumerTag", (byte)6, "deliveryTag", (byte)5, "redelivered", (byte)1, "exchange", (byte)6, "routingKey", (byte)6}, {(short)60, 70, "ticket", (byte)3, "queue", (byte)6, "noAck", (byte)1}, {(short)60, 71, "deliveryTag", (byte)5, "redelivered", (byte)1, "exchange", (byte)6, "routingKey", (byte)6, "messageCount", (byte)4}, {(short)60, 72, "clusterId", (byte)6}, {(short)60, 80, "deliveryTag", (byte)5, "multiple", (byte)1}, {(short)60, 90, "deliveryTag", (byte)5, "requeue", (byte)1}, {(short)60, 100, "requeue", (byte)1}, {(short)60, 110, "requeue", (byte)1}, {(short)60, 111}, {(short)60, 120, "deliveryTag", (byte)5, "multiple", (byte)1, "requeue", (byte)1}, {(short)85, 10, "nowait", (byte)1}, {(short)85, 11}, {(short)90, 10}, {(short)90, 11}, {(short)90, 20}, {(short)90, 21}, {(short)90, 30}, {(short)90, 31}};
        SimpleKeyValueList<Short, SimpleKeyValueList<Short, SimpleKeyValueList<String, Byte>>> values = broker.getGrammar(true);
        for (Object[] items : data) {
            SimpleKeyValueList<Short, SimpleKeyValueList<String, Byte>> group = values.get(items[0]);
            if (group == null) {
                group = new SimpleKeyValueList();
                values.put((Short)items[0], group);
            }
            SimpleKeyValueList<String, Byte> msgValues = new SimpleKeyValueList<String, Byte>();
            for (int i = 2; i < items.length; i += 2) {
                msgValues.put((String)items[i], (Byte)items[i + 1]);
            }
            if (items[1] instanceof Short) {
                group.put((Short)items[1], msgValues);
                continue;
            }
            int type = (Integer)items[1];
            group.put((short)type, msgValues);
        }
    }

    public boolean analysePayLoad(NodeProxyBroker broker) {
        SimpleKeyValueList<Short, SimpleKeyValueList<String, Byte>> group;
        this.classId = this.payload.getShort();
        if (broker.getGrammar(false) == null) {
            this.initValues(broker);
        }
        if ((group = broker.getGrammar(false).get((Object)this.classId)) != null) {
            this.methodId = this.payload.getShort();
            SimpleKeyValueList<String, Byte> values = group.get((Object)this.methodId);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    String name = values.getKeyByIndex(i);
                    Byte type = values.getValueByIndex(i);
                    if (type == 1) {
                        this.payloadData.add(name, (Object)this.payload.getBit());
                    }
                    if (type == 2) {
                        this.payloadData.add(name, (Object)this.payload.getByte());
                    }
                    if (type == 3) {
                        this.payloadData.add(name, (Object)this.payload.getShort());
                    }
                    if (type == 4) {
                        this.payloadData.add(name, (Object)this.payload.getInt());
                    }
                    if (type == 5) {
                        this.payloadData.add(name, (Object)this.payload.getLong());
                    }
                    if (type == 6) {
                        this.payloadData.add(name, (Object)this.payload.getShortstr());
                    }
                    if (type == 7) {
                        this.payloadData.add(name, (Object)new String(RabbitMessage.readBytes(this.payload)));
                    }
                    if (type == 8) {
                        this.payloadData.add(name, (Object)(this.payload.getByte() + "." + this.payload.getByte()));
                    }
                    if (type != 9) continue;
                    this.payloadData.add(name, RabbitMessage.readTable(this.payload));
                }
                return true;
            }
        }
        return false;
    }

    private static Map<String, Object> readTable(ByteBuffer in) {
        SimpleKeyValueList<String, Object> table = new SimpleKeyValueList<String, Object>();
        long endPos = in.getUnsignedInt();
        if (endPos == 0L) {
            return table;
        }
        endPos += (long)in.position();
        while ((long)in.position() < endPos) {
            String name = in.getShortstr();
            Object value = RabbitMessage.readFieldValue(in);
            if (table.containsKey(name)) continue;
            table.put(name, value);
        }
        return table;
    }

    private static Object readFieldValue(ByteBuffer in) {
        byte type = in.getByte();
        if (type == 83) {
            int len = in.getUnsignedInt();
            if (len < Integer.MAX_VALUE) {
                byte[] buffer = in.getBytes(new Object[]{new byte[len]});
                return new String(buffer);
            }
            return null;
        }
        if (type == 73) {
            return in.getInt();
        }
        if (type == 68) {
            byte scale = in.getByte();
            byte[] unscaled = in.getBytes(new Object[]{new byte[4]});
            return new BigDecimal(new BigInteger(unscaled), scale);
        }
        if (type == 84) {
            return new Date(in.getInt() * 1000);
        }
        if (type == 70) {
            return RabbitMessage.readTable(in);
        }
        if (type == 65) {
            return RabbitMessage.readArray(in);
        }
        if (type == 98) {
            return in.getByte();
        }
        if (type == 100) {
            return in.getDouble();
        }
        if (type == 102) {
            return Float.valueOf(in.getFloat());
        }
        if (type == 108) {
            return in.getInt();
        }
        if (type == 115) {
            return in.getShort();
        }
        if (type == 116) {
            return in.getBoolean();
        }
        if (type == 120) {
            return RabbitMessage.readBytes(in);
        }
        if (type == 86) {
            return null;
        }
        return null;
    }

    private static SimpleList<Object> readArray(ByteBuffer in) {
        SimpleList<Object> array = new SimpleList<Object>();
        in.getInt();
        while (in.remaining() > 0) {
            Object value = RabbitMessage.readFieldValue(in);
            array.add(value);
        }
        return array;
    }

    private static byte[] readBytes(ByteBuffer in) {
        long contentLength = in.getUnsignedInt();
        if (contentLength < Integer.MAX_VALUE) {
            byte[] buffer = in.getBytes(new Object[]{new byte[(int)contentLength]});
            return buffer;
        }
        return null;
    }

    public SimpleKeyValueList<String, Object> getPayloadData() {
        return this.payloadData;
    }

    public boolean hasData(String key) {
        if (this.payloadData != null) {
            return this.payloadData.containsKey(key);
        }
        return false;
    }

    public Object getData(String key) {
        if (this.payloadData != null) {
            return this.payloadData.getValue(key);
        }
        return null;
    }

    public String getText() {
        if (this.getType() != 3) {
            return null;
        }
        String text = new String(this.payload.array());
        return text;
    }

    public static RabbitMessage createStartOK(String ... login) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)10, (short)11);
        String userStr = "guest";
        String passwordStr = "guest";
        if (login.length > 0) {
            userStr = login[0];
            if (login.length > 1) {
                passwordStr = login[1];
            }
        }
        CharacterBuffer sb = new CharacterBuffer();
        sb.with('\u0000');
        sb.with(userStr);
        sb.with('\u0000');
        sb.with(passwordStr);
        ByteEntity entity = ByteEntity.create(75, "en_US");
        msg.withValues("PLAIN", sb.toString(), entity);
        return msg;
    }

    public static RabbitMessage createTuneOK(short channelMax, int frameMax, short heartbeat) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)10, (short)31);
        msg.withValues(channelMax, frameMax, heartbeat);
        return msg;
    }

    public static RabbitMessage createConnectionOpen(String virtualHost) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)10, (short)40);
        if (virtualHost == null) {
            virtualHost = "/";
        }
        msg.withShortString(virtualHost);
        msg.withShortString("");
        msg.withValues(false);
        return msg;
    }

    public static RabbitMessage createChannelOpen(NodeProxyBroker broker, String queue) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)20, (short)10);
        SimpleKeyValueList<String, String> topics = broker.getTopics();
        short no = (short)(topics.size() + 1);
        topics.add(queue, "" + no);
        msg.withChannel(no);
        msg.withEmptyValues();
        return msg;
    }

    public static RabbitMessage createQueue(short channel, String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> table) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)50, (short)10).withChannel(channel);
        short ticket = 0;
        msg.withValues(ticket);
        msg.withShortString(queue);
        boolean nowait = false;
        msg.withValues(durable, exclusive, autoDelete, nowait, table);
        return msg;
    }

    public static RabbitMessage createConsume(short channel, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String, Object> table) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)60, (short)20).withChannel(channel);
        short ticket = 0;
        msg.withValues(ticket);
        msg.withShortString(queue);
        msg.withShortString(consumerTag);
        msg.withValues(noLocal, noAck, exclusive, nowait, table);
        return msg;
    }

    public static RabbitMessage createPublish(short channel, String queue, String routingKey, byte[] body) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)60, (short)40).withChannel(channel);
        short ticket = 0;
        msg.withValues(ticket);
        msg.withShortString(queue);
        msg.withShortString(routingKey);
        msg.withValues(false);
        return msg;
    }

    public static RabbitMessage createExange(short channel, String exchange, String type) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)40, (short)10).withChannel(channel);
        short ticket = 0;
        if (type == null) {
            type = "fanout";
        }
        msg.withValues(ticket);
        msg.withShortString(exchange);
        msg.withShortString(type);
        msg.withValues(false);
        msg.withValues(false);
        msg.withValues(false);
        msg.withValues(false);
        msg.withValues(false);
        return msg;
    }

    public static RabbitMessage createBind(short channel, String exchange, String queue) {
        RabbitMessage msg = new RabbitMessage().withType((byte)1);
        msg.withFrame((short)50, (short)20).withChannel(channel);
        short ticket = 0;
        msg.withValues(ticket);
        msg.withShortString(queue);
        msg.withShortString(exchange);
        msg.withShortString("");
        msg.withValues(false);
        msg.writeValue(null);
        return msg;
    }

    public static RabbitMessage createPublishHeader(short channel, String queue) {
        RabbitMessage msg = new RabbitMessage().withType((byte)2);
        msg.withFrame((short)60, (short)0).withChannel(channel);
        msg.withValues(queue.length());
        msg.withValues(false, false);
        return msg;
    }

    public static RabbitMessage createPublishBody(short channel, String queue) {
        RabbitMessage msg = new RabbitMessage().withType((byte)3);
        msg.withChannel(channel);
        msg.withValues(queue);
        return msg;
    }

    private final void bitflush() {
        if (this.needBitFlush) {
            this.withValues(this.bitAccumulator);
            this.resetBitAccumulator();
        }
    }

    private void resetBitAccumulator() {
        this.needBitFlush = false;
        this.bitAccumulator = 0;
        this.bitMask = 1;
    }

    public RabbitMessage withBit(boolean b) {
        if (this.bitMask > 128) {
            this.bitflush();
        }
        if (b) {
            this.bitAccumulator = (byte)(this.bitAccumulator | this.bitMask);
        }
        this.bitMask <<= 1;
        this.needBitFlush = true;
        return this;
    }

    public static RabbitMessage createClose(short channel) {
        RabbitMessage msg = new RabbitMessage();
        msg.withChannel(channel);
        if (channel > 0) {
            msg.withType((byte)2);
            msg.withFrame((short)20, (short)20).withChannel(channel);
        } else {
            msg.withType((byte)1);
            msg.withFrame((short)10, (short)10);
        }
        msg.withValues((short)200);
        msg.withShortString("OK");
        msg.withValues((short)0, (short)0);
        return msg;
    }
}

