/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter64;
import de.uniks.networkparser.ext.io.MQTTMessage;
import de.uniks.networkparser.ext.io.RabbitMessage;
import de.uniks.networkparser.ext.io.ServerTrustManager;
import de.uniks.networkparser.ext.io.SocketMessage;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyBroker;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class MessageSession {
    public static final String TYPE_EMAIL = "EMAIL";
    public static final String TYPE_XMPP = "XMPP";
    public static final String TYPE_FCM = "FCM";
    public static final String TYPE_PLAIN = "PLAIN";
    public static final String TYPE_AMQ = "AMQ";
    public static final String TYPE_MQTT = "MQTT";
    public static final String RESPONSE_SERVERREADY = "220";
    public static final String RESPONSE_MAILACTIONOKEY = "250";
    public static final String RESPONSE_STARTMAILINPUT = "354";
    public static final String RESPONSE_SMTP_AUTH_NTLM_BLOB_Response = "334";
    public static final String RESPONSE_LOGIN_SUCCESS = "235";
    public static final String RESPONSE_SERVICE_CLOSING_TRANSMISSION = "221";
    public static final int SSL_PORT = 587;
    public static final int AMQP_PORT = 5672;
    public static final int MQTT_PORT = 1883;
    public static final int SOCKET_READ_TIMEOUT = 15000;
    public static String FEATURE_TLS = "STARTTLS";
    public static final int BUFFER = 1024;
    private String host;
    private int port;
    private String sender;
    protected Socket serverSocket;
    protected BufferedReader in;
    protected DataInputStream diInput;
    protected OutputStream out;
    protected SimpleList<String> supportedFeature = new SimpleList();
    private BufferedBuffer lastAnswer;
    private String lastSended;
    private SocketFactory factory;
    private String type;
    private String id;
    private BufferedBuffer responseFactory = new CharacterBuffer();
    private static String prefix = EntityUtil.randomString(5) + "-";
    private static long messageId = 0L;

    public MessageSession connectSSL(String host, String sender, String password) {
        this.host = host;
        this.port = 587;
        this.sender = sender;
        this.connect(sender, password);
        return this;
    }

    public boolean connect(String host, int port, String sender, String password) {
        this.host = host;
        this.port = port;
        return this.connect(sender, password);
    }

    private BufferedBuffer bindXMPP() {
        XMLEntity iq = XMLEntity.TAG("iq");
        iq.with("id", MessageSession.nextID());
        iq.with("type", "set");
        XMLEntity bind = iq.createChild("bind");
        bind.with("xmlns", "urn:ietf:params:xml:ns:xmpp-bind");
        bind.createChild("resource").withValueItem("NetworkParser");
        String command = iq.toString();
        BufferedBuffer response = this.sendCommand(command);
        response = this.sendCommand("<iq id=\"" + MessageSession.nextID() + "\" type=\"set\"><session xmlns=\"urn:ietf:params:xml:ns:xmpp-session\"/></iq>");
        XMLEntity presence = XMLEntity.TAG("presence");
        presence.with("id", MessageSession.nextID());
        presence.withCloseTag();
        command = presence.toString();
        response = this.sendCommand(command);
        return response;
    }

    private String getLoginText(String user, String password) {
        int i;
        if (user == null || password == null) {
            return "";
        }
        byte[] userBytes = user.getBytes();
        byte[] passwordBytes = password.getBytes();
        if (this.type == TYPE_AMQ) {
            int i2;
            byte[] bytes = new byte[userBytes.length + passwordBytes.length + 2];
            for (i2 = 0; i2 < userBytes.length; ++i2) {
                bytes[i2 + 1] = userBytes[i2];
            }
            for (i2 = 0; i2 < passwordBytes.length; ++i2) {
                bytes[i2 + userBytes.length + 2] = passwordBytes[i2];
            }
            return new String(bytes);
        }
        byte[] bytes = new byte[userBytes.length * 2 + passwordBytes.length + 2];
        for (i = 0; i < userBytes.length; ++i) {
            bytes[i] = userBytes[i];
            bytes[i + userBytes.length + 1] = userBytes[i];
        }
        for (i = 0; i < passwordBytes.length; ++i) {
            bytes[i + userBytes.length + userBytes.length + 2] = passwordBytes[i];
        }
        ByteConverter64 converter = new ByteConverter64();
        CharacterBuffer staticString = converter.toStaticString(bytes);
        return staticString.toString();
    }

    public String getSender() {
        return this.sender;
    }

    public boolean setSender(String sender) {
        if (!EntityUtil.stringEquals(this.sender, sender)) {
            this.sender = sender;
            return true;
        }
        return false;
    }

    public int getPort() {
        return this.port;
    }

    public MessageSession withPort(int port) {
        this.port = port;
        return this;
    }

    public MessageSession withHost(String url) {
        int pos = url.lastIndexOf(":");
        if (pos > 0) {
            String port = url.substring(pos + 1);
            try {
                this.port = Integer.valueOf(port);
                this.host = url.substring(0, pos);
            }
            catch (Exception e) {
                pos = -1;
            }
        }
        if (pos < 0) {
            this.host = url;
        }
        return this;
    }

    public String getID() {
        return this.id;
    }

    public boolean close() {
        try {
            this.in.close();
            this.out.close();
            this.serverSocket.close();
            this.serverSocket = null;
            this.in = null;
            this.out = null;
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean isClose() {
        return this.in == null;
    }

    private boolean initSockets(String host, int port) throws UnsupportedEncodingException, IOException {
        if (this.factory == null || host == null || host.isEmpty() || port < 1) {
            return false;
        }
        Socket socket = this.serverSocket != null && this.factory instanceof SSLSocketFactory ? ((SSLSocketFactory)this.factory).createSocket(this.serverSocket, host, port, true) : this.factory.createSocket(host, port);
        socket.setSoTimeout(15000);
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        this.out = socket.getOutputStream();
        this.serverSocket = socket;
        return true;
    }

    public boolean connect(String password) {
        return this.connect(this.sender, password);
    }

    public boolean connectXMPP(String sender, String password) {
        this.type = TYPE_XMPP;
        this.factory = SocketFactory.getDefault();
        if (!this.isValid(sender)) {
            return false;
        }
        try {
            this.initSockets(this.host, this.port);
            BufferedBuffer response = this.sendStart();
            XMLEntity answer = new XMLEntity().withValue(response);
            this.id = answer.getString("id");
            XMLEntity features = (XMLEntity)answer.getElementBy("tag", "stream:features");
            for (int i = 0; i < features.sizeChildren(); ++i) {
                XMLEntity child = (XMLEntity)features.getChild(i);
                this.supportedFeature.add(child.getTag().toUpperCase());
            }
            if (this.supportedFeature.contains(FEATURE_TLS)) {
                response = this.sendCommand("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\" />");
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new ServerTrustManager()}, new SecureRandom());
                this.factory = context.getSocketFactory();
                if (!this.startTLS()) {
                    return false;
                }
                this.sendStart();
                String login = this.getLoginText(sender, password);
                response = this.sendCommand("<auth mechanism=\"PLAIN\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">" + login + "</auth>");
                this.sendStart();
                this.bindXMPP();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean connectFCM(String sender, String password) {
        this.type = TYPE_FCM;
        this.factory = SSLSocketFactory.getDefault();
        if (!this.isValid(sender)) {
            return false;
        }
        try {
            this.initSockets(this.host, this.port);
            if (this.serverSocket instanceof SSLSocket) {
                ((SSLSocket)this.serverSocket).startHandshake();
            }
            BufferedBuffer response = this.sendStart();
            XMLEntity answer = new XMLEntity().withValue(response);
            this.id = answer.getString("id");
            response = this.getResponse();
            answer = new XMLEntity().withValue(response);
            XMLEntity features = (XMLEntity)answer.getElementBy("tag", "mechanisms");
            for (int i = 0; i < features.sizeChildren(); ++i) {
                XMLEntity child = (XMLEntity)features.getChild(i);
                this.supportedFeature.add(child.getValue().toUpperCase());
            }
            String login = this.getLoginText(sender, password);
            response = this.sendCommand("<auth mechanism=\"PLAIN\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">" + login + "</auth>");
            response = this.sendStart();
            XMLEntity iq = XMLEntity.TAG("iq");
            iq.with("type", "set");
            XMLEntity bind = iq.createChild("bind");
            bind.with("xmlns", "urn:ietf:params:xml:ns:xmpp-bind");
            response = this.sendCommand(iq.toString());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean connectSMTP(String sender, String password) {
        this.type = TYPE_EMAIL;
        this.factory = SocketFactory.getDefault();
        if (!this.isValid(sender)) {
            return false;
        }
        try {
            if (this.serverSocket == null) {
                this.initSockets(this.host, this.port);
                this.checkServerResponse(this.getResponse(), RESPONSE_SERVERREADY);
                this.sendStart();
                BufferedBuffer answer = this.sendCommand(FEATURE_TLS);
                this.startTLS();
                this.sendStart();
                answer = this.sendCommand("AUTH LOGIN");
                if (!this.checkServerResponse(answer, RESPONSE_SMTP_AUTH_NTLM_BLOB_Response)) {
                    this.close();
                    return false;
                }
                ByteConverter64 converter = new ByteConverter64();
                answer = this.sendCommand(converter.toStaticString(sender).toString());
                if (!this.checkServerResponse(answer, RESPONSE_SMTP_AUTH_NTLM_BLOB_Response)) {
                    this.close();
                    return false;
                }
                answer = this.sendCommand(converter.toStaticString(password).toString());
                if (!this.checkServerResponse(answer, RESPONSE_LOGIN_SUCCESS)) {
                    this.close();
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public RabbitMessage sending(NodeProxyBroker broker, RabbitMessage message, boolean answer) {
        if (message == null) {
            return null;
        }
        message.write(this.out);
        if (!answer) {
            return message;
        }
        try {
            RabbitMessage response = RabbitMessage.readFrom(this.diInput);
            response.analysePayLoad(broker);
            return response;
        }
        catch (IOException e) {
            broker.executeException(e);
            return null;
        }
    }

    public MQTTMessage sending(NodeProxyBroker broker, MQTTMessage message, boolean answer) {
        if (message.isMessageIdRequired() && message.getMessageId() == 0) {
            if (message.getType() == 3 && message.getMessageQOS() != 0) {
                message.withMessageId(broker.getNextMessageId());
            } else if (message.getType() == 4 || message.getType() == 9 || message.getType() == 8 || message.getType() == 10) {
                message.withMessageId(broker.getNextMessageId());
            }
        }
        ByteBuffer bytes = message.getHeader();
        bytes.insert(message.getPayload(), false);
        try {
            bytes.flip(false);
            this.out.write(bytes.array(), 0, bytes.length());
            this.out.flush();
            if (!answer) {
                return message;
            }
            MQTTMessage response = MQTTMessage.readFrom(this.diInput);
            return response;
        }
        catch (IOException e) {
            broker.executeException(e);
            return null;
        }
    }

    public boolean connectMQTT(NodeProxyBroker broker, String clientId, String sender, String password, int keepAlive, int mqttVersion, boolean cleanSession) {
        this.type = TYPE_MQTT;
        if (this.host == null || this.host.isEmpty()) {
            return false;
        }
        if (this.port == 0) {
            this.port = 1883;
        }
        this.factory = SocketFactory.getDefault();
        try {
            if (this.serverSocket == null) {
                this.initSockets(this.host, this.port);
                MQTTMessage connect = MQTTMessage.create((byte)1);
                connect.withNames(clientId, sender, password);
                connect.withKeepAliveInterval(keepAlive);
                connect.withCode(mqttVersion);
                connect.withSession(cleanSession);
                this.diInput = new DataInputStream(this.serverSocket.getInputStream());
                this.sending(broker, connect, true);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean connectAMQ(NodeProxyBroker broker, String sender, String password) {
        this.type = TYPE_AMQ;
        if (this.port == 0) {
            this.port = 5672;
        }
        this.factory = SocketFactory.getDefault();
        if (sender == null && password == null) {
            sender = "guest";
            password = "guest";
        }
        if (!this.isValid(sender)) {
            return false;
        }
        try {
            if (this.serverSocket == null) {
                this.initSockets(this.host, this.port);
                this.sendStart();
                this.diInput = new DataInputStream(this.serverSocket.getInputStream());
                RabbitMessage message = RabbitMessage.createStartOK(sender, password);
                RabbitMessage response = this.sending(broker, message, true);
                response = RabbitMessage.readFrom(this.diInput);
                response.analysePayLoad(broker);
                message = RabbitMessage.createTuneOK((Short)response.getData("channelMax"), (Integer)response.getData("frameMax"), (Short)response.getData("heartbeat"));
                response = this.sending(broker, message, false);
                message = RabbitMessage.createConnectionOpen(null);
                response = this.sending(broker, message, false);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean connect(String sender, String password) {
        if (TYPE_FCM.equals(this.type)) {
            return this.connectFCM(sender, password);
        }
        if (TYPE_XMPP.equals(this.type)) {
            return this.connectXMPP(sender, password);
        }
        if (TYPE_AMQ.equals(this.type)) {
            return false;
        }
        return this.connectSMTP(sender, password);
    }

    private boolean isValid(String sender) {
        if (this.host == null || this.host.length() < 1 || sender == null || sender.length() < 1) {
            return false;
        }
        this.sender = sender;
        return true;
    }

    private BufferedBuffer sendStart() {
        if (TYPE_XMPP.equals(this.type) || TYPE_FCM.equals(this.type)) {
            return this.sendCommand("<stream:stream to=\"" + this.host + "\" xmlns=\"jabber:client\" xmlns:stream=\"http://etherx.jabber.org/streams\" version=\"1.0\">");
        }
        if (TYPE_AMQ.equals(this.type)) {
            int major = 0;
            int minor = 9;
            int revision = 1;
            this.write("AMQP".getBytes(), 0, major, minor, revision);
            return new CharacterBuffer();
        }
        BufferedBuffer response = this.sendCommand("EHLO " + this.getLocalHost());
        this.supportedFeature.clear();
        String[] lines = response.toString().split("\n");
        for (int i = 1; i < lines.length; ++i) {
            this.supportedFeature.add(lines[i]);
        }
        return response;
    }

    public boolean startTLS() {
        try {
            if (this.serverSocket == null) {
                return false;
            }
            if (this.factory == null) {
                this.factory = SSLSocketFactory.getDefault();
            }
            this.initSockets(this.host, this.port);
            if (this.serverSocket instanceof SSLSocket) {
                SSLSocket socket = (SSLSocket)this.serverSocket;
                String[] prots = socket.getEnabledProtocols();
                SimpleList<String> eprots = new SimpleList<String>();
                for (int i = 0; i < prots.length; ++i) {
                    if (prots[i] == null || prots[i].startsWith("SSL") || prots[i].equalsIgnoreCase("TLSv1")) continue;
                    eprots.add(prots[i]);
                }
                socket.setEnabledProtocols(eprots.toArray(new String[eprots.size()]));
                socket.startHandshake();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected BufferedBuffer sendCommand(String commandString) {
        this.sendValues(commandString);
        BufferedBuffer response = this.getResponse();
        return response;
    }

    protected void sendValues(char ... cmd) {
        try {
            this.lastSended = new String(cmd);
            this.out.write(new String(cmd).getBytes());
            if (!"\r\n".equals(new String(cmd))) {
                this.out.write("\r\n".getBytes());
            }
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void sendValues(String cmd) {
        if (cmd != null) {
            try {
                this.out.write(cmd.getBytes());
                this.out.write("\r\n".getBytes());
                this.out.flush();
                this.lastSended = cmd;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean write(byte ... values) {
        try {
            if (values == null) {
                return true;
            }
            this.out.write(values);
            this.out.flush();
            this.lastSended = new String(values);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean write(Object ... values) {
        try {
            if (values == null) {
                return true;
            }
            CharacterBuffer sb = new CharacterBuffer();
            for (Object value : values) {
                Object item;
                if (value instanceof byte[]) {
                    item = (byte[])value;
                    this.out.write((byte[])item);
                    sb.with(new String((byte[])item));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                item = (Integer)value;
                this.out.write((Integer)item);
                sb.with((Integer)item);
            }
            this.out.flush();
            this.lastSended = sb.toString();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean doCommand(String commandString, String responseCode) {
        BufferedBuffer response = this.sendCommand(commandString);
        return this.checkServerResponse(response, responseCode);
    }

    protected boolean checkServerResponse(BufferedBuffer response, String code) {
        if (response == null || code == null) {
            return false;
        }
        if (response.length() < code.length()) {
            return false;
        }
        for (int i = 0; i < code.length(); ++i) {
            if (response.charAt(i) == code.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected BufferedBuffer getResponse() {
        BufferedBuffer response = this.responseFactory.getNewList(false);
        if (this.in == null) {
            return response;
        }
        int readed = -1;
        char[] buffer = new char[1024];
        do {
            try {
                readed = this.in.read(buffer);
                if (readed <= 0) continue;
                response.with(buffer, 0, readed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (readed == 1024);
        if (readed < 0 || response.length() < 1) {
            return response.with("[EOF]");
        }
        this.lastAnswer = response;
        return response;
    }

    public Object getServerResponse(NodeProxyBroker broker) {
        if (this.diInput != null) {
            try {
                if (TYPE_AMQ.equals(broker.getFormat())) {
                    RabbitMessage response = RabbitMessage.readFrom(this.diInput);
                    response.analysePayLoad(broker);
                    return response;
                }
                if (TYPE_MQTT.equals(broker.getFormat())) {
                    MQTTMessage resonse = MQTTMessage.readFrom(this.diInput);
                    return resonse;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return this.getResponse();
    }

    protected ByteBuffer getByteResponse() {
        ByteBuffer response = new ByteBuffer();
        if (this.in == null) {
            return response;
        }
        int readed = -1;
        char[] buffer = new char[1024];
        do {
            try {
                readed = this.in.read(buffer);
                if (readed <= 0) continue;
                response.with(buffer, 0, readed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (readed == 1024);
        if (readed < 0 || response.length() < 1) {
            return response.with("[EOF]");
        }
        this.lastAnswer = response;
        return response;
    }

    public String getLocalHost() {
        InetAddress localHost;
        String localHostName = null;
        try {
            localHost = InetAddress.getLocalHost();
            localHostName = localHost.getCanonicalHostName();
            if (localHostName == null) {
                localHostName = "[" + localHost.getHostAddress() + "]";
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if ((localHostName == null || localHostName.length() <= 0) && this.serverSocket != null && this.serverSocket.isBound() && (localHostName = (localHost = this.serverSocket.getLocalAddress()).getCanonicalHostName()) == null) {
            localHostName = "[" + localHost.getHostAddress() + "]";
        }
        return localHostName;
    }

    public String getLocalAdress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return "@" + localHost.getHostName();
        }
        catch (Exception exception) {
            return "mailer@localhost";
        }
    }

    public static String nextID() {
        return prefix + Long.toString(messageId++);
    }

    public boolean sendMessage(String to, String message) {
        SocketMessage msg = new SocketMessage(new String[0]);
        msg.withRecipient(to);
        msg.withMessage(message);
        return this.sending(msg);
    }

    public boolean sending(SocketMessage message) {
        if (TYPE_XMPP.equals(this.type) || TYPE_FCM.equals(this.type)) {
            XMLEntity xml = message.toXML(this.type);
            return this.sendCommand(xml.toString()) != null;
        }
        if (!this.connect(this.sender, null)) {
            return false;
        }
        if (!this.doCommand(message.getHeaderFrom(this.sender), RESPONSE_MAILACTIONOKEY)) {
            return false;
        }
        SimpleList<String> headerTo = message.getHeaderTo();
        int pos = 0;
        for (int i = 0; i < headerTo.size(); ++i) {
            if (!this.doCommand((String)headerTo.get(i), RESPONSE_MAILACTIONOKEY)) {
                message.removeToAdress(pos);
                continue;
            }
            ++pos;
        }
        if (!this.doCommand("DATA", RESPONSE_STARTMAILINPUT)) {
            return false;
        }
        message.generateMessageId(this.getLocalAdress());
        this.sendValues(message.getHeader("Date: "));
        this.sendValues(message.getHeader("From: "));
        this.sendValues(message.getHeader("To"));
        this.sendValues(message.getHeader("Message-Id: "));
        this.sendValues(message.getHeader("Subject: "));
        this.sendValues(message.getHeader("MIME-Version: "));
        SimpleList<BaseItem> messages = message.getMessages();
        boolean multiPart = message.isMultiPart();
        String splitter = "--";
        if (multiPart) {
            this.sendValues(message.getHeader("Content-Type: ") + message.getHeader("boundary="));
        } else {
            this.sendValues(message.getHeader("Content-Type: "));
            this.sendValues("Content-Transfer-Encoding: 7bit");
        }
        this.sendValues("\r\n");
        for (BaseItem msg : messages) {
            CharacterBuffer buffer = new CharacterBuffer();
            if (msg != null) {
                buffer.with(msg.toString());
            }
            if (multiPart) {
                this.sendValues(splitter + message.generateBoundaryValue());
                this.sendValues("Content-Type: " + message.getContentType(msg));
                this.sendValues("Content-Transfer-Encoding: 7bit");
            }
            this.sendValues("\r\n");
            while (!buffer.isEnd()) {
                CharacterBuffer line = buffer.readLine();
                if (line.startsWith(".")) {
                    this.sendValues('.');
                }
                this.sendValues(line.toString());
            }
        }
        SimpleKeyValueList<String, Buffer> attachments = message.getAttachments();
        for (int i = 0; i < attachments.size(); ++i) {
            String fileName = (String)attachments.get(i);
            Buffer buffer = attachments.getValueByIndex(i);
            this.sendValues(splitter + message.generateBoundaryValue());
            this.sendValues("Content-Type: text/plain; charset=utf-8; name=" + fileName);
            this.sendValues("Content-Transfer-Encoding: 7bit");
            this.sendValues("Content-Disposition: attachment; filename=" + fileName);
            this.sendValues("\r\n");
            while (!buffer.isEnd()) {
                CharacterBuffer line = buffer.getString(1024);
                this.sendValues(line.toString());
            }
        }
        if (multiPart) {
            this.sendValues(splitter + message.generateBoundaryValue() + splitter);
        }
        this.doCommand(".", RESPONSE_MAILACTIONOKEY);
        return this.doCommand("QUIT", RESPONSE_SERVICE_CLOSING_TRANSMISSION);
    }

    public BufferedBuffer getLastAnswer() {
        return this.lastAnswer;
    }

    public String getLastSended() {
        return this.lastSended;
    }

    public String getUrl() {
        return this.host;
    }

    public MessageSession withType(String msgType) {
        this.type = msgType;
        return this;
    }
}

