/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.SimpleController;
import de.uniks.networkparser.ext.generic.JarValidator;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.dialog.DialogBox;
import de.uniks.networkparser.ext.petaf.SimpleTimerTask;
import de.uniks.networkparser.ext.story.Story;
import de.uniks.networkparser.ext.story.StoryStepJUnit;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ReflectionBlackBoxTester {
    public static final String NULLVALUE = "nullValue";
    public static final String MINVALUE = "minValue";
    public static final String MAXVALUE = "maxValue";
    public static final String RANDOMVALUE = "randomValue";
    public static final String BLACKBOXTESTER = "backboxtest";
    public static final String INSTANCE = "instance";
    public static final String IGNOREMETHOD = "run";
    public static final String DEFAULTMETHODS = "";
    private SimpleSet<String> tests = (SimpleSet)new SimpleSet().with("nullValue", "minValue", "randomValue");
    private SimpleKeyValueList<String, SimpleSet<String>> ignoreMethods = new SimpleKeyValueList();
    private int errorCount;
    private int successCount;
    private String packageName;
    private NetworkParserLog logger;

    public static void mainTester(String[] args) {
        Object junitCore = ReflectionLoader.newInstanceStr("org.junit.runner.JUnitCore", new Object[0]);
        SimpleSet testClasses = new SimpleSet();
        String blackBoxPackage = null;
        String path = "doc/";
        if (junitCore != null) {
            for (String param : args) {
                if (param.startsWith("test=")) {
                    String[] clazzes;
                    param = param.substring(5);
                    for (String item : clazzes = param.split(",")) {
                        Class<?> testClazz;
                        if (item.startsWith(BLACKBOXTESTER)) {
                            int pos = item.indexOf(61);
                            blackBoxPackage = pos > 0 ? item.substring(pos + 1) : DEFAULTMETHODS;
                        }
                        if ((testClazz = ReflectionLoader.getClass(item)) == null) continue;
                        testClasses.add(testClazz);
                    }
                    continue;
                }
                if (!param.startsWith("path=")) continue;
                path = param.substring(5);
            }
            if (testClasses.size() < 1 && blackBoxPackage == null) {
                return;
            }
            Class<?> itemClass = junitCore.getClass();
            Method method = null;
            if (method != null) {
                Class[] list = testClasses.toArray(new Class[testClasses.size()]);
                try {
                    method.invoke(junitCore, new Object[]{list});
                }
                catch (Exception e) {
                    System.out.println("error: " + e.getMessage());
                    e.printStackTrace(System.out);
                }
            }
            if (blackBoxPackage != null) {
                StoryStepJUnit storyStepJUnit = new StoryStepJUnit();
                storyStepJUnit.withPackageName(blackBoxPackage);
                storyStepJUnit.executeBlackBoxTest(path);
            }
        }
    }

    public ReflectionBlackBoxTester() {
        this.withIgnoreClazzes(ReflectionBlackBoxTester.class, "main");
        this.withIgnoreClazzes(Story.class, "dumpHTML", "writeFile");
        this.withIgnoreClazzes(ErrorHandler.class, new String[0]);
        this.withIgnoreClazzes(StoryStepJUnit.class, "update");
        this.ignoreMethods.add(DEFAULTMETHODS, (SimpleSet<String>)new SimpleSet().with("show*", IGNOREMETHOD, "execute*", "checkSystemTray", "main"));
        this.withIgnoreClazzes(SimpleController.class, new String[0]);
        this.withIgnoreClazzes(DialogBox.class, "createContent");
        this.withIgnoreClazzes(JarValidator.class, new String[0]);
    }

    public ReflectionBlackBoxTester withIgnoreClazzes(Class<?> metaClass, String ... methods) {
        String className = metaClass.getName();
        if (methods == null || methods.length < 1) {
            return this.withIgnoreClazzes(className);
        }
        for (String method : methods) {
            this.withIgnoreClazzes(className + ":" + method);
        }
        return this;
    }

    public ReflectionBlackBoxTester withIgnoreClazzes(String ... values) {
        if (values == null) {
            return this;
        }
        for (String item : values) {
            int pos = item.indexOf(":");
            if (pos < 0) {
                if (this.ignoreMethods.contains(item)) continue;
                this.ignoreMethods.put(item, new SimpleSet());
                continue;
            }
            String clazz = item.substring(0, pos);
            String method = item.substring(pos + 1);
            SimpleSet methods = this.ignoreMethods.get(clazz);
            if (methods instanceof SimpleSet) {
                methods.add((String)method);
                continue;
            }
            methods = (SimpleSet)new SimpleSet().with(method);
            this.ignoreMethods.put(clazz, methods);
        }
        return this;
    }

    public static final boolean isTester() {
        String property = System.getProperty("Tester");
        return property != null && "true".equalsIgnoreCase(property);
    }

    public void test(String packageName, NetworkParserLog logger) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        System.setProperty("Tester", "true");
        ArrayList<Class<?>> classesForPackage = this.getClassesForPackage(packageName);
        this.errorCount = 0;
        this.successCount = 0;
        this.packageName = packageName;
        this.logger = logger;
        long start = System.currentTimeMillis();
        Set<Thread> oldThreads = ReflectionLoader.closeThreads(null);
        Timer timer = new Timer();
        for (Class<?> clazz : classesForPackage) {
            SimpleSet<String> methods = this.ignoreMethods.get(clazz.getName());
            if (methods != null && methods.size() < 1 || Modifier.isAbstract(clazz.getModifiers())) continue;
            SimpleTimerTask task = new SimpleTimerTask(Thread.currentThread());
            timer.schedule((TimerTask)task, 2000L);
            Object obj = ReflectionLoader.newInstanceSimple(clazz, IGNOREMETHOD);
            if (obj != null) {
                SimpleSet<String> defaultMethods = this.ignoreMethods.get(DEFAULTMETHODS);
                if (defaultMethods != null) {
                    if (methods == null) {
                        methods = new SimpleSet();
                    }
                    methods.withList(defaultMethods);
                }
                this.testClass(obj, clazz, methods);
            }
            task.withSimpleExit(null);
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        ReflectionLoader.closeThreads(oldThreads);
        this.output(this, "Errors: " + this.errorCount + "/" + (this.errorCount + this.successCount), logger, 4, null);
        this.output(this, "Time: " + (System.currentTimeMillis() - start) + "ms - Thread: " + oldThreads.size() + " -> " + Thread.activeCount(), logger, 4, null);
    }

    public void testClass(Object obj, Class<?> clazz, SimpleSet<String> ignoreMethods) {
        boolean reg = false;
        if (obj == null) {
            return;
        }
        for (String m : ignoreMethods) {
            if (m == null || !m.endsWith("*")) continue;
            reg = true;
            break;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getDeclaringClass().isInterface() || ignoreMethods != null && ignoreMethods.contains(method.getName())) continue;
            if (reg) {
                boolean continueFlag = false;
                for (String name : ignoreMethods) {
                    if (name == null || !name.endsWith("*")) continue;
                    String lowerCase = name.substring(0, name.length() - 1).toLowerCase();
                    if (!method.getName().toLowerCase().startsWith(lowerCase)) continue;
                    continueFlag = true;
                    break;
                }
                if (continueFlag) continue;
            }
            this.output(this, clazz.getName() + ":" + method.getName(), this.logger, 16, null);
            Object[] call = null;
            method.setAccessible(true);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (this.tests.contains(NULLVALUE)) {
                try {
                    call = ReflectionBlackBoxTester.getParameters(parameterTypes, NULLVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (this.tests.contains(MINVALUE)) {
                try {
                    call = ReflectionBlackBoxTester.getParameters(parameterTypes, MINVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (this.tests.contains(MAXVALUE)) {
                try {
                    call = ReflectionBlackBoxTester.getParameters(parameterTypes, MAXVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (!this.tests.contains(RANDOMVALUE)) continue;
            try {
                call = ReflectionBlackBoxTester.getParameters(parameterTypes, RANDOMVALUE);
                method.invoke(obj, call);
                ++this.successCount;
            }
            catch (Exception e) {
                this.saveException(e, clazz, method, call);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            try {
                ((Field)accessibleObject).setAccessible(true);
                Object value = ((Field)accessibleObject).get(obj);
                if (value == null) {
                    this.output(accessibleObject, "field null", this.logger, 8, null);
                }
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || value == null) continue;
                ((Field)accessibleObject).set(obj, ReflectionBlackBoxTester.getNullValue(value.getClass()));
                ((Field)accessibleObject).set(obj, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obj instanceof SendableEntityCreator) {
            ((SendableEntityCreator)obj).setValue(obj, DEFAULTMETHODS, null, "REMOVE_YOU");
        }
    }

    public ReflectionBlackBoxTester withTest(String value) {
        this.tests.clear();
        this.tests.add(value);
        return this;
    }

    private void saveException(Exception e, Class<?> clazz, Method m, Object[] call) {
        String line = this.getLine(this.packageName, e, clazz.getSimpleName());
        if (line.length() < 1) {
            line = clazz.getName() + ".java:1";
        }
        String shortName = DEFAULTMETHODS;
        if (line.lastIndexOf(".") > 0) {
            String[] split = line.split("\\.");
            shortName = line.substring(0, line.lastIndexOf(":") - 4) + m.getName() + "(" + split[split.length - 2] + "." + split[split.length - 1] + ")";
        }
        this.output(m, "at " + clazz.getName() + ": " + e.getCause() + " " + shortName + " : ", this.logger, 16, e);
        ++this.errorCount;
    }

    public String getParamtoString(Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (params == null) {
            sb.append(")");
            return sb.toString();
        }
        boolean hasParam = false;
        for (Object item : params) {
            if (hasParam) {
                sb.append(",");
            }
            if (item == null) {
                sb.append("null");
            } else {
                sb.append(item.toString());
            }
            hasParam = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public void output(Object owner, String message, NetworkParserLog logger, int logLevel, Exception e) {
        if (logger != null) {
            logger.log(owner, "output", message, logLevel, e);
        }
    }

    public static Object[] getParameters(Class<?>[] parameters, String type) {
        int length = parameters.length;
        Object[] objects = new Object[length];
        if (NULLVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = ReflectionBlackBoxTester.getNullValue(parameters[i]);
            }
            return objects;
        }
        if (MINVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = ReflectionBlackBoxTester.getMinValue(parameters[i]);
            }
            return objects;
        }
        if (MAXVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = ReflectionBlackBoxTester.getMaxValue(parameters[i]);
            }
            return objects;
        }
        if (RANDOMVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = ReflectionBlackBoxTester.getRandomValue(parameters[i]);
            }
        }
        return objects;
    }

    private static boolean equalsClass(Class<?> clazz, Class<?> ... checkClasses) {
        if (checkClasses == null) {
            return true;
        }
        for (Class<?> check : checkClasses) {
            if (!clazz.getName().equals(check.getName())) continue;
            return true;
        }
        return false;
    }

    private static Object getNullValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (ReflectionBlackBoxTester.equalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)0;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Short.TYPE, Short.class)) {
                return 0;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Integer.TYPE, Integer.class)) {
                return 0;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Long.TYPE, Long.class)) {
                return 0L;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\u0000');
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(0.0f);
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Double.TYPE, Double.class)) {
                return 0.0;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, String.class, CharSequence.class)) {
                return null;
            }
        }
        return null;
    }

    private static Object getMinValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (ReflectionBlackBoxTester.equalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)-128;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Integer.TYPE, Integer.class)) {
                return Integer.MIN_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Short.TYPE, Short.class)) {
                return (short)Short.MIN_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Long.TYPE, Long.class)) {
                return Long.MIN_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\u0000');
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(Float.MIN_VALUE);
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Double.TYPE, Double.class)) {
                return Double.MIN_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, String.class, CharSequence.class)) {
                return DEFAULTMETHODS;
            }
        }
        return null;
    }

    private static Object getRandomValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (ReflectionBlackBoxTester.equalsClass(clazz, Byte.TYPE, Byte.class)) {
                return 80;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Integer.TYPE, Integer.class)) {
                return 42;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Short.TYPE, Short.class)) {
                return 2;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Long.TYPE, Long.class)) {
                return 3;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('g');
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Float.TYPE, Float.class)) {
                return 6;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Double.TYPE, Double.class)) {
                return 8;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return true;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, String.class, CharSequence.class)) {
                return "Albert";
            }
        } else {
            if (ReflectionBlackBoxTester.equalsClass(clazz, Class.class)) {
                return Object.class;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Object.class)) {
                return "Albert";
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Field.class, Method.class)) {
                return null;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, X509Certificate.class)) {
                return null;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, File.class)) {
                return new File(DEFAULTMETHODS);
            }
            if (clazz.isArray()) {
                Class<?> arrayClazz = clazz.getComponentType();
                int nrDims = 1 + clazz.getName().lastIndexOf(91);
                int[] dims = new int[nrDims];
                for (int i = 0; i < nrDims; ++i) {
                    dims[i] = i + 1;
                }
                return Array.newInstance(arrayClazz, dims);
            }
            try {
                if (ReflectionLoader.STAGE == clazz) {
                    return null;
                }
                if (Throwable.class == clazz) {
                    return null;
                }
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
                ArrayList skipConstructor = new ArrayList();
                for (Constructor<?> c : declaredConstructors) {
                    try {
                        Object[] call = ReflectionBlackBoxTester.getParameters(c.getParameterTypes(), NULLVALUE);
                        if (ReflectionLoader.isAccess(c, null)) {
                            c.setAccessible(true);
                            return c.newInstance(call);
                        }
                        skipConstructor.add(c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (Constructor constructor : skipConstructor) {
                    try {
                        Object[] call = ReflectionBlackBoxTester.getParameters(constructor.getParameterTypes(), NULLVALUE);
                        constructor.setAccessible(true);
                        return constructor.newInstance(call);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return null;
    }

    private static Object getMaxValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (ReflectionBlackBoxTester.equalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)127;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Integer.TYPE, Integer.class)) {
                return Integer.MAX_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Short.TYPE, Short.class)) {
                return (short)Short.MAX_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Long.TYPE, Long.class)) {
                return Long.MAX_VALUE;
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\uffff');
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(Float.MAX_VALUE);
            }
            if (ReflectionBlackBoxTester.equalsClass(clazz, Double.TYPE, Double.class)) {
                return Double.MAX_VALUE;
            }
        }
        return null;
    }

    private String getLine(String packageName, Exception e, String clazzName) {
        String line;
        Throwable cause = e.getCause();
        if (cause != null && (line = this.getLineFromThrowable(packageName, cause, clazzName)).length() > 0) {
            return line;
        }
        return this.getLineFromThrowable(packageName, e, clazzName);
    }

    private String getLineFromThrowable(String packageName, Throwable e, String clazzName) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = e.getStackTrace()) {
            String name = ste.getClassName();
            if (!name.startsWith(packageName) || name.startsWith(packageName + ".test")) continue;
            return name + ".java:" + ste.getLineNumber();
        }
        return DEFAULTMETHODS;
    }

    private void checkDirectory(File directory, String pckgname, ArrayList<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            if (files == null) {
                return;
            }
            for (String file : files) {
                if (file.endsWith(".class")) {
                    try {
                        String className = pckgname;
                        if (className.length() > 0) {
                            className = className + ".";
                        }
                        className = className + file.substring(0, file.length() - 6);
                        classes.add(Class.forName(className));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory() || file.equalsIgnoreCase("test")) continue;
                this.checkDirectory(tmpDirectory, pckgname + "." + file, classes);
            }
        }
    }

    public ArrayList<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException, IOException {
        Class<?> forName;
        ArrayList classes = new ArrayList();
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            return classes;
        }
        Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
        URL url = null;
        while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
            this.checkDirectory(new File(URLDecoder.decode(url.getPath(), "utf-8")), pckgname, classes);
        }
        if (classes.size() == 0 && (forName = Class.forName(pckgname)) != null) {
            classes.add(forName);
        }
        return classes;
    }
}

