/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.ByteList;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;

public class BitValue
implements ByteItem {
    private byte start;
    private byte size;
    private byte type;
    private String property;
    private int orientation = 1;

    public BitValue(int start, int size) {
        this.start = (byte)start;
        this.size = (byte)size;
    }

    public BitValue(byte start, byte len) {
        this.start = start;
        this.size = len;
    }

    public byte getStart() {
        return this.start;
    }

    public BitValue withStart(byte start) {
        this.start = start;
        return this;
    }

    public BitValue withSize(byte len) {
        this.size = len;
        return this;
    }

    public BitValue withOrientation(int value) {
        this.orientation = value;
        return this;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String getProperty() {
        return this.property;
    }

    public BitValue withLenProperty(byte lenType, String property) {
        this.type = lenType;
        this.property = property;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public int calcLength(boolean isDynamic, boolean isLast) {
        return this.size;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new ByteList();
    }

    @Override
    public String toString(Converter converter) {
        if (converter instanceof ByteConverter) {
            return this.toString((ByteConverter)converter, false);
        }
        return this.toString(null, false);
    }

    @Override
    public String toString(ByteConverter converter, boolean isDynamic) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        return converter.toString(this.getBytes(isDynamic));
    }

    @Override
    public ByteBuffer getBytes(boolean isDynamic) {
        return null;
    }

    @Override
    public void writeBytes(ByteBuffer buffer, boolean isDynamic, boolean lastEntity, boolean isPrimitive) {
    }

    @Override
    public boolean add(Object ... values) {
        return false;
    }
}

