/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.interfaces.ObjectCondition;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class NetworkParserLog
extends Handler {
    public static final String ERROR_TYP_PARSING = "PARSING";
    public static final String ERROR_TYP_CONCURRENTMODIFICATION = "CONCURRENTMODIFICATION";
    public static final String ERROR_TYP_NOCREATOR = "NOCREATORFOUND";
    public static final String ERROR_TYP_DUPPLICATE = "DUPPLICATE";
    public static final byte LOGLEVEL_TRACE = 1;
    public static final byte LOGLEVEL_DEBUG = 2;
    public static final byte LOGLEVEL_INFO = 4;
    public static final byte LOGLEVEL_WARNING = 8;
    public static final byte LOGLEVEL_ERROR = 16;
    public static final byte LOGLEVEL_FATAL = 32;
    public static final byte LOGLEVEL_ALL = 63;
    public static final String TRACE = "TRACE";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    public static final String LOG = "LOG";
    private byte flag = (byte)20;
    private ObjectCondition condition;
    static NetworkParserLog global;

    public boolean debug(Object owner, String method, String message) {
        if (this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withType(DEBUG));
        }
        return false;
    }

    public boolean print(Object owner, Object item) {
        if (this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, null, null, item).withType(LOG));
        }
        return false;
    }

    public boolean info(Object owner, String method, String message, Object ... params) {
        if ((this.flag & 4) != 0 && this.condition != null) {
            Object values = params;
            if (params != null && params.length == 1) {
                values = params[0];
            }
            return this.condition.update(new SimpleEvent(owner, method, null, message).withModelValue(values).withType(INFO));
        }
        return false;
    }

    public NetworkParserLog withFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        return this;
    }

    public NetworkParserLog withoutFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        this.flag = (byte)(this.flag - flag);
        return this;
    }

    public boolean warn(Object owner, String method, String message, Object ... params) {
        if ((this.flag & 8) != 0 && this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withModelValue(params).withType(WARNING));
        }
        return false;
    }

    public boolean error(Object owner, String method, String message, Object ... params) {
        if ((this.flag & 0x10) != 0 && this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withModelValue(params).withType(ERROR));
        }
        return false;
    }

    public boolean log(Object owner, String method, String msg, int level, Object ... params) {
        if (level == 16) {
            return this.error(owner, method, msg, params);
        }
        if (level == 8) {
            return this.warn(owner, method, msg, params);
        }
        return this.info(owner, method, msg, params);
    }

    public NetworkParserLog withListener(ObjectCondition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public void publish(LogRecord record) {
        if (global != null && global != this) {
            global.publish(record);
            return;
        }
        String level = record.getLevel().toString();
        if ("SEVERE".equals(level)) {
            this.error(record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), new Object[0]);
        }
        if (WARNING.equals(level)) {
            this.warn(record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), new Object[0]);
        }
        this.info(record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), new Object[0]);
    }

    public void trace(Object owner, String method, String message, Object ... params) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static NetworkParserLog createLogger(byte flag, boolean removeConsoleHandler, ObjectCondition ... conditions) {
        Handler[] handlers;
        if (global != null) {
            return global;
        }
        Logger rootLogger = Logger.getLogger("");
        NetworkParserLog logger = new NetworkParserLog().withFlag(flag);
        if (conditions != null && conditions.length > 0) {
            logger.withListener(conditions[0]);
        }
        if (removeConsoleHandler && (handlers = rootLogger.getHandlers()) != null && handlers.length > 0 && handlers[0] instanceof ConsoleHandler && handlers[0] instanceof ConsoleHandler) {
            rootLogger.removeHandler(handlers[0]);
        }
        rootLogger.addHandler(new NetworkParserLog());
        global = logger;
        return logger;
    }

    public boolean isLevel(byte logLevel) {
        return (this.flag & logLevel) != 0;
    }
}

