/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.xml.XMLEntity;

public class XMLEntityCreator
implements SendableEntityCreatorTag {
    private String nameSpace = "";
    private final String[] properties = new String[]{"tag", "value"};

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    public XMLEntityCreator withNameSpace(String namespace) {
        this.nameSpace = namespace;
        return this;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new XMLEntity();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if ("tag".equalsIgnoreCase(attribute)) {
            return ((XMLEntity)entity).getTag();
        }
        if ("value".equalsIgnoreCase(attribute)) {
            return ((XMLEntity)entity).getValue();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if ("tag".equalsIgnoreCase(attribute)) {
            ((XMLEntity)entity).setType("" + value);
            return true;
        }
        if ("value".equalsIgnoreCase(attribute)) {
            String newValue = "" + value;
            if (newValue.length() > 0) {
                ((XMLEntity)entity).withValueItem(newValue);
            }
            return true;
        }
        if ("<CHILDREN>".equals(type) && value instanceof EntityList) {
            ((XMLEntity)entity).withChild((EntityList)value);
        } else if (attribute != null && !attribute.isEmpty()) {
            ((XMLEntity)entity).add(attribute, value);
        }
        return true;
    }

    @Override
    public String getTag() {
        if (this.nameSpace != null) {
            return this.nameSpace + ":element";
        }
        return null;
    }
}

