/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.TextEntity;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;

public class JDLTokener
extends Tokener {
    @Override
    public BaseItem encode(Object entity, MapEntity map) {
        if (entity instanceof GraphList) {
            return this.encodeClassModel((GraphList)entity, map);
        }
        return null;
    }

    private BaseItem encodeClassModel(GraphList entity, MapEntity map) {
        if (entity == null || map == null) {
            return null;
        }
        TextEntity result = new TextEntity();
        ClazzSet clazzes = entity.getClazzes(new Condition[0]);
        for (Clazz item : clazzes) {
            result.add(this.encodeEntity(item));
        }
        AssociationSet associations = entity.getAssociations(new Condition[0]);
        for (Association assoc : associations) {
            result.add(this.encodeRelationship(assoc));
        }
        return result;
    }

    public TextEntity encodeEntity(Clazz item) {
        TextEntity result = new TextEntity();
        if (item == null) {
            return result;
        }
        result.withTag("entity " + item.getName());
        AttributeSet attributes = item.getAttributes(new Condition[0]);
        TextEntity attributeList = new TextEntity();
        attributeList.withTag('{');
        for (Attribute attribute : attributes) {
            attributeList.add(this.encodeAttribute(attribute));
        }
        if (attributeList.size() > 0) {
            attributeList.withTag('{');
            attributeList.withTagEnd('}');
            result.add(attributeList);
        }
        return result;
    }

    public TextEntity encodeAttribute(Attribute item) {
        TextEntity result = new TextEntity();
        if (item == null || item.getType() == null) {
            return result;
        }
        result.withTag(item.getName() + " " + item.getType().getName(true));
        return result;
    }

    public TextEntity encodeRelationship(Association assoc) {
        TextEntity relationship = new TextEntity();
        if (assoc == null) {
            return relationship;
        }
        relationship.withTag("relationship " + this.getCardinality(assoc));
        TextEntity values = new TextEntity();
        values.withTag('{');
        values.add(this.encodeRelationshipClazz(assoc));
        values.add(" to ");
        values.add(this.encodeRelationshipClazz(assoc.getOther()));
        values.withTagEnd('}');
        relationship.add(values);
        return relationship;
    }

    public TextEntity encodeRelationshipClazz(Association assoc) {
        TextEntity result = new TextEntity();
        if (assoc == null || assoc.getClazz() == null) {
            return result;
        }
        result.withTag(assoc.getClazz().getName());
        TextEntity values = new TextEntity();
        values.withTag("[{");
        values.add(assoc.getName());
        values.withTagEnd("}]");
        result.add(values);
        return result;
    }

    private String getCardinality(Association assoc) {
        if (assoc == null || assoc.getOther() == null) {
            return null;
        }
        if (assoc.getCardinality() == Cardinality.ONE) {
            if (assoc.getOther().getCardinality() == Cardinality.ONE) {
                return "OneToOne";
            }
            return "OneToMany";
        }
        if (assoc.getOther().getCardinality() == Cardinality.ONE) {
            return "ManyToOne";
        }
        return "ManyToMany";
    }
}

