/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.SimpleController;
import de.uniks.networkparser.ext.generic.JarClassLoader;
import de.uniks.networkparser.ext.generic.ReflectionBlackBoxTester;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.petaf.SimpleTimerTask;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarValidator {
    private String path;
    private String file = "build/jacoco/html/index.html";
    public static final String JARFILE = ".jar";
    public static final String CLASSFILESUFFIX = ".class";
    private ArrayList<String> warnings = new ArrayList();
    private TreeSet<String> warningsPackages = new TreeSet();
    private ArrayList<String> errors = new ArrayList();
    private ArrayList<String> mergePackages = new ArrayList();
    private boolean isExistFullJar;
    private boolean isUseJUnit;
    SimpleKeyValueList<String, JsonObject> projects = new SimpleKeyValueList();
    private String rootPath = "";
    private int count;
    private int classes;
    private int minCoverage = 0;
    public boolean isAnalyseJar = false;
    public boolean isLicence = false;
    public boolean isError = true;
    public boolean isWarning = true;
    public boolean isInstance = true;
    public boolean isValidate = false;

    public JarValidator withMinCoverage(int value) {
        this.minCoverage = value;
        this.isValidate = true;
        return this;
    }

    public JarValidator withPath(String path) {
        this.path = path;
        this.isAnalyseJar = true;
        return this;
    }

    private TreeSet<String> getDependency(CharacterBuffer executeProcess, String search) {
        int pos = executeProcess.indexOf("##" + search + "##");
        TreeSet<String> packages = new TreeSet<String>();
        if (pos > 0) {
            System.out.println("FOUND DEPENDENCY:" + search);
            int end = executeProcess.indexOf("##" + search + "END##", pos);
            if (end > 0) {
                CharacterBuffer subSequence = executeProcess.subSequence(pos + search.length() + 4, end);
                end = subSequence.indexOf(10);
                pos = 0;
                while (end > 0) {
                    String p = subSequence.subSequence(pos, end).toString().trim();
                    if (!p.isEmpty()) {
                        packages.add(p);
                    }
                    pos = end;
                    end = subSequence.indexOf(10, pos + 1);
                }
            }
        }
        return packages;
    }

    public void validate() {
        if (ReflectionBlackBoxTester.isTester()) {
            return;
        }
        CharacterBuffer script = FileBuffer.readFile(this.rootPath + "build.gradle");
        this.isUseJUnit = script.indexOf("useJUnitPlatform()") > 0;
        int pos = script.indexOf("org.glassfish.jersey.inject:");
        String jerseyInject = script.getLine(pos).toString();
        pos = script.indexOf("org.glassfish.jersey.media:");
        String jerseyMedia = script.getLine(pos).toString();
        script.newLine();
        script.newLine();
        script.withLine("task showDependency() {");
        script.withLine("def listMain=new TreeSet();");
        script.withLine("def listTest=new TreeSet();");
        script.withLine("sourceSets.each{ if(it ==sourceSets.test) {");
        script.withLine("\t\tit.java.each { listTest.add( it.getParentFile().getAbsolutePath().toString()) }");
        script.withLine("\t} else {");
        script.withLine("\t\tit.java.each { listMain.add( it.getParentFile().getAbsolutePath().toString()) }");
        script.withLine("\t}");
        script.withLine("}");
        script.withLine("println \"##SRCDEPENDENCY##\"");
        script.withLine("listMain.each{ println it; }");
        script.withLine("sourceSets.main.compileClasspath.each { println it }");
        script.withLine("println \"##SRCDEPENDENCYEND##\"");
        script.withLine("println \"##TESTDEPENDENCY##\"");
        script.withLine("listTest.each{ println it; }");
        script.withLine("sourceSets.test.compileClasspath.each { println it }");
        script.withLine("println \"##TESTDEPENDENCYEND##\"");
        script.withLine("}");
        FileBuffer.writeFile(this.rootPath + "test.gradle", script.toString());
        CharacterBuffer command = new CharacterBuffer();
        CharacterBuffer executeProcess = SimpleController.executeProcess(command, this.rootPath + "gradlew", "showDependency", "-b", this.rootPath + "test.gradle");
        String value = command.toString() + "\r\n" + executeProcess.toString();
        FileBuffer.writeFile(this.rootPath + "test.out", value);
        if (executeProcess.length() > 0) {
            System.out.println("CHECK DEPENDENCY: " + new File(this.rootPath + "test.gradle").exists());
        } else {
            System.out.println("ERROR DEPENDENCY: " + new File(this.rootPath + "test.gradle").exists());
            System.out.println(executeProcess.toString());
        }
        ArrayList<String> packages = this.mergePacking(this.getDependency(executeProcess, "SRCDEPENDENCY"));
        ArrayList<String> testPackages = this.mergePacking(this.getDependency(executeProcess, "TESTDEPENDENCY"));
        script = new CharacterBuffer();
        script.withLine("repositories { jcenter() }");
        script.withLine("apply plugin: 'java'");
        script.withLine("apply plugin: 'maven'");
        script.withLine("apply plugin: 'jacoco'");
        script.withLine("jacoco.toolVersion = \"0.8.+\"");
        script.withLine("test {");
        script.withLine("\tuseJUnit{");
        script.withLine("\t\tdependencies{");
        script.withLine("\t\t\timplementation(group: 'junit', name: 'junit', version: '[4,)')");
        script.withLine("\t\t}");
        script.withLine("\t}");
        script.withLine("\ttestLogging {");
        script.withLine("\t\tevents \"FAILED\", \"SKIPPED\"");
        script.withLine("\t\texceptionFormat \"short\"");
        script.withLine("\t\tshowStackTraces\ttrue");
        script.withLine("\t\tshowStandardStreams true");
        script.withLine("\t\tshowCauses true");
        script.withLine("\t}");
        script.withLine("\treports.junitXml {");
        script.withLine("\t\tenabled true");
        script.withLine("\t\tdestination new File(\"${buildDir}/reports/\")");
        script.withLine("\t}");
        if (this.isUseJUnit) {
            script.withLine("\tuseJUnitPlatform()");
        }
        script.withLine("\tfinalizedBy jacocoTestReport");
        script.withLine("}");
        script.withLine("jacocoTestReport {");
        script.withLine("\tgroup = \"Reporting\"");
        script.withLine("\tdescription = \"Generate Jacoco coverage reports after running tests.\"");
        script.withLine("\texecutionData = files(\"${buildDir}/jacoco/test.exec\")");
        script.withLine("\treports {");
        script.withLine("\t\tcsv.enabled false");
        script.withLine("\t\txml.enabled = true");
        script.withLine("\t\txml.destination = new File(\"${buildDir}/test-results/jacoco.xml\")");
        script.withLine("\t\thtml.enabled = true");
        script.withLine("\t\thtml.destination = new File(\"${buildDir}/jacoco/html\")");
        script.withLine("\t}");
        script.withLine("}");
        TreeSet<String> dependency = new TreeSet<String>();
        if (packages.size() > 0) {
            script.withLine("sourceSets.main.java.srcDirs(");
            for (String item : packages) {
                if ((item = item.replace('\\', '/')).toLowerCase().endsWith(JARFILE)) {
                    dependency.add(item);
                    continue;
                }
                script.withLine("\t\"" + item + "\",");
            }
            script.withLine("\t\"src/main/java/\"");
            script.withLine(")");
        }
        if (testPackages.size() > 0) {
            script.withLine("sourceSets.test.java.srcDirs(");
            for (String item : testPackages) {
                if ((item = item.replace('\\', '/')).toLowerCase().endsWith(JARFILE)) {
                    dependency.add(item);
                    continue;
                }
                script.withLine("\t\"" + item + "\",");
            }
            script.withLine("\t\"src/test/java/\"");
            script.withLine(")");
        }
        script.withLine("dependencies {");
        script.withLine("\t// Test framework");
        script.withLine("\tcompile 'org.junit.jupiter:junit-jupiter-api:5.+'");
        script.withLine("\tcompile 'org.junit.jupiter:junit-jupiter-engine:5.+'");
        for (String item : dependency) {
            script.withLine("compile files(\"" + item + "\")");
        }
        script.withLine(jerseyInject);
        script.withLine(jerseyMedia);
        script.withLine("}");
        script.withLine("defaultTasks 'test'");
        FileBuffer.writeFile(this.rootPath + "jacoco.gradle", script.toString());
        command = new CharacterBuffer();
        executeProcess = SimpleController.executeProcess(command, this.rootPath + "gradlew", "-b", this.rootPath + "jacoco.gradle", "--stacktrace");
        value = command.toString() + "\r\n" + executeProcess.toString();
        FileBuffer.writeFile(this.rootPath + "jacoco.out", value);
        if (executeProcess.length() > 0) {
            System.out.println("CHECK TEST: " + new File(this.rootPath + "jacoco.gradle").exists());
        } else {
            System.out.println("ERROR TEST: " + new File(this.rootPath + "jacoco.gradle").exists());
            System.out.println(executeProcess.toString());
        }
    }

    public boolean analyseReport() {
        File file = new File(this.rootPath + this.file);
        if (file.exists()) {
            String search;
            CharacterBuffer content = FileBuffer.readFile(file);
            int pos = content.indexOf(search = "<td class=\"ctr2\">");
            if (pos > 0) {
                int end = content.indexOf("</td", pos);
                String cc = content.substring(pos += search.length(), end);
                cc = cc.replaceAll("&nbsp;", "");
                cc = cc.replaceAll("%", "");
                cc = cc.replace('\u00a0', ' ');
                cc = cc.trim();
                System.out.println("Found CC: " + cc);
                int no = Integer.valueOf(cc);
                if (no >= this.minCoverage) {
                    return true;
                }
            }
        } else {
            System.out.println("File not found:" + this.file);
        }
        return false;
    }

    public int searchFiles(PrintStream output) {
        if (this.path == null) {
            return -1;
        }
        return this.searching(new File(this.rootPath + this.path), output);
    }

    public boolean isError() {
        return this.warnings.size() > 0 || this.errors.size() > 0;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public ArrayList<String> getWarnings() {
        return this.warnings;
    }

    public int searching(File file, PrintStream output) {
        if (file == null) {
            if (output != null) {
                output.println("NO FILES FOUND");
            }
            return -1;
        }
        int result = 0;
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            if (output != null) {
                output.println("NO FILES FOUND: " + file.getPath());
            }
            return -1;
        }
        for (File child : listFiles) {
            if (child.isDirectory()) {
                int subresult = this.searching(child, output);
                if (subresult >= 0) continue;
                result += subresult;
                continue;
            }
            String fileName = child.getName().toLowerCase();
            if (!fileName.endsWith(JARFILE)) continue;
            if (output != null) {
                output.println("FOUND: " + child.toString() + " (" + child.length() + ")");
            }
            if (this.analyseFile(child)) continue;
            if (!this.isError()) {
                if (output != null) {
                    output.println("Everything is ok (" + file + ")");
                }
            } else {
                this.mergePackages.clear();
                this.mergePackages.addAll(this.mergePacking(this.warningsPackages));
                if (this.mergePackages.size() < 1) {
                    if (output != null) {
                        output.println("May be not the fatJar (" + child.toString() + ")");
                    }
                } else {
                    this.isExistFullJar = true;
                    if (output != null) {
                        output.println("There are " + this.errors.size() + " Errors in Jar (" + child.toString() + ")");
                        if (this.isWarning) {
                            for (String entry : this.errors) {
                                output.println("- Can't create instance of " + entry);
                            }
                        }
                        output.println("There are " + this.warnings.size() + " Warnings in Jar (" + child.toString() + ")");
                        if (this.isWarning) {
                            for (String entry : this.warnings) {
                                if (output == null) continue;
                                output.println("- Not necessary file " + entry);
                            }
                        }
                    }
                }
            }
            if (this.isLicence) {
                System.out.println("Classes: " + this.classes + "/" + this.count);
                SimpleKeyValueList<String, JsonObject> projects = this.mergePackages();
                for (int i = 0; i < projects.size(); ++i) {
                    XMLEntity licences;
                    if (output != null) {
                        output.print(projects.getKeyByIndex(i));
                        if ("org.sdmlib".equalsIgnoreCase(projects.getKeyByIndex(i))) {
                            System.out.println("JJ");
                        }
                    }
                    JsonObject elements = projects.getValueByIndex(i);
                    JsonObject last = (JsonObject)elements.getJsonArray("docs").first();
                    String group = last.getString("g").replace('.', '/');
                    String url = group + "/" + last.getString("a") + "/" + last.getString("v") + "/";
                    url = url + last.getString("a") + "-" + last.getString("v") + ".pom";
                    HTMLEntity pom = null;
                    try {
                        pom = NodeProxyTCP.getHTTP("http://search.maven.org/remotecontent?filepath=" + url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (pom == null) continue;
                    XMLEntity body = pom.getBody();
                    Entity nameTag = body.getElementBy("tag", "name");
                    if (nameTag != null && output != null) {
                        output.print(" - " + ((XMLEntity)nameTag).getValue());
                    }
                    if ((licences = (XMLEntity)body.getElementBy("tag", "licenses")) != null) {
                        for (int l = 0; l < licences.sizeChildren(); ++l) {
                            XMLEntity licence = (XMLEntity)licences.getChild(l);
                            if (!"license".equalsIgnoreCase(licence.getTag()) || output == null) continue;
                            output.print(" - ");
                            output.print(((XMLEntity)licence.getElementBy("tag", "name")).getValue());
                            output.print(" - ");
                            output.print(((XMLEntity)licence.getElementBy("tag", "url")).getValue());
                        }
                    }
                    if (output == null) continue;
                    output.print("\r\n");
                }
            }
            result = this.count() * -1;
        }
        return result;
    }

    public boolean isExistFullJar() {
        return this.isExistFullJar;
    }

    public int count() {
        int count = 0;
        if (this.errors != null) {
            count += this.errors.size();
        }
        if (this.warnings != null) {
            count += this.warnings.size();
        }
        return count;
    }

    public void clear() {
        this.warnings.clear();
        this.warningsPackages.clear();
        this.mergePackages.clear();
        this.errors.clear();
        this.count = 0;
        this.classes = 0;
    }

    public ArrayList<String> mergePacking(TreeSet<String> sources) {
        ArrayList<String> dep = new ArrayList<String>();
        dep.addAll(sources);
        for (int i = dep.size() - 1; i > 0; --i) {
            for (int z = i - 1; z >= 0; --z) {
                if (!((String)dep.get(i)).startsWith((String)dep.get(z))) continue;
                dep.remove(i);
                z = 0;
            }
        }
        boolean copy = false;
        if (dep.size() > 1) {
            copy = true;
        } else if (dep.size() == 1 && (dep.get(0).equalsIgnoreCase("de") || dep.get(0).equalsIgnoreCase("de.uniks") || dep.get(0).equalsIgnoreCase("de.uniks.networkparser"))) {
            copy = true;
        }
        if (!copy) {
            dep.clear();
        }
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyseFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        URLClassLoader jarClassLoader = null;
        ZipFile jarFile = null;
        ZipInputStream zip = null;
        Set<Thread> oldThreads = ReflectionLoader.closeThreads(null);
        Timer timer = null;
        ReflectionBlackBoxTester tester = new ReflectionBlackBoxTester();
        tester.withTest("instance");
        try {
            ZipEntry entry;
            jarClassLoader = new JarClassLoader(ClassLoader.getSystemClassLoader(), file.toURI().toURL());
            this.clear();
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            zip = new ZipInputStream(bis);
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                String lName = name.toLowerCase();
                ++this.count;
                if (lName.endsWith(CLASSFILESUFFIX)) {
                    ++this.classes;
                    if (name.indexOf("$") < 0 && name.split("/").length > 2) {
                        int pos = name.lastIndexOf("/");
                        this.warningsPackages.add(name.substring(0, pos).replaceAll("/", "."));
                    }
                } else {
                    if (lName.endsWith(".jpg")) {
                        this.warnings.add(name);
                        continue;
                    }
                    if (lName.endsWith(".png")) {
                        if (lName.equals("de/uniks/networkparser/np.png")) continue;
                        this.warnings.add(name);
                        continue;
                    }
                    if (lName.endsWith(".obj")) {
                        this.warnings.add(name);
                        continue;
                    }
                    if (lName.endsWith(".mtl")) {
                        this.warnings.add(name);
                        continue;
                    }
                    if (lName.endsWith(JARFILE)) {
                        this.warnings.add(name);
                        continue;
                    }
                    if (lName.endsWith(".java")) {
                        this.warnings.add(name);
                        continue;
                    }
                    if (!lName.endsWith(".html")) continue;
                    this.warnings.add(name);
                    continue;
                }
                if (!this.isInstance) continue;
                String entryName = name.substring(0, name.length() - CLASSFILESUFFIX.length());
                entryName = entryName.replace("/", ".");
                try {
                    Class<?> wantedClass = jarClassLoader.loadClass(entryName);
                    if (Modifier.isAbstract(wantedClass.getModifiers()) || wantedClass.isEnum() || wantedClass.isInterface() || wantedClass.isPrimitive() || !Modifier.isPublic(wantedClass.getModifiers()) || Modifier.isStatic(wantedClass.getModifiers())) continue;
                    if (timer == null) {
                        timer = new Timer();
                    }
                    SimpleTimerTask task = new SimpleTimerTask(Thread.currentThread());
                    timer.schedule((TimerTask)task, 2000L);
                    Object newInstance = ReflectionLoader.newInstanceSimple(wantedClass, "run");
                    task.withSimpleExit(null);
                    if (newInstance == null) {
                        this.errors.add(name);
                        continue;
                    }
                    tester.testClass(newInstance, wantedClass, null);
                }
                catch (Throwable e) {
                    this.errors.add(name + "-" + e.getMessage());
                }
            }
        }
        catch (Throwable e) {
            this.errors.add(file.getName() + "-" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
                if (jarClassLoader != null) {
                    jarClassLoader.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Exception fis) {}
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        ReflectionLoader.closeThreads(oldThreads);
        return false;
    }

    private boolean isProject(String item) {
        for (int i = 0; i < this.projects.size(); ++i) {
            if (!item.startsWith(this.projects.getKeyByIndex(i))) continue;
            return false;
        }
        return true;
    }

    private JsonObject getHTTPJson(String value) {
        HTMLEntity http = NodeProxyTCP.getHTTP("http://search.maven.org/solrsearch/select?rows=20&wt=json&q=fc:" + value);
        XMLEntity body = http.getBody();
        if (body != null && body.getValue() != null) {
            return JsonObject.create(body.getValue());
        }
        return null;
    }

    public SimpleKeyValueList<String, JsonObject> mergePackages() {
        this.projects.clear();
        TreeSet<String> cache = new TreeSet<String>();
        cache.add("de.uniks");
        cache.add("de");
        block0: for (String item : this.warningsPackages) {
            JsonObject json;
            if (!this.isProject(item) || (json = this.getHTTPJson(item)) == null) continue;
            JsonObject responseJson = json.getJsonObject("response");
            if (responseJson.getInt("numFound") > 0) {
                this.projects.add(item, responseJson);
                continue;
            }
            String[] split = item.split("\\.");
            for (int i = split.length - 1; i > 0; --i) {
                String search = split[0];
                for (int z = 1; z < i; ++z) {
                    search = search + "." + split[z];
                }
                if (cache.contains(search) || (json = this.getHTTPJson(search)) == null) continue;
                responseJson = json.getJsonObject("response");
                if (responseJson.getInt("numFound") > 0) {
                    this.projects.add(search, responseJson);
                    continue block0;
                }
                cache.add(search);
            }
        }
        return this.projects;
    }

    public int getMinCoverage() {
        return this.minCoverage;
    }

    public JarValidator withRootPath(String param) {
        this.rootPath = param;
        return this;
    }
}

