/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.DiagramEditor;
import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.Os;
import de.uniks.networkparser.ext.StartData;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.StringPrintStream;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.JavaAdapter;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.gui.JavaBridge;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleController
implements ObjectCondition {
    public static final String SEPARATOR = "------";
    public static final String USER = "USER";
    public static final String USERNAME = "USERNAME";
    public static final String CLOSE = "close";
    private Object stage;
    private JavaBridge bridge;
    private boolean firstShow = true;
    protected String icon;
    private String encodingCode = "utf-8";
    private String title;
    private ErrorHandler errorHandler = new ErrorHandler();
    protected Object popupMenu;
    protected Object trayIcon;
    private SimpleList<Object> listener = new SimpleList();
    private boolean isEclipse = Os.isEclipse();
    private String javaAgent;
    private String mainClass;
    private String outputParameter;

    public SimpleController(Object primitiveStage) {
        this(primitiveStage, true);
    }

    public SimpleController(Object primitiveStage, boolean init) {
        this.withStage(primitiveStage);
        if (init) {
            this.init();
        }
    }

    public void showContent(Object element) {
        Object content = this.createContent(element);
        if (content != null) {
            System.setOut(new StringPrintStream());
            this.show(content);
        }
    }

    public Object createContent(Object element) {
        if (element == null) {
            return null;
        }
        try {
            return ReflectionLoader.calling(element, "createContent", false, this, new Object[0]);
        }
        catch (Exception e) {
            this.errorHandler.saveException(e);
            return null;
        }
    }

    public SimpleController withStage(Object stage) {
        this.stage = stage;
        if (stage != null && stage.getClass().getName().startsWith("javafx")) {
            GUIEvent proxyHandler = new GUIEvent();
            proxyHandler.withListener(this);
            Object proxy = ReflectionLoader.createProxy(proxyHandler, ReflectionLoader.EVENTHANDLER);
            ReflectionLoader.call(stage, "setOnCloseRequest", ReflectionLoader.EVENTHANDLER, proxy);
            ReflectionLoader.call(stage, "setOnShowing", ReflectionLoader.EVENTHANDLER, proxy);
        }
        return this;
    }

    private Object getApplication() {
        Object result = ReflectionLoader.call(ReflectionLoader.PLATFORM, "isFxApplicationThread", new Object[0]);
        if (!Boolean.TRUE.equals(result)) {
            return null;
        }
        try {
            Map map;
            Object[] keys;
            Field params = ReflectionLoader.PARAMETER.getDeclaredField("params");
            params.setAccessible(true);
            Object value = params.get(null);
            if (value instanceof Map && (keys = (map = (Map)value).keySet().toArray()).length > 0) {
                return keys[keys.length - 1];
            }
        }
        catch (Exception e) {
            this.errorHandler.saveException(e);
        }
        return null;
    }

    public static SimpleController create(Object primaryStage) {
        SimpleController controller = new SimpleController(primaryStage);
        return controller;
    }

    protected Process init() {
        String outputFile = null;
        String debugPort = null;
        if (this.encodingCode != null && !this.encodingCode.equalsIgnoreCase(System.getProperty("file.encoding"))) {
            System.setProperty("file.encoding", this.encodingCode);
            Class<Charset> c = Charset.class;
            try {
                Field defaultCharsetField = c.getDeclaredField("defaultCharset");
                defaultCharsetField.setAccessible(true);
                defaultCharsetField.set(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SimpleKeyValueList<String, String> params = this.getParameterMap();
        ArrayList<Object> customParams = new ArrayList<Object>();
        for (int i = 0; i < params.size(); ++i) {
            String key = (String)params.get(i);
            if (key == null) continue;
            String value = params.getValueByIndex(i);
            if (key.equalsIgnoreCase("config")) {
                if (value == null) continue;
                StartData.setFileName(value);
                continue;
            }
            if (key.equalsIgnoreCase("debug")) {
                if (value != null) {
                    debugPort = value;
                    continue;
                }
                debugPort = "4223";
                continue;
            }
            if (key.equalsIgnoreCase("output")) {
                if (value != null) {
                    outputFile = value;
                    continue;
                }
                outputFile = "output.txt";
                continue;
            }
            if (key.equalsIgnoreCase("-?")) {
                System.out.println(this.getCommandHelp());
                Runtime.getRuntime().exit(1);
                continue;
            }
            if (!key.startsWith("-")) continue;
            if (value != null) {
                customParams.add(key + "=" + value);
                continue;
            }
            customParams.add(key);
        }
        if (this.javaAgent != null || debugPort != null) {
            ArrayList<String> items = new ArrayList<String>();
            if (Os.isMac()) {
                items.add(System.getProperty("java.home").replace("\\", "/") + "/bin/java");
            } else {
                items.add("\"" + System.getProperty("java.home").replace("\\", "/") + "/bin/java\"");
            }
            if (debugPort != null) {
                items.add("-Xdebug");
                items.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + debugPort);
                items.addAll(customParams);
                items.add("-jar");
                String fileName = Os.getFilename().toLowerCase();
                if ("bin".equals(fileName)) {
                    return null;
                }
                items.add(fileName);
            }
            if (this.javaAgent != null) {
                String path = this.errorHandler.getPath();
                Object agent = this.javaAgent;
                if (path != null) {
                    agent = (String)agent + "=destfile=" + path + "jacoco.exec";
                }
                items.add("-javaagent:" + (String)agent);
                items.add(DiagramEditor.class.getName());
                items.add("test=" + this.mainClass);
                if (path != null) {
                    items.add("path=" + path);
                }
            }
            if (Os.isReflectionTest()) {
                return null;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(items);
            Map<String, String> environment = processBuilder.environment();
            environment.put("CLASSPATH", System.getProperty("java.class.path"));
            if (outputFile == null && this.outputParameter != null) {
                outputFile = this.outputParameter;
            }
            if (!(this.isEclipse && this.outputParameter == null || outputFile == null)) {
                if (outputFile.equalsIgnoreCase("inherit")) {
                    processBuilder.redirectErrorStream(true);
                    ReflectionLoader.call(processBuilder, "redirectOutput", ReflectionLoader.PROCESSBUILDERREDIRECT, ReflectionLoader.getField("INHERIT", ReflectionLoader.PROCESSBUILDERREDIRECT));
                } else {
                    int pos = outputFile.lastIndexOf(".");
                    if (pos > 0) {
                        ReflectionLoader.call(processBuilder, "redirectError", File.class, new File(outputFile.substring(0, pos) + "_error" + outputFile.substring(pos)));
                        ReflectionLoader.call(processBuilder, "redirectOutput", File.class, new File(outputFile.substring(0, pos) + "_stdout" + outputFile.substring(pos)));
                    } else {
                        ReflectionLoader.call(processBuilder, "redirectError", File.class, new File(outputFile + "_error.txt"));
                        ReflectionLoader.call(processBuilder, "redirectOutput", File.class, new File(outputFile + "_stdout.txt"));
                    }
                }
            }
            try {
                Process start = processBuilder.start();
                if (this.javaAgent != null) {
                    return start;
                }
                Runtime.getRuntime().exit(1);
            }
            catch (IOException e) {
                this.errorHandler.saveException(e);
            }
        }
        return null;
    }

    public SimpleKeyValueList<String, String> getParameterMap() {
        SimpleKeyValueList<String, String> map = new SimpleKeyValueList<String, String>();
        List raw = (List)ReflectionLoader.callChain(this.getApplication(), "getParameters", "getRaw");
        if (raw != null) {
            for (String item : raw) {
                if (item.startsWith("--")) {
                    item = item.substring(2);
                }
                int pos = item.indexOf(":");
                int posEnter = item.indexOf("=");
                if (posEnter > 0 && (posEnter < pos || pos == -1)) {
                    pos = posEnter;
                }
                if (pos > 0) {
                    map.add(item.substring(0, pos), item.substring(pos + 1));
                    continue;
                }
                map.add(item, null);
            }
        }
        return map;
    }

    public String getUserName(String ... defaultName) {
        SimpleKeyValueList<String, String> parameterMap = this.getParameterMap();
        for (int i = 0; i < parameterMap.size(); ++i) {
            String key = parameterMap.getKeyByIndex(i);
            if (USER.equalsIgnoreCase(key)) {
                return (String)parameterMap.get(i);
            }
            if (!USERNAME.equalsIgnoreCase(key)) continue;
            return (String)parameterMap.get(i);
        }
        if (defaultName != null && defaultName.length > 0 && defaultName[0] instanceof String) {
            return defaultName[0];
        }
        return "";
    }

    public void show(Object root, boolean wait, boolean newStage) {
        Object scene;
        Object oldStage = null;
        if (newStage) {
            oldStage = this.stage;
            this.withStage(ReflectionLoader.newInstance(ReflectionLoader.STAGE, new Object[0]));
            this.refreshIcon();
        }
        this.firstShow = false;
        if (ReflectionLoader.SCENE == null || root == null) {
            return;
        }
        if (ReflectionLoader.SCENE.isAssignableFrom(root.getClass())) {
            scene = root;
        } else if (root instanceof JavaBridge) {
            this.bridge = (JavaBridge)root;
            JavaViewAdapter adapter = this.bridge.getViewAdapter();
            Object webView = adapter.getWebView();
            scene = ReflectionLoader.newInstance(ReflectionLoader.SCENE, ReflectionLoader.PARENT, webView);
        } else {
            scene = ReflectionLoader.newInstance(ReflectionLoader.SCENE, ReflectionLoader.PARENT, root);
        }
        ReflectionLoader.call(this.stage, "setScene", ReflectionLoader.SCENE, scene);
        if (root instanceof ObjectCondition) {
            this.withListener((ObjectCondition)root);
        }
        GUIEvent event = new GUIEvent();
        event.withListener(this);
        Object proxy = ReflectionLoader.createProxy(event, ReflectionLoader.EVENTHANDLER);
        ReflectionLoader.call(scene, "setOnKeyPressed", ReflectionLoader.EVENTHANDLER, proxy);
        this.showing(wait);
        if (oldStage != null) {
            ReflectionLoader.call(oldStage, CLOSE, new Object[0]);
        }
    }

    public void show(Object root) {
        this.show(root, false, !this.firstShow);
    }

    public Object getCurrentScene() {
        return ReflectionLoader.call(this.stage, "getScene", new Object[0]);
    }

    public Object getStage() {
        return this.stage;
    }

    protected void showing(boolean wait) {
        if (this.stage != null) {
            this.init();
            ReflectionLoader.call(this.stage, "setTitle", this.getTitle());
            if (Os.isEclipse()) {
                if (wait) {
                    ReflectionLoader.calling(this.stage, "showAndWait", true, this.errorHandler, new Object[0]);
                } else {
                    ReflectionLoader.calling(this.stage, "show", true, this.errorHandler, new Object[0]);
                }
            } else {
                try {
                    if (wait) {
                        ReflectionLoader.calling(this.stage, "showAndWait", true, this.errorHandler, new Object[0]);
                    } else {
                        ReflectionLoader.calling(this.stage, "show", true, this.errorHandler, new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.errorHandler.saveException(e, this.stage, true);
                }
            }
        }
    }

    public int start() {
        Process p = this.init();
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public SimpleController withAgent(String agent, String backBoxTester, String ... mainClass) {
        this.javaAgent = agent;
        CharacterBuffer testClasses = new CharacterBuffer();
        if (mainClass != null) {
            for (String test : mainClass) {
                if (testClasses.length() > 0) {
                    testClasses.with(',');
                }
                testClasses.with(test);
            }
        }
        if (backBoxTester != null) {
            if (testClasses.length() > 0) {
                testClasses.with(',');
            }
            testClasses.add("backboxtest=" + backBoxTester);
        }
        this.mainClass = testClasses.toString();
        return this;
    }

    public SimpleController withAgent(String agent, boolean backBoxTester, String ... mainClass) {
        if (backBoxTester) {
            return this.withAgent(agent, "", mainClass);
        }
        return this.withAgent(agent, null, mainClass);
    }

    public SimpleController withOutput(String value) {
        this.outputParameter = value;
        return this;
    }

    public String getEncodingCode() {
        return this.encodingCode;
    }

    public void withEncodingCode(String value) {
        this.encodingCode = value;
    }

    protected String getCommandHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Help for the Commandline - ");
        sb.append(this.getTitle());
        sb.append("\n\n");
        sb.append("Debug\t\tDebug with <port> for debugging. Default is 4223\n");
        sb.append("Output\t\tOutput the debug output in standard-outputstream or file\n");
        return sb.toString();
    }

    public SimpleController withEclipse(boolean enableThrows) {
        this.isEclipse = enableThrows;
        return this;
    }

    public SimpleController withErrorPath(String value) {
        this.errorHandler.withPath(value);
        if (!this.isEclipse) {
            if (Thread.getDefaultUncaughtExceptionHandler() == null) {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        SimpleController.this.errorHandler.saveException(e);
                    }
                });
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        SimpleController.this.errorHandler.saveException(e);
                    }
                });
            }
            System.setOut(new StringPrintStream(this.errorHandler, false));
            System.setErr(new StringPrintStream(this.errorHandler, true));
        }
        return this;
    }

    public void withTitle(String value) {
        this.title = value;
    }

    public SimpleController withIcon(String value) {
        return this.withIcon(value, null);
    }

    public SimpleController withIcon(String value, Class<?> relative) {
        URL resource;
        if (relative != null && (resource = relative.getResource(value)) != null) {
            value = resource.toString();
        }
        this.icon = value;
        if (value == null) {
            return this;
        }
        if (this.stage != null) {
            this.refreshIcon();
        }
        if (this.trayIcon != null) {
            URL iconURL = null;
            try {
                iconURL = this.icon.startsWith("file") || this.icon.startsWith("jar") ? new URL(this.icon) : new URL("file:" + this.icon);
                Object toolKit = ReflectionLoader.call(ReflectionLoader.TOOLKIT, "getDefaultToolkit", new Object[0]);
                Object image = ReflectionLoader.call(toolKit, "getImage", URL.class, iconURL);
                Object newImage = ReflectionLoader.call(image, "getScaledInstance", Integer.TYPE, 16, Integer.TYPE, 16, Integer.TYPE, 4);
                ReflectionLoader.call(this.trayIcon, "setImage", ReflectionLoader.AWTIMAGE, newImage);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this;
    }

    private void refreshIcon() {
        Object image = this.icon.startsWith("file") || this.icon.startsWith("jar") ? ReflectionLoader.newInstance(ReflectionLoader.IMAGE, this.icon) : ReflectionLoader.newInstance(ReflectionLoader.IMAGE, "file:" + this.icon);
        List icons = (List)ReflectionLoader.call(this.stage, "getIcons", new Object[0]);
        icons.add(image);
    }

    public SimpleController withToolTip(String text) {
        if (this.trayIcon != null) {
            ReflectionLoader.call(this.trayIcon, "setToolTip", String.class, text);
        }
        return this;
    }

    public SimpleController withSize(double width, double height) {
        ReflectionLoader.call(this.stage, "setWidth", Double.TYPE, width);
        ReflectionLoader.call(this.stage, "setHeight", Double.TYPE, height);
        return this;
    }

    public SimpleController withFullScreen(boolean value) {
        ReflectionLoader.call(this.stage, "setFullScreen", Boolean.TYPE, value);
        return this;
    }

    public SimpleController withAlwaysOnTop(boolean value) {
        ReflectionLoader.call(this.stage, "setAlwaysOnTop", Boolean.TYPE, value);
        return this;
    }

    public String getTitle() {
        Object caption = "";
        String temp = this.title;
        if (temp != null) {
            caption = temp + " ";
        }
        return (String)caption + SimpleController.getVersion() + " (" + System.getProperty("file.encoding") + " - " + System.getProperty("sun.arch.data.model") + "-Bit)";
    }

    public Object addTrayMenuItem(String text, ObjectCondition listener) {
        Object item = ReflectionLoader.newInstance(ReflectionLoader.MENUITEM, String.class, text);
        GUIEvent event = new GUIEvent().withListener(this);
        this.withListener(listener);
        Object actionListener = ReflectionLoader.createProxy(event, ReflectionLoader.ACTIONLISTENER);
        ReflectionLoader.call(item, "addActionListener", ReflectionLoader.ACTIONLISTENER, actionListener);
        ReflectionLoader.call(this.getPopUp(), "add", ReflectionLoader.MENUITEM, item);
        return item;
    }

    public void addTraySeperator() {
        ReflectionLoader.call(this.getPopUp(), "addSeparator", new Object[0]);
    }

    private Object getPopUp() {
        if (this.popupMenu == null) {
            this.popupMenu = ReflectionLoader.newInstance(ReflectionLoader.POPUPMENU, new Object[0]);
        }
        return this.popupMenu;
    }

    public Object showTrayIcon(String ... labels) {
        if (!Os.checkSystemTray()) {
            return null;
        }
        if (this.icon != null && this.icon.length() > 0) {
            try {
                URL iconURL = this.icon.startsWith("file") || this.icon.startsWith("jar") ? new URL(this.icon) : new URL("file:" + this.icon);
                Object toolKit = ReflectionLoader.call(ReflectionLoader.TOOLKIT, "getDefaultToolkit", new Object[0]);
                Object image = ReflectionLoader.call(toolKit, "getImage", URL.class, iconURL);
                Object newImage = ReflectionLoader.call(image, "getScaledInstance", Integer.TYPE, 16, Integer.TYPE, 16, Integer.TYPE, 4);
                this.close();
                this.trayIcon = ReflectionLoader.newInstance(ReflectionLoader.TRAYICON, ReflectionLoader.AWTIMAGE, newImage);
                Integer count = (Integer)ReflectionLoader.call(this.getPopUp(), "getItemCount", new Object[0]);
                if (labels != null) {
                    for (String label : labels) {
                        if (label == null) continue;
                        this.addTrayMenuItem(label, null);
                    }
                }
                if (count < 1) {
                    this.addTrayMenuItem(CLOSE, this);
                }
                ReflectionLoader.call(this.trayIcon, "setPopupMenu", ReflectionLoader.POPUPMENU, this.popupMenu);
                Object systemTray = ReflectionLoader.call(ReflectionLoader.SYSTEMTRAY, "getSystemTray", new Object[0]);
                ReflectionLoader.call(systemTray, "add", ReflectionLoader.TRAYICON, this.trayIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.trayIcon;
    }

    public void close() {
        if (this.stage != null) {
            ReflectionLoader.call(this.stage, CLOSE, new Object[0]);
            this.stage = null;
        }
        if (this.trayIcon != null) {
            Object systemTray = ReflectionLoader.call(ReflectionLoader.SYSTEMTRAY, "getSystemTray", new Object[0]);
            ReflectionLoader.call(systemTray, "remove", ReflectionLoader.TRAYICON, this.trayIcon);
            this.trayIcon = null;
        }
    }

    public static String getVersion() {
        String result = SimpleController.class.getPackage().getImplementationVersion();
        if (result == null) {
            result = "0.42.DEBUG";
        }
        return result;
    }

    public SimpleController withListener(ObjectCondition value) {
        this.listener.add((Object)value);
        return this;
    }

    public void saveException(Throwable e) {
        this.errorHandler.saveException(e);
    }

    public SimpleController withListener(GUIEvent listener) {
        this.listener.add((Object)listener);
        return this;
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Throwable) {
            this.saveException((Throwable)value);
            return true;
        }
        GUIEvent evt = GUIEvent.create(value);
        if (evt.isSubEventName("java.awt.event.ActionEvent") && CLOSE.equals(evt.getId())) {
            this.close();
        }
        for (Object v : this.listener) {
            ObjectCondition match = evt.match(v);
            if (match == null || match == null || match == this) continue;
            match.update(evt);
        }
        return true;
    }

    public static SimpleController create() {
        return new SimpleController(null);
    }

    public void hide() {
        if (this.stage != null) {
            ReflectionLoader.call(this.stage, "hide", new Object[0]);
        }
    }

    public static SimpleController create(JavaBridge bridge, final ObjectCondition listener, boolean exitOnClose, boolean wait) {
        final SimpleController controller = new SimpleController(null);
        Class<?> launcherClass = ReflectionLoader.getClass("com.sun.javafx.application.LauncherImpl");
        controller.withBridge(bridge);
        if (launcherClass == null) {
            NodeProxyTCP server = NodeProxyTCP.createServer(8080);
            server.withListener(listener);
            if (server.start()) {
                Object desktop;
                System.out.println("LISTEN ON: " + server.getKey());
                if (ReflectionLoader.DESKTOP != null && (desktop = ReflectionLoader.call(ReflectionLoader.DESKTOP, "getDesktop", new Object[0])) != null) {
                    try {
                        ReflectionLoader.call(desktop, "browse", URI.class, new URI("http://" + server.getKey()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return controller;
        }
        ReflectionLoader.call(launcherClass, "startToolkit", new Object[0]);
        if (!exitOnClose) {
            ReflectionLoader.call(ReflectionLoader.PLATFORM, "setImplicitExit", Boolean.TYPE, false);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object stage = ReflectionLoader.newInstance(ReflectionLoader.STAGE, new Object[0]);
                controller.withStage(stage);
                controller.withListener(listener);
                controller.withIcon(IdMap.class.getResource("np.png").toString());
                controller.show(controller.getBridge());
            }
        };
        if (wait) {
            JavaAdapter.executeAndWait(runnable);
        } else {
            JavaAdapter.execute(runnable);
        }
        return controller;
    }

    public SimpleController withBridge(JavaBridge value) {
        this.bridge = value;
        return this;
    }

    public JavaBridge getBridge() {
        return this.bridge;
    }
}

