/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.qr;

import de.uniks.networkparser.bytes.qr.BitMatrix;
import de.uniks.networkparser.bytes.qr.FormatInformation;
import de.uniks.networkparser.bytes.qr.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) {
        int dimension = bitMatrix.getHeight();
        if (dimension < 21 || (dimension & 3) != 1) {
            throw new RuntimeException("FormatException");
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() {
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int formatInfoBits1 = 0;
        for (int i = 0; i < 6; ++i) {
            formatInfoBits1 = this.copyBit(i, 8, formatInfoBits1);
        }
        formatInfoBits1 = this.copyBit(7, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 8, formatInfoBits1);
        formatInfoBits1 = this.copyBit(8, 7, formatInfoBits1);
        for (int j = 5; j >= 0; --j) {
            formatInfoBits1 = this.copyBit(8, j, formatInfoBits1);
        }
        int dimension = this.bitMatrix.getHeight();
        int formatInfoBits2 = 0;
        int jMin = dimension - 7;
        for (int j = dimension - 1; j >= jMin; --j) {
            formatInfoBits2 = this.copyBit(8, j, formatInfoBits2);
        }
        for (int i = dimension - 8; i < dimension; ++i) {
            formatInfoBits2 = this.copyBit(i, 8, formatInfoBits2);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(formatInfoBits1, formatInfoBits2);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw new RuntimeException("FormatException");
    }

    Version readVersion() {
        int i;
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int dimension = this.bitMatrix.getHeight();
        int provisionalVersion = (dimension - 17) / 4;
        if (provisionalVersion <= 6) {
            return Version.getVersionForNumber(provisionalVersion);
        }
        int versionBits = 0;
        int ijMin = dimension - 11;
        for (int j = 5; j >= 0; --j) {
            for (i = dimension - 9; i >= ijMin; --i) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        Version theParsedVersion = Version.decodeVersionInformation(versionBits);
        if (theParsedVersion != null && theParsedVersion.getDimensionForVersion() == dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        versionBits = 0;
        for (i = 5; i >= 0; --i) {
            for (int j = dimension - 9; j >= ijMin; --j) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        theParsedVersion = Version.decodeVersionInformation(versionBits);
        if (theParsedVersion != null && theParsedVersion.getDimensionForVersion() == dimension) {
            this.parsedVersion = theParsedVersion;
            return theParsedVersion;
        }
        throw new RuntimeException("FormatException");
    }

    private int copyBit(int i, int j, int versionBits) {
        boolean bit = this.mirror ? this.bitMatrix.get(j, i) : this.bitMatrix.get(i, j);
        return bit ? versionBits << 1 | 1 : versionBits << 1;
    }

    byte[] readCodewords() {
        FormatInformation formatInfo = this.readFormatInformation();
        Version version = this.readVersion();
        int dimension = this.bitMatrix.getHeight();
        this.unmaskBitMatrix(formatInfo.getDataMask(), this.bitMatrix, dimension);
        BitMatrix functionPattern = version.buildFunctionPattern();
        boolean readingUp = true;
        byte[] result = new byte[version.getTotalCodewords()];
        int resultOffset = 0;
        int currentByte = 0;
        int bitsRead = 0;
        for (int j = dimension - 1; j > 0; j -= 2) {
            if (j == 6) {
                --j;
            }
            for (int count = 0; count < dimension; ++count) {
                int i = readingUp ? dimension - 1 - count : count;
                for (int col = 0; col < 2; ++col) {
                    if (functionPattern.get(j - col, i)) continue;
                    ++bitsRead;
                    currentByte <<= 1;
                    if (this.bitMatrix.get(j - col, i)) {
                        currentByte |= 1;
                    }
                    if (bitsRead != 8) continue;
                    result[resultOffset++] = (byte)currentByte;
                    bitsRead = 0;
                    currentByte = 0;
                }
            }
            readingUp ^= true;
        }
        if (resultOffset != version.getTotalCodewords()) {
            throw new RuntimeException("FormatException");
        }
        return result;
    }

    final void unmaskBitMatrix(byte mask, BitMatrix bits, int dimension) {
        block17: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block16: {
                                        if (mask != 0) break block16;
                                        for (int i = 0; i < dimension; ++i) {
                                            for (int j = 0; j < dimension; ++j) {
                                                if ((i + j & 1) != 0) continue;
                                                bits.flip(j, i);
                                            }
                                        }
                                        break block17;
                                    }
                                    if (mask != 1) break block18;
                                    for (int i = 0; i < dimension; ++i) {
                                        for (int j = 0; j < dimension; ++j) {
                                            if ((i & 1) != 0) continue;
                                            bits.flip(j, i);
                                        }
                                    }
                                    break block17;
                                }
                                if (mask != 2) break block19;
                                for (int i = 0; i < dimension; ++i) {
                                    for (int j = 0; j < dimension; ++j) {
                                        if (j % 3 != 0) continue;
                                        bits.flip(j, i);
                                    }
                                }
                                break block17;
                            }
                            if (mask != 3) break block20;
                            for (int i = 0; i < dimension; ++i) {
                                for (int j = 0; j < dimension; ++j) {
                                    if ((i + j) % 3 != 0) continue;
                                    bits.flip(j, i);
                                }
                            }
                            break block17;
                        }
                        if (mask != 4) break block21;
                        for (int i = 0; i < dimension; ++i) {
                            for (int j = 0; j < dimension; ++j) {
                                if ((i / 2 + j / 3 & 1) != 0) continue;
                                bits.flip(j, i);
                            }
                        }
                        break block17;
                    }
                    if (mask != 5) break block22;
                    for (int i = 0; i < dimension; ++i) {
                        for (int j = 0; j < dimension; ++j) {
                            int temp = i * j;
                            if ((temp & 1) + temp % 3 != 0) continue;
                            bits.flip(j, i);
                        }
                    }
                    break block17;
                }
                if (mask != 6) break block23;
                for (int i = 0; i < dimension; ++i) {
                    for (int j = 0; j < dimension; ++j) {
                        int temp = i * j;
                        if (((temp & 1) + temp % 3 & 1) != 0) continue;
                        bits.flip(j, i);
                    }
                }
                break block17;
            }
            if (mask != 7) break block17;
            for (int i = 0; i < dimension; ++i) {
                for (int j = 0; j < dimension; ++j) {
                    if (((i + j & 1) + i * j % 3 & 1) != 0) continue;
                    bits.flip(j, i);
                }
            }
        }
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        int dimension = this.bitMatrix.getHeight();
        this.unmaskBitMatrix(this.parsedFormatInfo.getDataMask(), this.bitMatrix, dimension);
    }

    void setMirror(boolean mirror) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = mirror;
    }

    void mirror() {
        for (int x = 0; x < this.bitMatrix.getWidth(); ++x) {
            for (int y = x + 1; y < this.bitMatrix.getHeight(); ++y) {
                if (this.bitMatrix.get(x, y) == this.bitMatrix.get(y, x)) continue;
                this.bitMatrix.flip(y, x);
                this.bitMatrix.flip(x, y);
            }
        }
    }
}

