/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.converter.GraphConverter;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLTokener;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HTMLEntity
implements BaseItem {
    public static final String PROPERTY_HEADER = "head";
    public static final String PROPERTY_BODY = "body";
    public static final String IMAGEFORMAT = " .bmp .jpg .jpeg .png .gif .svg ";
    public static final String SCRIPT = "script";
    public static final String LINK = "link";
    public static final String KEY_HREF = "href";
    public static final String KEY_SRC = "src";
    private XMLEntity body = new XMLEntity().setType("body");
    private XMLEntity header = new XMLEntity().setType("head");
    private Map<String, List<String>> conenctionHeader = new SimpleKeyValueList<String, List<String>>();
    private int statusCode = 200;
    private String statusMessage;

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    public XMLEntity getHeader() {
        return this.header;
    }

    public XMLEntity getBody() {
        return this.body;
    }

    public HTMLEntity withEncoding(String encoding) {
        XMLEntity metaTag = new XMLEntity().setType("meta");
        metaTag.withKeyValue("http-equiv", "Content-Type");
        metaTag.withKeyValue("content", "text/html;charset=" + encoding);
        this.header.with(metaTag);
        return this;
    }

    public HTMLEntity withPageBreak() {
        XMLEntity pageBreak = new XMLEntity().setType("div").withCloseTag();
        pageBreak.put("style", "page-break-before:always");
        this.body.withChild(pageBreak);
        return this;
    }

    public HTMLEntity withTitle(String value) {
        XMLEntity titleTag = new XMLEntity().setType("title").withValue(value);
        this.header.with(titleTag);
        return this;
    }

    public HTMLEntity withScript(CharSequence value, XMLEntity parentNode) {
        if (value != null) {
            this.createScript(value.toString(), parentNode);
        }
        return this;
    }

    public XMLEntity createScript(String value, XMLEntity parentNode) {
        XMLEntity node = new XMLEntity().setType(SCRIPT).withKeyValue("language", "Javascript");
        if (value == null) {
            return node;
        }
        if (value.endsWith(".js") && value.indexOf("\n") < 0) {
            if (parentNode == null) {
                parentNode = this.header;
            }
            node.withCloseTag();
            node.withKeyValue(KEY_SRC, value);
        } else {
            if (parentNode == null) {
                parentNode = this.body;
            }
            node.withValue(value);
        }
        parentNode.with(node);
        return node;
    }

    public HTMLEntity withHeaderStyle(CharSequence value) {
        if (value != null) {
            XMLEntity headerChild = new XMLEntity().setType("style").withValue(value.toString());
            this.header.with(headerChild);
        }
        return this;
    }

    protected String parseItem(EntityStringConverter converter) {
        if (converter == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        converter.add();
        sb.append(this.header.toString(converter));
        sb.append(this.body.toString(converter));
        converter.minus();
        sb.append("</html>");
        return sb.toString();
    }

    public HTMLEntity with(Object ... values) {
        this.add(values);
        return this;
    }

    @Override
    public boolean add(Object ... values) {
        block8: {
            block6: {
                Entity body;
                block7: {
                    if (values == null) {
                        return false;
                    }
                    if (values.length != 1 || !(values[0] instanceof String)) break block6;
                    XMLTokener tokener = new XMLTokener();
                    String content = (String)values[0];
                    tokener.withBuffer(content);
                    XMLEntity item = new XMLEntity();
                    tokener.parseToEntity(item);
                    Entity header = item.getElementBy("tag", "header");
                    if (header != null && header instanceof XMLEntity) {
                        this.header = (XMLEntity)header;
                    }
                    if ((body = item.getElementBy("tag", PROPERTY_BODY)) != null || header != null) break block7;
                    this.body = item;
                    break block8;
                }
                if (body == null || !(body instanceof XMLEntity)) break block8;
                this.body = (XMLEntity)body;
                break block8;
            }
            if (values.length % 2 == 0) {
                this.body.with(values);
            } else {
                for (Object item : values) {
                    if (item instanceof XMLEntity) {
                        this.body.withChild((XMLEntity)item);
                        continue;
                    }
                    if (!(item instanceof CharacterBuffer)) continue;
                    this.body.withValue(item.toString());
                }
            }
        }
        return true;
    }

    public Object getValue(Object key) {
        Object result = this.header.getValue(key);
        if (result != null) {
            return result;
        }
        return this.body.getValue(key);
    }

    public HTMLEntity withHeader(String ref) {
        XMLEntity child = this.getChild(ref);
        if (child != null) {
            this.header.with(child);
        }
        return this;
    }

    public HTMLEntity withBase(String path) {
        XMLEntity child = XMLEntity.TAG("base");
        child.add(KEY_HREF, path);
        this.header.with(child);
        return this;
    }

    XMLEntity getChild(String ref) {
        XMLEntity child = null;
        if (ref == null) {
            return null;
        }
        int pos = ref.lastIndexOf(".");
        if (pos > 0) {
            String ext = ref.substring(pos).toLowerCase();
            if (ext.equals(".css")) {
                child = new XMLEntity().setType(LINK);
                child.withKeyValue("rel", "stylesheet");
                child.withKeyValue("type", "text/css");
                child.withKeyValue(KEY_HREF, ref);
            } else if (ext.equals(".js")) {
                child = new XMLEntity().setType(SCRIPT).withCloseTag();
                child.withKeyValue(KEY_SRC, ref);
            } else if (IMAGEFORMAT.indexOf(" " + ext + " ") >= 0) {
                child = new XMLEntity().setType("img").withCloseTag();
                child.withKeyValue(KEY_SRC, ref);
            }
        }
        if (child == null) {
            child = new XMLEntity().withValueItem(ref);
        }
        return child;
    }

    public HTMLEntity withBody(String ref) {
        XMLEntity child = this.getChild(ref);
        if (child != null) {
            this.body.with(child);
        }
        return this;
    }

    public XMLEntity createTag(String tag, XMLEntity parentNode) {
        if (parentNode == null) {
            parentNode = this.body;
        }
        if (tag == null) {
            return null;
        }
        String[] tags = tag.split("\\.");
        XMLEntity parent = null;
        XMLEntity child = null;
        XMLEntity firstChild = null;
        for (int i = tags.length - 1; i >= 0; --i) {
            child = parent;
            parent = new XMLEntity().setType(tags[i]);
            if (child != null) {
                parent.withChild(child);
                continue;
            }
            firstChild = parent;
        }
        parentNode.withChild(parent);
        return firstChild;
    }

    public XMLEntity createTable(XMLEntity parentNode, String ... labels) {
        XMLEntity table = this.createTag("table", parentNode);
        if (labels != null && labels.length > 0) {
            table.with("style", labels[0]);
            XMLEntity tr = this.createTag("tr", table);
            for (int i = 1; i < labels.length; i += 2) {
                this.createTag("td", tr);
                table.with("style", labels[i]);
                table.withValue(labels[i + 1]);
            }
        }
        return table;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new SimpleSet();
    }

    public HTMLEntity addStyle(String name, String style) {
        XMLEntity styleElement = null;
        for (int i = 0; i < this.header.size(); ++i) {
            XMLEntity xml;
            BaseItem child = this.header.getChild(i);
            if (!(child instanceof XMLEntity) || !(xml = (XMLEntity)child).getTag().equals(name)) continue;
            styleElement = xml;
        }
        if (styleElement == null) {
            XMLEntity element = new XMLEntity().setType("style");
            this.header.with(element);
            styleElement = element;
        }
        styleElement.withValue(styleElement.getValue() + "\r\n" + style);
        return this;
    }

    public HTMLEntity withGraph(GraphModel value) {
        URL resource = GraphList.class.getResource("");
        if (resource == null || value == null) {
            return this;
        }
        String graph = value.toString(new GraphConverter());
        return this.withGraph(graph, resource.toString());
    }

    public HTMLEntity withGraph(Entity value) {
        URL resource = GraphList.class.getResource("");
        if (resource == null || value == null) {
            return this;
        }
        return this.withGraph(value.toString(2), resource.toString());
    }

    public HTMLEntity withGraph(String graph, String path) {
        XMLEntity script = new XMLEntity().setType(SCRIPT).withKeyValue("type", "text/javascript");
        StringBuilder sb = new StringBuilder();
        sb.append("var json=");
        sb.append(graph);
        sb.append(";\r\n");
        sb.append("new Graph(json).layout();");
        script.withValue(sb.toString());
        this.add(script);
        if (path != null) {
            SimpleList list = (SimpleList)new SimpleList().with("diagramstyle.css", "graph.js", "dagre.min.js", "drawer.js");
            for (int i = 0; i < this.header.sizeChildren(); ++i) {
                Object item = (XMLEntity)this.header.getChild(i);
                String url = null;
                if (LINK.equals(((XMLEntity)item).getTag())) {
                    url = ((SimpleKeyValueList)item).getString(KEY_HREF);
                } else if (SCRIPT.equals(((XMLEntity)item).getTag())) {
                    url = ((SimpleKeyValueList)item).getString(KEY_SRC);
                }
                if (url == null) continue;
                int pos = url.lastIndexOf(47);
                if (pos >= 0) {
                    url = url.substring(pos + 1);
                }
                list.remove(url);
            }
            for (Object item : list) {
                this.withHeader(path + (String)item);
            }
            this.withEncoding("utf-8");
        }
        return this;
    }

    public HTMLEntity withNewLine() {
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue("<br />\r\n");
        this.body.withChild(xmlEntity);
        return this;
    }

    public HTMLEntity withText(String text) {
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue(text);
        this.body.withChild(xmlEntity);
        return this;
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof EntityStringConverter) {
            return this.parseItem((EntityStringConverter)converter);
        }
        return converter.encode(this);
    }

    @Override
    public int size() {
        return this.body.size();
    }

    public XMLEntity getElementsBy(String key, String value) {
        BaseItem child;
        int z;
        XMLEntity item = new XMLEntity();
        EntityList headerList = this.header.getElementsBy(key, value);
        EntityList bodyList = this.body.getElementsBy(key, value);
        if (headerList != null) {
            for (z = 0; z < headerList.sizeChildren(); ++z) {
                child = headerList.getChild(z);
                if (!(child instanceof EntityList)) continue;
                item.withChild((EntityList)child);
            }
        }
        if (bodyList != null) {
            for (z = 0; z < bodyList.sizeChildren(); ++z) {
                child = bodyList.getChild(z);
                if (!(child instanceof EntityList)) continue;
                item.withChild((EntityList)child);
            }
        }
        return item;
    }

    public BaseItem getElementBy(String key, String value) {
        Entity item = this.header.getElementBy(key, value);
        if (item != null) {
            return item;
        }
        item = this.body.getElementBy(key, value);
        return item;
    }

    public HTMLEntity withValue(String value) {
        XMLEntity htmlPage = new XMLEntity().withValue(value);
        for (int i = 0; i < htmlPage.sizeChildren(); ++i) {
            BaseItem item = htmlPage.getChild(i);
            if (!(item instanceof XMLEntity)) continue;
            XMLEntity child = (XMLEntity)item;
            if (PROPERTY_HEADER.equalsIgnoreCase(child.getTag())) {
                this.header = child;
                continue;
            }
            if (!PROPERTY_BODY.equalsIgnoreCase(child.getTag())) continue;
            this.body = child;
        }
        return this;
    }

    public HTMLEntity withStatus(int code, String message) {
        this.statusCode = code;
        this.statusMessage = message;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HTMLEntity withConnectionHeader(String key, String value) {
        SimpleList list = (SimpleList)new SimpleList().with(value);
        this.conenctionHeader.put(key, list);
        return this;
    }

    public HTMLEntity withConnectionHeader(Map<String, List<String>> headerFields) {
        for (String key : headerFields.keySet()) {
            this.conenctionHeader.put(key, headerFields.get(key));
        }
        return this;
    }

    public Map<String, List<String>> getConnectionHeader() {
        return this.conenctionHeader;
    }

    public String getConnectionHeader(String key) {
        List<String> list = this.conenctionHeader.get(key);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public List<String> getConnectionHeaders(String key) {
        return this.conenctionHeader.get(key);
    }
}

