/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphLabel;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphNode;
import de.uniks.networkparser.graph.GraphOptions;
import de.uniks.networkparser.graph.GraphPattern;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.Value;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.ParameterSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleSet;
import java.util.ArrayList;

public class GraphConverter
implements Converter {
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String NODE = "node";
    public static final String CLAZZ = "clazz";
    public static final String PATTERN = "pattern";
    public static final String SUBGRAPH = "subgraph";
    public static final String ATTRIBUTES = "attributes";
    public static final String METHODS = "methods";
    public static final String NODES = "nodes";
    public static final String LABEL = "label";
    public static final String EDGES = "edges";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String CARDINALITY = "cardinality";
    public static final String PROPERTY = "property";
    public static final String HEAD = "head";
    public static final String SRC = "src";
    public static final String OPTIONS = "options";
    private static final String STYLE = "style";
    private static final String INFO = "info";
    private static final String COUNTER = "counter";
    private static final String MODIFIERS = "modifiers";
    private static final String BODY = "body";
    private static final String PARAMETER = "parameter";
    private Entity factory = new JsonObject();
    private boolean full = false;

    public GraphList convertGraphList(String type, EntityList list) {
        GraphList root = new GraphList().withType(type);
        for (int i = 0; i < list.size(); ++i) {
            BaseItem item = list.getChild(i);
            if (!(item instanceof Entity)) continue;
            this.parseJsonObject(root, (Entity)item);
        }
        return root;
    }

    public Entity convertToJson(String type, EntityList list, boolean removePackage) {
        GraphList root = this.convertGraphList(type, list);
        return this.convertToJson(root, removePackage, false);
    }

    public Clazz parseJsonObject(GraphList root, Entity node) {
        Clazz graphNode;
        String id;
        String typeId = id = node.getString(ID);
        boolean isClassDiagram = "classdiagram".equalsIgnoreCase(root.getType());
        if (isClassDiagram) {
            typeId = node.getString("class");
            id = null;
        }
        if ((graphNode = GraphUtil.getByObject(root, typeId, true)) == null) {
            graphNode = new Clazz(node.getString("class"));
            if (id != null) {
                GraphUtil.setId(graphNode, id);
            }
            root.with(graphNode);
        }
        if (node.has(HEAD)) {
            GraphUtil.setGraphImage(graphNode, new GraphImage().with(node.getString(HEAD)));
        }
        if (node.has("prop")) {
            Entity props = (Entity)node.getValue("prop");
            block0: for (int i = 0; i < props.size(); ++i) {
                Value attribute;
                Association assoc;
                Association assocOther;
                Object value = props.getValueByIndex(i);
                if (value instanceof Entity) {
                    assocOther = new Association(graphNode).with(Cardinality.ONE).with(AssociationTypes.EDGE);
                    Clazz newNode = this.parseJsonObject(root, (Entity)value);
                    assoc = new Association(newNode).with(Cardinality.ONE).with(props.getKeyByIndex(i)).with(AssociationTypes.ASSOCIATION);
                    assoc.with(assocOther);
                    GraphUtil.setAssociation(newNode, assoc);
                    GraphUtil.setAssociation(graphNode, assocOther);
                    continue;
                }
                if (value instanceof EntityList) {
                    EntityList array = (EntityList)value;
                    attribute = null;
                    for (int e = 0; e < array.size(); ++e) {
                        BaseItem entity = array.getChild(e);
                        if (entity instanceof Entity) {
                            assocOther = new Association(graphNode).with(Cardinality.ONE).with(AssociationTypes.EDGE);
                            Clazz newNode = this.parseJsonObject(root, (Entity)entity);
                            assoc = new Association(newNode).with(Cardinality.MANY).with(props.getKeyByIndex(i)).with(AssociationTypes.ASSOCIATION);
                            assoc.with(assocOther);
                            GraphUtil.setAssociation(newNode, assoc);
                            GraphUtil.setAssociation(graphNode, assocOther);
                            if (!isClassDiagram) continue;
                            continue block0;
                        }
                        if (attribute == null) {
                            String name = props.getKeyByIndex(i);
                            DataType type = DataType.create(value.getClass().getName());
                            attribute = new Attribute(name, type);
                            ((Attribute)attribute).withValue(((Object)entity).toString());
                            continue;
                        }
                        ((Attribute)attribute).withValue(attribute.getValue() + "," + ((Object)entity).toString());
                    }
                    continue;
                }
                String name = props.getKeyByIndex(i);
                AssociationSet associations = graphNode.getAssociations(new Condition[0]);
                for (Association childAssoc : associations) {
                    if (!name.equals(childAssoc.getName()) && !name.equals(childAssoc.getOther().getName())) continue;
                    name = null;
                    break;
                }
                if (name == null) continue;
                if (value != null) {
                    attribute = graphNode.createAttribute(name, DataType.create(value.getClass()));
                    if (isClassDiagram) continue;
                    ((Attribute)attribute).withValue(value.toString());
                    continue;
                }
                Attribute attribute2 = graphNode.createAttribute(name, null);
            }
        }
        return graphNode;
    }

    public Entity convertToJson(EntityList list, boolean removePackage) {
        return this.convertToJson("objectdiagram", list, removePackage);
    }

    public Entity convertToJson(GraphModel root, boolean removePackage, boolean removeParameterNames) {
        String type = "classdiagram";
        String style = null;
        GraphOptions options = null;
        if (root instanceof GraphList) {
            GraphList graphList = (GraphList)root;
            type = graphList.getType();
            style = graphList.getStyle();
            options = graphList.getOptions();
        }
        Entity jsonRoot = (Entity)this.factory.getNewList(true);
        jsonRoot.put(TYPE, type);
        String id = root.getName();
        if (id != null && id.length() > 0) {
            jsonRoot.put(ID, root.getName());
        }
        if (options != null) {
            jsonRoot.put(OPTIONS, options.getJson());
        }
        if (style != null) {
            jsonRoot.put(STYLE, style);
        }
        jsonRoot.put(NODES, this.parseEntities(type, root, removePackage, removeParameterNames));
        EntityList parseEdges = this.parseEdges(type, root.getAssociations(new Condition[0]), removePackage);
        if (parseEdges != null && parseEdges.sizeChildren() > 0) {
            jsonRoot.put(EDGES, parseEdges);
        }
        return jsonRoot;
    }

    public ClassModel convertFromJson(Entity model) {
        if (!model.has(NODES)) {
            return null;
        }
        EntityList nodes = (EntityList)model.getValue(NODES);
        ClassModel classModel = new ClassModel(model.getString("package"));
        for (int i = 0; i < nodes.size(); ++i) {
            EntityList attributes;
            BaseItem item = nodes.getChild(i);
            if (!(item instanceof Entity)) continue;
            Entity node = (Entity)item;
            Clazz clazz = node.has(LABEL) ? classModel.createClazz(node.getString(LABEL)) : classModel.createClazz(node.getString(ID));
            String type = node.getString(TYPE);
            if (type != null && type.length() > 0) {
                GraphUtil.setClazzType(clazz, type);
            }
            if ((attributes = (EntityList)node.getValue(ATTRIBUTES)) == null) continue;
            for (int a = 0; a < attributes.size(); ++a) {
                Entity json;
                BaseItem entity = attributes.getChild(a);
                if (entity instanceof String) {
                    String attribute = (String)((Object)entity);
                    int pos = attribute.indexOf(":");
                    if (pos <= 0) continue;
                    clazz.createAttribute(attribute.substring(0, pos), DataType.create(attribute.substring(pos + 1)));
                    continue;
                }
                if (!(entity instanceof Entity) || !(json = (Entity)entity).has(ID)) continue;
                Attribute attribute = clazz.createAttribute(json.getString(ID), DataType.create(json.getString(TYPE)));
                String string = json.getString(MODIFIERS);
                if (string == null || string.length() <= 0) continue;
                for (String modifier : string.split(" ")) {
                    if (modifier.length() <= 0) continue;
                    attribute.with(Modifier.create(modifier));
                }
            }
        }
        EntityList edges = (EntityList)model.getValue(EDGES);
        if (edges != null) {
            for (int e = 0; e < edges.size(); ++e) {
                BaseItem entity = edges.getChild(e);
                if (!(entity instanceof Entity)) continue;
                Entity edge = (Entity)entity;
                Entity source = (Entity)edge.getValue(SOURCE);
                Entity target = (Entity)edge.getValue(TARGET);
                if (!edge.getString(TYPE).equalsIgnoreCase("edge")) continue;
                Clazz fromClazz = GraphUtil.getByObject((GraphEntity)classModel, source.getString(ID), true);
                Clazz toClazz = GraphUtil.getByObject((GraphEntity)classModel, target.getString(ID), true);
                fromClazz.withBidirectional(toClazz, target.getString(PROPERTY), Cardinality.ONE, source.getString(PROPERTY), Cardinality.ONE);
            }
        }
        return classModel;
    }

    private EntityList parseEdges(String type, SimpleSet<Association> edges, boolean shortName) {
        EntityList result = (EntityList)this.factory.getNewList(false);
        ArrayList<String> ids = new ArrayList<String>();
        for (Association edge : edges) {
            SimpleSet<GraphEntity> edgeNodes = GraphUtil.getNodes(edge);
            for (GraphEntity source : edgeNodes) {
                SimpleSet<GraphEntity> edgeOtherNodes = GraphUtil.getNodes(edge.getOther());
                for (GraphEntity target : edgeOtherNodes) {
                    Entity child = this.parseEdge(type, source, target, edge, shortName, ids);
                    if (child == null) continue;
                    result.add(child);
                }
            }
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    private Entity parseEdge(String type, GraphEntity source, GraphEntity target, Association edge, boolean shortName, ArrayList<String> ids) {
        if (source instanceof Clazz && target instanceof Clazz) {
            return this.parseEdge(type, (Clazz)source, (Clazz)target, edge, shortName, ids);
        }
        if (source instanceof GraphPattern && target instanceof GraphPattern) {
            return this.parseEdge(type, (GraphPattern)source, (GraphPattern)target, edge, shortName, ids);
        }
        return null;
    }

    private Entity parseEdge(String type, Clazz source, Clazz target, Association edge, boolean shortName, ArrayList<String> ids) {
        Entity child = (Entity)this.factory.getNewList(true);
        child.put(TYPE, (Object)edge.getOther().getType());
        Entity sourceInfo = this.addInfo(edge, true);
        Entity targetInfo = this.addInfo(edge.getOther(), true);
        if (type.equals("objectdiagram")) {
            sourceInfo.put(ID, source.getId() + " : " + source.getName(shortName));
            targetInfo.put(ID, target.getId() + " : " + target.getName(shortName));
            child.put(SOURCE, sourceInfo);
            child.put(TARGET, targetInfo);
            return child;
        }
        String id = new CharacterBuffer().with(source.getName(false), ":", edge.getName(), "-", target.getName(false), ":", edge.getOther().getName()).toString();
        if (!ids.contains(id)) {
            GraphDiff diff = GraphUtil.getDifference(edge);
            if (diff != null && diff.getCount() > 0) {
                child.put(COUNTER, diff.getCount());
            }
            sourceInfo.put(ID, source.getName(shortName));
            targetInfo.put(ID, target.getName(shortName));
            child.put(SOURCE, sourceInfo);
            child.put(TARGET, targetInfo);
            ids.add(id);
            return child;
        }
        return null;
    }

    private Entity parseEdge(String type, GraphPattern source, GraphPattern target, Association edge, boolean shortName, ArrayList<String> ids) {
        Entity child = (Entity)this.factory.getNewList(true);
        child.put(TYPE, (Object)edge.getType());
        Entity sourceInfo = this.addInfo(edge, false);
        Entity targetInfo = this.addInfo(edge.getOther(), false);
        sourceInfo.put(ID, source.getId());
        targetInfo.put(ID, target.getId());
        child.put(SOURCE, sourceInfo);
        child.put(TARGET, targetInfo);
        GraphLabel info = edge.getInfo();
        if (info != null) {
            child.put(INFO, info.getName());
            child.put(STYLE, info.getStyle());
        }
        return child;
    }

    private Entity addInfo(Association edge, boolean cardinality) {
        Entity result = (Entity)this.factory.getNewList(true);
        result.put(PROPERTY, edge.getName());
        if (cardinality) {
            result.put(CARDINALITY, (Object)edge.getCardinality());
        }
        if (this.full) {
            result.put(CLAZZ, edge.getClazz().getName());
        }
        return result;
    }

    public EntityList parseEntities(String type, GraphEntity nodes, boolean shortName, boolean removeParameterNames) {
        EntityList result = (EntityList)this.factory.getNewList(false);
        ArrayList<String> ids = new ArrayList<String>();
        GraphSimpleSet children = GraphUtil.getChildren(nodes);
        for (GraphMember entity : children) {
            Entity item = this.parseEntity(type, entity, shortName, removeParameterNames);
            if (item == null) continue;
            if ("classdiagram".equals(type) && item.has(ID)) {
                String key = item.getString(ID);
                if (ids.contains(key)) continue;
                ids.add(key);
            }
            result.add(item);
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    public Entity parseEntity(String type, GraphMember entity, boolean shortName, boolean removeParameterNames) {
        if (type == null) {
            type = "objectdiagram";
            if (entity.getName() == null) {
                type = "classdiagram";
            }
        }
        Entity item = (Entity)this.factory.getNewList(true);
        if (entity instanceof Clazz) {
            Clazz clazz = (Clazz)entity;
            if (this.full) {
                item.put(MODIFIERS, clazz.getModifier());
            }
            item.put(TYPE, clazz.getType());
            if (type == "objectdiagram") {
                item.put(ID, clazz.getId() + " : " + clazz.getName(shortName));
            } else {
                item.put(ID, clazz.getName(shortName));
            }
        } else if (entity instanceof GraphPattern) {
            item.put(TYPE, PATTERN);
            String bounds = ((GraphPattern)entity).getBounds();
            if (bounds != null) {
                item.put(STYLE, bounds);
            }
            item.put(ID, entity.getName());
        } else {
            if (entity instanceof GraphList) {
                return this.convertToJson((GraphList)entity, shortName, false);
            }
            item.put(TYPE, NODE);
        }
        if (entity instanceof GraphEntity) {
            this.parseGraphEntity((GraphEntity)entity, item, type, shortName, removeParameterNames);
            return item;
        }
        if (entity instanceof GraphNode) {
            item.put(ID, entity.getName());
            return item;
        }
        return null;
    }

    private void parseGraphEntity(GraphEntity entity, Entity item, String type, boolean shortName, boolean removeParameterNames) {
        GraphDiff diff;
        EntityList items;
        GraphImage nodeHeader = this.getNodeHeader(entity);
        if (nodeHeader != null) {
            Entity header = (Entity)this.factory.getNewList(true);
            header.put(SRC, nodeHeader);
            item.put(HEAD, header);
        }
        if ((items = this.parseAttributes(type, entity, shortName)).size() > 0) {
            item.put(ATTRIBUTES, items);
        }
        if ((items = this.parseMethods(entity, shortName, removeParameterNames)).size() > 0) {
            item.put(METHODS, items);
        }
        if ((diff = GraphUtil.getDifference(entity)) != null && diff.getCount() > 0) {
            item.put(COUNTER, diff.getCount());
        }
    }

    public GraphImage getNodeHeader(GraphEntity entity) {
        GraphSimpleSet children = GraphUtil.getChildren(entity);
        for (GraphMember member : children) {
            if (!(member instanceof GraphImage)) continue;
            return (GraphImage)member;
        }
        return null;
    }

    private EntityList parseAttributes(String type, GraphEntity list, boolean shortName) {
        EntityList result = (EntityList)this.factory.getNewList(false);
        String splitter = "";
        if (type.equals("objectdiagram")) {
            splitter = "=";
        } else if (type.equals("classdiagram")) {
            splitter = ":";
        }
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            Attribute attribute;
            String name;
            if (!(item instanceof Attribute) || (name = (attribute = (Attribute)item).getName()) == null || name.length() < 1) continue;
            if (this.full) {
                Entity json = (Entity)this.factory.getNewList(true);
                json.put(ID, name);
                json.put(MODIFIERS, attribute.getModifier());
                json.put(TYPE, attribute.getType().getName(true));
                result.add(json);
                continue;
            }
            result.add(attribute.getName() + splitter + attribute.getValue(type, shortName));
        }
        return result;
    }

    private EntityList parseMethods(GraphEntity list, boolean shortName, boolean removeParameterNames) {
        EntityList result = (EntityList)this.factory.getNewList(false);
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            if (!(item instanceof Method)) continue;
            Method method = (Method)item;
            if (this.full) {
                ParameterSet parameters;
                Entity json = (Entity)this.factory.getNewList(true);
                json.put(ID, method.getName());
                json.put(TYPE, method.getReturnType().getName(true));
                json.put(MODIFIERS, method.getModifier());
                if (method.getBody() != null && method.getBody().length() > 0) {
                    json.put(BODY, method.getBody());
                }
                if ((parameters = method.getParameters(new Condition[0])).size() > 0) {
                    EntityList paramList = (EntityList)this.factory.getNewList(false);
                    for (Parameter parameter : parameters) {
                        Entity param = (Entity)this.factory.getNewList(true);
                        param.put(ID, parameter.getName());
                        param.put(TYPE, parameter.getType().getName(true));
                        paramList.add(param);
                    }
                    json.put(PARAMETER, paramList);
                }
                result.add(json);
                continue;
            }
            result.add(method.getName(false, removeParameterNames));
        }
        return result;
    }

    @Override
    public String encode(BaseItem entity) {
        if (entity instanceof GraphModel) {
            return this.convertToJson((GraphModel)entity, false, false).toString();
        }
        return null;
    }

    public static Entity convertModel(GraphModel model) {
        GraphConverter converter = new GraphConverter();
        return converter.convertToJson(model, false, true);
    }

    public GraphConverter withFull(boolean value) {
        this.full = value;
        return this;
    }
}

