/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.converter.ByteConverterString;
import de.uniks.networkparser.interfaces.Converter;
import java.nio.charset.Charset;

public class ByteBuffer
extends BufferedBuffer {
    protected byte[] buffer;
    private int bits = 0;
    private int nextBitMask = 256;

    @Override
    public char charAt(int index) {
        if (index < 0 || this.buffer == null || index >= this.buffer.length) {
            return '\u0000';
        }
        return (char)this.buffer[index];
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0 || this.buffer == null || index >= this.buffer.length) {
            return 0;
        }
        return this.buffer[index];
    }

    @Override
    public CharacterBuffer subSequence(int start, int end) {
        int len = end - start;
        byte[] sub = new byte[len];
        if (start < this.buffer.length && len <= this.buffer.length) {
            for (int i = 0; i < len; ++i) {
                sub[i] = this.buffer[start + i];
            }
        }
        return new CharacterBuffer().with(sub);
    }

    public ByteBuffer withBufferLength(int length) {
        super.withLength(length);
        this.buffer = new byte[length];
        return this;
    }

    @Override
    public char getChar() {
        byte no = this.getByte();
        if (no >= 0) {
            return (char)no;
        }
        char result = (char)(no << 8 + (char)this.getByte());
        return result;
    }

    @Override
    public byte getByte() {
        if (this.buffer == null || this.position >= this.buffer.length - 1) {
            return 0;
        }
        return this.buffer[++this.position];
    }

    public byte[] getBytes(Object ... parameter) {
        if (this.buffer == null || this.position >= this.buffer.length - 1) {
            return new byte[0];
        }
        int len = this.length;
        byte[] result = null;
        if (parameter != null && parameter.length > 0) {
            if (parameter[0] instanceof Integer) {
                len = (Integer)parameter[0];
            } else if (parameter[0] instanceof Byte[] || parameter[0] instanceof byte[]) {
                result = (byte[])parameter[0];
                len = result.length;
            }
        }
        if (result == null) {
            result = new byte[len];
        }
        for (int i = 0; i < len; ++i) {
            result[i] = this.buffer[++this.position];
        }
        return result;
    }

    public byte[] getValue(int start, int len) {
        this.withPosition(start);
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getByte();
        }
        return array;
    }

    public byte[] array() {
        return this.buffer;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return true;
        }
        for (Object item : values) {
            this.insert(item, true);
        }
        return true;
    }

    public boolean insert(Object item, boolean bufferAdEnd) {
        if (item instanceof Byte) {
            return this.addBytes(item, 1, bufferAdEnd);
        }
        if (item instanceof Character) {
            return this.addBytes((Character)item, 1, bufferAdEnd);
        }
        if (item instanceof String) {
            String str = (String)item;
            byte[] array = str.getBytes();
            return this.addBytes(array, array.length, bufferAdEnd);
        }
        if (item instanceof CharSequence) {
            CharSequence str = (CharSequence)item;
            this.resize(str.length(), bufferAdEnd);
            for (int i = 0; i < str.length(); ++i) {
                this.addBytes(Character.valueOf(str.charAt(i)), 1, bufferAdEnd);
            }
            return true;
        }
        if (item instanceof byte[]) {
            byte[] array = (byte[])item;
            return this.addBytes(array, array.length, bufferAdEnd);
        }
        if (item instanceof Byte[]) {
            Byte[] array = (Byte[])item;
            return this.addBytes(array, array.length, bufferAdEnd);
        }
        if (item instanceof Integer) {
            return this.addBytes(item, 4, bufferAdEnd);
        }
        if (item instanceof Short) {
            return this.addBytes(item, 2, bufferAdEnd);
        }
        if (item instanceof Long) {
            return this.addBytes(item, 8, bufferAdEnd);
        }
        if (item instanceof Boolean) {
            return this.addBytes(item, 1, bufferAdEnd);
        }
        return false;
    }

    private boolean resize(int len, boolean bufferAtEnd) {
        int bufferLen = 0;
        if (this.buffer != null) {
            bufferLen = this.buffer.length;
        }
        if (this.position < 0) {
            int newSize = bufferAtEnd ? this.length + len + (this.length + len) / 2 + 5 : this.length + len;
            byte[] oldBuffer = this.buffer;
            this.buffer = new byte[newSize];
            int oldSize = 0;
            if (oldBuffer != null) {
                oldSize = oldBuffer.length;
                System.arraycopy(oldBuffer, oldBuffer.length - this.length, this.buffer, newSize - this.length, this.length);
            }
            this.position += newSize - oldSize;
            return true;
        }
        if (this.position + len > bufferLen) {
            if (bufferLen > 0) {
                int newSize = bufferAtEnd ? this.length + len + (this.length + len) / 2 + 5 : this.length + len;
                byte[] oldBuffer = this.buffer;
                this.buffer = new byte[newSize];
                System.arraycopy(oldBuffer, 0, this.buffer, 0, this.position);
            } else {
                this.buffer = new byte[len];
            }
            return true;
        }
        return false;
    }

    public boolean addBytes(Object value, int len, boolean bufferAtEnd) {
        boolean addEnd = false;
        if (this.position == this.length) {
            addEnd = true;
        }
        this.resize(len, bufferAtEnd);
        if (value instanceof Byte) {
            this.buffer[this.position] = (Byte)value;
        } else if (value instanceof byte[]) {
            byte[] source = (byte[])value;
            if (this.buffer != null && this.buffer.length >= this.position + len) {
                for (int i = 0; i < len; ++i) {
                    this.buffer[this.position + i] = source[i];
                }
            }
        } else if (value instanceof Byte[]) {
            Byte[] source = (Byte[])value;
            if (this.buffer != null && this.buffer.length >= this.position + len) {
                for (int i = 0; i < len; ++i) {
                    this.buffer[this.position + i] = source[i];
                }
            }
        } else if (value instanceof Character) {
            char charItem = ((Character)value).charValue();
            if (len == 1) {
                this.buffer[this.position] = (byte)charItem;
            } else {
                this.buffer[this.position] = (byte)(charItem >>> 8);
                this.buffer[this.position + 1] = (byte)charItem;
            }
        } else if (value instanceof Short) {
            short item = (Short)value;
            this.buffer[this.position] = (byte)(item >>> 8);
            this.buffer[this.position + 1] = (byte)item;
        } else if (value instanceof Integer) {
            Integer item = (Integer)value;
            this.buffer[this.position] = (byte)(item >>> 24);
            this.buffer[this.position + 1] = (byte)(item >>> 16);
            this.buffer[this.position + 2] = (byte)(item >>> 8);
            this.buffer[this.position + 3] = (byte)(item & 0xFF);
        } else if (value instanceof Long) {
            Long item = (Long)value;
            this.buffer[this.position] = (byte)(item >>> 56);
            this.buffer[this.position + 1] = (byte)(item >>> 48);
            this.buffer[this.position + 2] = (byte)(item >>> 40);
            this.buffer[this.position + 3] = (byte)(item >>> 32);
            this.buffer[this.position + 4] = (byte)(item >>> 24);
            this.buffer[this.position + 5] = (byte)(item >>> 16);
            this.buffer[this.position + 6] = (byte)(item >>> 8);
            this.buffer[this.position + 7] = (byte)(item & 0xFFL);
        } else if (value instanceof Boolean) {
            Boolean item = (Boolean)value;
            this.buffer[this.position] = item != false ? (byte)1 : 0;
        }
        this.length += len;
        if (addEnd) {
            this.position = this.length;
        }
        return true;
    }

    public boolean put(byte value) {
        if (this.buffer != null && this.position + 1 <= this.buffer.length) {
            this.buffer[this.position++] = value;
            return true;
        }
        return false;
    }

    public boolean put(short value) {
        if (this.buffer != null && this.position + 2 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
            return true;
        }
        return false;
    }

    public boolean put(int value) {
        if (this.buffer != null && this.position + 4 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
            return true;
        }
        return false;
    }

    public boolean put(long value) {
        if (this.buffer != null && this.position + 8 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 56);
            this.buffer[this.position++] = (byte)(value >>> 48);
            this.buffer[this.position++] = (byte)(value >>> 40);
            this.buffer[this.position++] = (byte)(value >>> 32);
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
            return true;
        }
        return false;
    }

    public boolean put(char value) {
        if (this.buffer != null && this.position + 2 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
            return true;
        }
        return false;
    }

    public boolean put(float value) {
        int bits = Float.floatToIntBits(value);
        if (this.buffer != null && this.position + 4 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(bits & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFF);
            return true;
        }
        return false;
    }

    public boolean put(double value) {
        long bits = Double.doubleToLongBits(value);
        if (this.buffer != null && this.position + 8 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(bits >> 56 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 48 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 40 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 32 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 0 & 0xFFL);
            return true;
        }
        return false;
    }

    public boolean put(byte[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this.put(value[i]);
            }
            return true;
        }
        return false;
    }

    public void put(byte[] value, int offset, int length) {
        if (value == null || offset < 0 || offset > value.length) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.put(value[offset + i]);
        }
    }

    public ByteBuffer flip(boolean preFirst) {
        if (preFirst) {
            this.position = -1;
            return this;
        }
        this.position = 0;
        return this;
    }

    public ByteBuffer getNewBuffer(int capacity) {
        return new ByteBuffer().withBufferLength(capacity);
    }

    public static ByteBuffer allocate(int len) {
        ByteBuffer bytesBuffer = new ByteBuffer();
        bytesBuffer.withBufferLength(len);
        return bytesBuffer;
    }

    public ByteBuffer getNewBuffer(byte[] array) {
        return new ByteBuffer().with(array);
    }

    @Override
    public ByteBuffer with(CharSequence ... string) {
        if (string != null && string.length > 0 && string[0] instanceof String) {
            this.buffer = ((String)string[0]).getBytes(Charset.forName("utf-8"));
            this.position = 0;
            this.length = this.buffer.length;
        }
        return this;
    }

    public ByteBuffer with(byte[] array) {
        this.buffer = array;
        this.position = 0;
        this.length = array.length;
        return this;
    }

    public ByteBuffer with(byte value) {
        if (this.buffer == null) {
            this.buffer = new byte[]{value};
            this.length = 1;
            this.position = 0;
        } else if (this.length < this.buffer.length) {
            this.buffer[this.length++] = value;
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toString(new ByteConverterString());
    }

    @Override
    public ByteBuffer getNewList(boolean keyValue) {
        return new ByteBuffer();
    }

    @Override
    public int size() {
        return this.length();
    }

    public String string() {
        return new String(this.buffer);
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        if (converter instanceof ByteConverter) {
            return ((ByteConverter)converter).toString(this.toBytes(new boolean[0]));
        }
        return String.valueOf(this.buffer);
    }

    public ByteBuffer with(byte[] array, int len) {
        this.position = 0;
        if (len < 0 || len > array.length) {
            len = array.length;
        }
        if (this.buffer == null) {
            this.buffer = array;
            this.length = len;
        } else {
            byte[] oldBuffer = this.buffer;
            this.buffer = new byte[this.length * 2 + len];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, this.length);
            System.arraycopy(array, 0, this.buffer, this.length, len);
            this.length += len;
        }
        return this;
    }

    @Override
    public ByteBuffer with(char[] values, int start, int len) {
        if (values == null || start + this.length > values.length) {
            return this;
        }
        if (this.length < 0) {
            this.length = this.buffer.length;
        }
        int newLen = this.length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            byte[] oldValue = this.buffer;
            this.buffer = new byte[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        System.arraycopy(values, start, this.buffer, this.length, this.length);
        this.length = newLen;
        return this;
    }

    public boolean getBit() {
        if (this.nextBitMask > 128) {
            this.bits = this.getByte();
            this.nextBitMask = 1;
        }
        boolean result = (this.bits & this.nextBitMask) != 0;
        this.nextBitMask <<= 1;
        return result;
    }

    public String getShortstr() {
        int contentLength = this.getByte() & 0xFF;
        byte[] b = this.getBytes(new Object[]{new byte[contentLength]});
        return new String(b);
    }

    public boolean set(int pos, byte value) {
        if (pos >= 0 && pos <= this.length) {
            this.buffer[pos] = value;
            return true;
        }
        return false;
    }
}

