/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.SimpleGrammar;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonObject;

public class EMFJsonGrammar
extends SimpleGrammar {
    public static final String SRC = "@src";
    public static final String PROP = "@prop";
    public static final String NV = "@nv";

    @Override
    public BaseItem getProperties(Entity item, MapEntity map, boolean isId) {
        JsonObject props = new JsonObject();
        if (item != null && item.has(PROP)) {
            String key = item.getString(PROP);
            String value = item.getString(NV);
            SendableEntityCreator creator = this.getCreator("read", null, map, value);
            if (creator != null) {
                props.put(key, new JsonObject().withValue(SRC, value));
            } else {
                props.put(key, value);
            }
            return props;
        }
        return item;
    }

    @Override
    public SendableEntityCreator getCreator(String type, Object item, MapEntity entity, String className) {
        if ("read".equals(type) && item instanceof Entity) {
            SendableEntityCreator result = this.getCreator(type, null, entity, ((Entity)item).getString(SRC));
            if (result != null) {
                return result;
            }
            return super.getCreator(type, item, entity, className);
        }
        if (className == null) {
            return null;
        }
        int pos = className.indexOf("@");
        String clazz = null;
        if (pos > 0) {
            clazz = className.substring(0, pos);
        } else {
            pos = className.lastIndexOf(".");
            if (pos > 0) {
                clazz = className.substring(0, pos);
            }
        }
        if (clazz != null) {
            IdMap map = entity.getMap();
            for (SendableEntityCreator creator : map) {
                Object sendableInstance = creator.getSendableInstance(true);
                String refClazzName = sendableInstance.getClass().getName();
                if (!refClazzName.endsWith("." + clazz)) continue;
                return creator;
            }
        }
        return super.getCreator(type, item, entity, className);
    }

    @Override
    public String getId(Object obj, IdMap map) {
        if (obj == null) {
            return null;
        }
        String name = obj.getClass().getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            return name.substring(pos + 1) + "." + map.createId(obj, true);
        }
        return name + "." + map.createId(obj, true);
    }

    @Override
    public String getValue(Entity item, String property) {
        if (item == null) {
            return null;
        }
        if ("id".equals(property)) {
            return item.getString(SRC);
        }
        return item.getString(property);
    }

    @Override
    public boolean hasValue(Entity json, String property) {
        if (property == null) {
            return false;
        }
        if (property.equals("id")) {
            property = SRC;
        }
        return super.hasValue(json, property);
    }

    @Override
    public Entity writeBasicValue(Entity entity, String className, String id, String type, IdMap map) {
        if (id != null && entity != null) {
            entity.put(SRC, id);
        }
        return entity;
    }
}

