/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.graph.Pattern;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleIterator;

public class PatternCondition
implements ObjectCondition {
    private String link;
    private Object value;

    public PatternCondition withLinkName(String value) {
        this.link = value;
        return this;
    }

    public PatternCondition withValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean update(Object value) {
        SimpleIterator<Object> i;
        SendableEntityCreator creator;
        Object match2;
        if (!(value instanceof Pattern)) {
            return false;
        }
        Pattern pattern = (Pattern)value;
        IdMap map = pattern.getMap();
        if (map == null) {
            return false;
        }
        if (pattern.getCandidates() == null && pattern.getParent() != null && (match2 = pattern.getParent().getMatch()) != null && (creator = map.getCreatorClass(match2)) != null) {
            Object newValue = creator.getValue(match2, this.getLinkName());
            pattern.withCandidates(newValue);
        }
        if ((i = pattern.getIterator()) == null) {
            return false;
        }
        if (pattern.getMatch() != null && pattern.getMatch() != i.current() && (this.value == null || this.value.equals(pattern.getMatch()))) {
            return true;
        }
        while (i.hasNext()) {
            Object candidate = i.next();
            if (candidate == null) {
                return false;
            }
            if (this.value != null && !this.value.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    public static final PatternCondition create(String linkName) {
        PatternCondition pattern = new PatternCondition();
        pattern.withLinkName(linkName);
        return pattern;
    }

    public String getLinkName() {
        return this.link;
    }

    public Object getValue() {
        return this.value;
    }
}

