/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.logic.PatternCondition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Pattern
implements Iterator<Object>,
Iterable<Object> {
    public static final String MODIFIER_SEARCH = "search";
    public static final String MODIFIER_CHANGE = "change";
    public static final String MODIFIER_ADD = "add";
    public static final String MODIFIER_REMOVE = "remove";
    private Object match;
    private String modifier = "search";
    private SimpleSet<Pattern> children;
    private Pattern parent;
    private SimpleSet<Object> candidates = null;
    private ObjectCondition condition;
    private IdMap map;
    private SimpleIterator<Object> iterator;
    private SimpleSet<Pattern> chain;

    public Pattern getRoot() {
        if (this.getParent() != null) {
            return this.getParent().getRoot();
        }
        return this;
    }

    public IdMap getMap() {
        return this.getRoot().map;
    }

    public Pattern(IdMap map, Object match) {
        this();
        this.match = match;
        this.map = map;
        if (this.candidates == null) {
            this.candidates = new SimpleSet();
        }
        this.candidates.add(match);
    }

    public Pattern() {
        this.chain = new SimpleSet();
        this.chain.add(this);
    }

    public Pattern(Pattern parent, ObjectCondition condition) {
        if (parent != null) {
            this.parent = parent;
            parent.addToChain(this);
        }
        this.condition = condition;
    }

    public Pattern has(String property) {
        return this.has(PatternCondition.create(property));
    }

    public Pattern has(ObjectCondition condition) {
        Pattern root = this.getRoot();
        if (root != this && this.condition == null) {
            this.condition = condition;
            return this;
        }
        Pattern subPattern = new Pattern(this, condition);
        if (this.children == null) {
            this.children = new SimpleSet();
        }
        this.children.add(subPattern);
        if (MODIFIER_SEARCH.equals(this.modifier)) {
            subPattern.find();
        }
        return subPattern;
    }

    private void addToChain(Pattern value) {
        this.getChain().add(value);
    }

    public static <T> SimpleList<T> createListOfType(Class<T> type) {
        return new SimpleList();
    }

    public <ST extends List<Object>> ST allMatches() {
        if (this.match == null) {
            this.find();
        }
        if (this.match == null) {
            return (ST)new SimpleList();
        }
        SimpleList<?> result = Pattern.createListOfType(this.match.getClass());
        while (this.find()) {
            result.add(new Object[]{this.match});
        }
        return (ST)result;
    }

    public Object getMatch() {
        return this.match;
    }

    public <ST> ST getMatch(Class<ST> clazz) {
        return (ST)this.match;
    }

    public boolean find() {
        SimpleSet<Pattern> chain = this.getChain();
        Pattern last = (Pattern)chain.last();
        if (last == this) {
            return this.finding(true);
        }
        return last.finding(true);
    }

    public SimpleSet<Pattern> getChain() {
        return this.getRoot().chain;
    }

    @Override
    public boolean hasNext() {
        SimpleSet<Pattern> chain = this.getChain();
        Pattern last = (Pattern)chain.last();
        if (last == this) {
            return this.finding(false);
        }
        return last.finding(false);
    }

    private boolean finding(boolean save) {
        if (this.condition == null || !this.condition.update(this)) {
            if (this.parent == null) {
                return false;
            }
            boolean finding = this.parent.finding(save);
            if (save) {
                this.candidates = null;
                this.match = null;
                this.iterator = null;
                if (this.condition != null) {
                    this.condition.update(this);
                }
            }
            if (!finding) {
                return this.match != null;
            }
            if (this.children != null) {
                Pattern child;
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext() && (finding = (child = (Pattern)iterator.next()).find())) {
                }
                if (!finding) {
                    return false;
                }
            }
        }
        if (save) {
            this.match = this.iterator.current();
            this.applyPattern();
        }
        return this.match != null;
    }

    @Override
    public Object next() {
        if (this.find()) {
            return this.getMatch();
        }
        return null;
    }

    @Override
    public Iterator<Object> iterator() {
        return this;
    }

    public SimpleSet<Object> getCandidates() {
        return this.candidates;
    }

    public Pattern getParent() {
        return this.parent;
    }

    public Pattern withCandidates(Object newValue) {
        if (this.candidates == null) {
            this.candidates = new SimpleSet();
            this.iterator = (SimpleIterator)this.candidates.iterator();
            this.iterator.withCheckPointer(false);
        }
        if (newValue instanceof Collection) {
            this.candidates.withList((Collection)newValue);
        } else {
            this.candidates.with(newValue);
        }
        return this;
    }

    public SimpleIterator<Object> getIterator() {
        return this.iterator;
    }

    public Pattern withMatch(Object candidate) {
        this.match = candidate;
        return this;
    }

    public boolean applyPattern() {
        if (MODIFIER_SEARCH.equals(this.modifier)) {
            return true;
        }
        SimpleSet<Pattern> chain = this.getChain();
        for (int i = 0; i < chain.size(); ++i) {
            Pattern pattern = (Pattern)chain.get(i);
            pattern.appling();
        }
        return true;
    }

    public boolean appling() {
        if (!(this.condition instanceof PatternCondition)) {
            return false;
        }
        PatternCondition patternCondition = (PatternCondition)this.condition;
        if (MODIFIER_ADD.equals(this.modifier)) {
            if (this.match == null) {
                return false;
            }
            Object value = patternCondition.getValue();
            String clazzName = "" + value;
            SendableEntityCreator creatorClass = this.getMap().getCreator(clazzName, true);
            if (creatorClass != null) {
                this.match = creatorClass.getSendableInstance(false);
                if (this.parent != null) {
                    this.parent.setValue(patternCondition.getLinkName(), this.match);
                }
            }
            return true;
        }
        if (MODIFIER_CHANGE.equals(this.modifier)) {
            if (this.parent != null) {
                this.parent.setValue(patternCondition.getLinkName(), patternCondition.getValue());
            }
            return true;
        }
        if (MODIFIER_REMOVE.equals(this.modifier)) {
            SendableEntityCreator creatorClass = this.getMap().getCreatorClass(this.match);
            if (creatorClass instanceof SendableEntityCreator) {
                creatorClass.setValue(this.match, null, null, "REMOVE_YOU");
            }
            return true;
        }
        return false;
    }

    public boolean setValue(String property, Object value) {
        if (this.match != null) {
            SendableEntityCreator creatorClass = this.getMap().getCreatorClass(this.match);
            creatorClass.setValue(this.match, property, value, "new");
        }
        return false;
    }
}

