/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.list.SimpleSet;

public class DataTypeSet
extends DataType {
    private DataType generic;

    DataTypeSet() {
        super(SimpleSet.class.getName());
        this.value.withExternal(true);
    }

    private DataTypeSet withGeneric(DataType value) {
        this.generic = value;
        return this;
    }

    public DataType getGeneric() {
        return this.generic;
    }

    @Override
    public String getName(boolean shortName) {
        if (this.value == null) {
            return null;
        }
        return this.value.getName(shortName) + "<" + this.generic.getInternName(shortName, false) + ">";
    }

    @Override
    protected String getInternName(boolean shortName, boolean primitivAllow) {
        if (this.value == null) {
            return null;
        }
        return this.value.getName(shortName) + "<" + this.generic.getInternName(shortName, primitivAllow) + ">";
    }

    public static DataTypeSet create(Object genericType) {
        return new DataTypeSet().withGeneric(DataType.create(genericType));
    }

    public static DataTypeSet create(Clazz container, Object genericType) {
        DataTypeSet list = new DataTypeSet().withGeneric(DataType.create(genericType));
        if (container != null) {
            list.value = container;
        }
        return list;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataTypeSet)) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        if (this.generic == null) {
            return ((DataTypeSet)obj).getGeneric() == null;
        }
        return ((DataTypeSet)obj).getGeneric().equals(this.generic);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public DataTypeSet withExternal(boolean external) {
        super.withExternal(external);
        return this;
    }
}

