/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.generic.ReflectionBlackBoxTester;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.ext.story.JacocoColumn;
import de.uniks.networkparser.ext.story.Story;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.Feature;
import de.uniks.networkparser.graph.FeatureProperty;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;
import java.io.File;
import java.util.Collection;
import java.util.List;

public class StoryStepJUnit
implements ObjectCondition {
    private static final String BLACKBOXFILE = "backbox.txt";
    private ReflectionBlackBoxTester tester = new ReflectionBlackBoxTester();
    private NetworkParserLog logger = new NetworkParserLog().withListener(this);
    private String packageName = null;
    private String path = "lib/jacocoagent.jar";
    private SimpleSet<String> testClasses;
    private SimpleKeyValueList<String, JacocoColumn> columns = new SimpleKeyValueList();
    private SimpleList<FeatureProperty> groups = new SimpleList();
    int tabwidth = 4;
    private JacocoColumn column = JacocoColumn.create();

    public StoryStepJUnit() {
        this.addColumn("BBT", this.column);
    }

    public FeatureProperty addGroup(String label) {
        FeatureProperty feature = new FeatureProperty(Feature.JUNIT);
        feature.withStringValue(label);
        this.groups.add(feature);
        return feature;
    }

    public boolean writeHTML(String executeData, String outputFile, String label) {
        Object loader = ReflectionLoader.newInstance("org.jacoco.core.tools.ExecFileLoader", new Object[0]);
        if (loader == null) {
            return false;
        }
        ReflectionLoader.call(loader, "load", File.class, new File(executeData));
        if (this.groups.size() < 1) {
            this.addGroup(label);
        }
        File htmlFile = new File(outputFile);
        Object formatter = this.createFormater();
        Object output = ReflectionLoader.newInstance("org.jacoco.report.FileMultiReportOutput", File.class, htmlFile);
        Object visitor = ReflectionLoader.callStr(formatter, "createVisitor", "org.jacoco.report.IMultiReportOutput", output);
        Object info = ReflectionLoader.callChain(loader, "getSessionInfoStore", "getInfos");
        Object content = ReflectionLoader.callChain(loader, "getExecutionDataStore", "getContents");
        ReflectionLoader.call(visitor, "visitInfo", List.class, info, Collection.class, content);
        for (FeatureProperty group : this.groups) {
            Object bundle = this.writeReports(loader, formatter, htmlFile, group);
            ReflectionLoader.callStr(visitor, "visitBundle", "org.jacoco.core.analysis.IBundleCoverage", bundle, "org.jacoco.report.ISourceFileLocator", this.getSourceLocator());
        }
        ReflectionLoader.call(visitor, "visitEnd", new Object[0]);
        return true;
    }

    private Object createFormater() {
        Object formater = ReflectionLoader.newInstance("org.jacoco.report.html.HTMLFormatter", new Object[0]);
        Object table = ReflectionLoader.call(formater, "getTable", new Object[0]);
        for (int i = 0; i < this.columns.size(); ++i) {
            ReflectionLoader.callStr(table, "add", String.class, this.columns.getKeyByIndex(i), String.class, "ctr2", "org.jacoco.report.internal.html.table.IColumnRenderer", this.columns.getValueByIndex(i).getProxy(), Boolean.TYPE, false);
        }
        return formater;
    }

    private Object writeReports(Object loader, Object formatter, File outputFile, FeatureProperty group) {
        Object builder = ReflectionLoader.newInstance("org.jacoco.core.analysis.CoverageBuilder", new Object[0]);
        if (builder == null) {
            return null;
        }
        Object data = ReflectionLoader.call(loader, "getExecutionDataStore", new Object[0]);
        Object analyzer = ReflectionLoader.newInstanceStr("org.jacoco.core.analysis.Analyzer", "org.jacoco.core.data.ExecutionDataStore", data, "org.jacoco.core.analysis.ICoverageVisitor", builder);
        String rootBin = "bin/";
        for (Clazz clazz : group.getClazzes()) {
            CharacterBuffer buffer = new CharacterBuffer().with(rootBin, clazz.getName());
            buffer.replace('*', '\u0000');
            buffer.replace('.', '/');
            File classfiles = new File(buffer.toString());
            try {
                ReflectionLoader.call(analyzer, "analyzeAll", File.class, classfiles);
            }
            catch (Exception e) {
                System.out.println("ERROR");
            }
        }
        return ReflectionLoader.call(builder, "getBundle", group.getStringValue());
    }

    private Object getSourceLocator() {
        SimpleList sourcefiles = new SimpleList();
        File file = new File("src/main/java");
        if (file.exists()) {
            sourcefiles.add(file);
        } else {
            sourcefiles.add(new File("src"));
        }
        String encoding = System.getProperty("file.encoding");
        Object multi = ReflectionLoader.newInstance("org.jacoco.report.MultiSourceFileLocator", Integer.TYPE, this.tabwidth);
        for (File f : sourcefiles) {
            Object sourceFile = ReflectionLoader.newInstance("org.jacoco.report.DirectorySourceFileLocator", File.class, f, String.class, encoding, Integer.TYPE, this.tabwidth);
            ReflectionLoader.callStr(multi, "add", "org.jacoco.report.ISourceFileLocator", sourceFile);
        }
        return multi;
    }

    public boolean executeBlackBoxTest(String path) {
        this.path = path;
        try {
            this.tester.test(this.packageName, this.logger);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean executeBlackBoxEvent(SimpleEvent event) {
        FileBuffer.writeFile(this.path + BLACKBOXFILE, event.toString() + "\r\n", FileBuffer.APPEND);
        return true;
    }

    @Override
    public boolean update(Object value) {
        int end;
        String search;
        int pos;
        if (!(value instanceof SimpleEvent)) {
            return false;
        }
        SimpleEvent evt = (SimpleEvent)value;
        if ("INFO".equalsIgnoreCase(evt.getType()) || "WARNING".equalsIgnoreCase(evt.getType()) || "DEBUG".equalsIgnoreCase(evt.getType()) || "ERROR".equalsIgnoreCase(evt.getType())) {
            return this.executeBlackBoxEvent(evt);
        }
        if (this.packageName == null) {
            return false;
        }
        String path = "doc/";
        String label = "JUnit - Jacoco";
        if (evt.getSource() instanceof Story) {
            Story story = (Story)evt.getSource();
            path = story.getPath();
            if (story.getLabel() != null) {
                label = story.getLabel();
            }
        }
        if (!new File(this.path).exists()) {
            return false;
        }
        SimpleController controller = SimpleController.create();
        String[] list = null;
        if (this.testClasses != null) {
            list = this.testClasses.toArray(new String[this.testClasses.size()]);
        }
        controller.withAgent(this.path, this.packageName, list);
        controller.withErrorPath(path);
        controller.start();
        this.writeHTML(path + "jacoco.exec", path + "jacoco", label);
        CharacterBuffer indexFile = FileBuffer.readFile(path + "jacoco/index.html");
        if (indexFile != null && (pos = indexFile.indexOf(search = "<tfoot><tr><td>Total</td><td class=\"bar\">")) > 0 && (end = indexFile.indexOf("<", pos += search.length())) > 0) {
            String name = indexFile.substring(pos, end);
            HTMLEntity output = (HTMLEntity)evt.getNewValue();
            XMLEntity div = output.createTag("div", output.getBody());
            XMLEntity p = output.createTag("p", div);
            p.withCloseTag();
            int level = 0;
            try {
                String[] split = name.split("of");
                if (split.length == 2) {
                    Integer no = Integer.valueOf(split[0].trim());
                    Integer sum = Integer.valueOf(split[1].trim());
                    int proz = no / sum * 100;
                    if (proz < 50) {
                        level = 2;
                    } else if (proz < 80) {
                        level = 1;
                    }
                }
            }
            catch (Exception split) {
                // empty catch block
            }
            XMLEntity textnode = output.createTag("div", div);
            textnode.add("class", "notify-text");
            if (level == 0) {
                div.add("class", "notify notify-red");
                p.add("class", "symbol icon-error");
            } else if (level == 1) {
                div.add("class", "notify notify-yellow");
                p.add("class", "symbol icon-info");
            } else {
                div.add("class", "notify notify-green");
                p.add("class", "symbol icon-tick");
            }
            textnode.withValueItem("MISSED INDUDUCTION: " + name);
        }
        return true;
    }

    public NetworkParserLog getLogger() {
        return this.logger;
    }

    public StoryStepJUnit withLogger(NetworkParserLog logger) {
        this.logger = logger;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public StoryStepJUnit withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public StoryStepJUnit withTestClasses(String ... classNames) {
        if (classNames == null) {
            return this;
        }
        if (this.testClasses == null) {
            this.testClasses = new SimpleSet();
        }
        for (String item : classNames) {
            this.testClasses.add(item);
        }
        return this;
    }

    public StoryStepJUnit withAgentPath(String path) {
        this.path = path;
        return this;
    }

    public StoryStepJUnit addColumn(String name, JacocoColumn callback) {
        this.columns.add(name, callback);
        return this;
    }

    public void addValueToList(String key, int no) {
        this.column.addValueToList(key, no);
    }
}

