/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.ReceivingTimerTask;
import de.uniks.networkparser.ext.petaf.Server_TCP;
import de.uniks.networkparser.ext.petaf.messages.ConnectMessage;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.xml.HTMLEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeProxyTCP
extends NodeProxy {
    public static int BUFFER = 102400;
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_PORT = "port";
    public static final String BODY_PLAIN = "plain";
    public static final String HEADER_PLAIN = "plainHeader";
    public static final String BODY_JSON = "json";
    protected int port;
    protected String url;
    protected int timeOut;
    public static final String LOCALHOST = "127.0.0.1";
    protected Server_TCP serverSocket;
    protected boolean allowAnswer = false;
    private ObjectCondition listener;

    public NodeProxyTCP() {
        this.property.addAll(PROPERTY_URL, PROPERTY_PORT);
        this.propertyUpdate.addAll(PROPERTY_URL, PROPERTY_PORT);
        this.propertyInfo.addAll(PROPERTY_URL, PROPERTY_PORT);
    }

    public String getUrl() {
        return this.url;
    }

    public NodeProxyTCP withUrl(String value) {
        String oldValue = value;
        this.url = value;
        this.firePropertyChange(PROPERTY_URL, oldValue, value);
        return this;
    }

    public NodeProxyTCP withURLPort(String url, int port) {
        this.withUrl(url);
        this.withPort(port);
        return this;
    }

    @Override
    public String getKey() {
        if (this.url == null) {
            return "server:" + this.port;
        }
        return this.url + ":" + this.port;
    }

    public Integer getPort() {
        return this.port;
    }

    public NodeProxyTCP withAllowAnswer(boolean value) {
        this.allowAnswer = value;
        return this;
    }

    public boolean isAllowAnswer() {
        return this.allowAnswer;
    }

    public NodeProxyTCP withPort(int value) {
        int oldValue = value;
        this.port = value;
        this.firePropertyChange(PROPERTY_PORT, oldValue, value);
        return this;
    }

    @Override
    public Object getValue(Object element, String attrName) {
        if (element instanceof NodeProxyTCP) {
            NodeProxyTCP nodeProxy = (NodeProxyTCP)element;
            if (PROPERTY_URL.equals(attrName)) {
                return nodeProxy.getUrl();
            }
            if (PROPERTY_PORT.equals(attrName)) {
                return nodeProxy.getPort();
            }
        }
        return super.getValue(element, attrName);
    }

    @Override
    public boolean setValue(Object element, String attrName, Object value, String type) {
        if (element instanceof NodeProxyTCP) {
            NodeProxyTCP nodeProxy = (NodeProxyTCP)element;
            if (PROPERTY_URL.equals(attrName)) {
                nodeProxy.withUrl((String)value);
                return true;
            }
            if (PROPERTY_PORT.equals(attrName)) {
                nodeProxy.withPort((Integer)value);
                return true;
            }
        }
        return super.setValue(element, attrName, value, type);
    }

    public Message readFromInputStream(Socket socket) throws IOException {
        int bytesRead;
        ByteBuffer buffer = new ByteBuffer();
        byte[] messageArray = new byte[BUFFER];
        InputStream is = socket.getInputStream();
        while (-1 != (bytesRead = is.read(messageArray, 0, BUFFER))) {
            buffer.with(new String(messageArray, 0, bytesRead, Charset.forName("UTF-8")));
            if (bytesRead == BUFFER || !this.allowAnswer) continue;
        }
        Message msg = null;
        if (this.space != null) {
            IdMap map = this.space.getMap();
            Object element = map.decode(buffer);
            this.space.updateNetwork("IN", this);
            if (element instanceof Message) {
                msg = (Message)element;
                NodeProxy receiver = msg.getReceiver();
                if (element instanceof ConnectMessage) {
                    receiver.updateReceive(buffer.size(), false);
                } else {
                    receiver.updateReceive(buffer.size(), true);
                }
                if (msg instanceof ReceivingTimerTask) {
                    ((ReceivingTimerTask)msg).withSpace(this.space);
                }
                if (receiver != null) {
                    this.space.with(receiver);
                }
            }
        }
        if (msg == null) {
            msg = new Message();
        }
        msg.withMessage(buffer.flip(false));
        msg.withSession(socket);
        msg.withAddToReceived(this);
        if (this.listener != null) {
            this.listener.update(msg);
        }
        if (this.allowAnswer) {
            this.getExecutor().handleMsg(msg);
        } else {
            socket.close();
            this.getExecutor().handleMsg(msg);
        }
        return msg;
    }

    @Override
    protected boolean sending(Message msg) {
        if (super.sending(msg)) {
            return true;
        }
        boolean success = false;
        try {
            if (this.url != null && (msg.isSendAnyHow() || this.isOnline())) {
                InetAddress addr = InetAddress.getByName(this.url);
                Socket requestSocket = new Socket(addr, this.port);
                if (msg.getTimeOut() > 0) {
                    requestSocket.setSoTimeout(msg.getTimeOut());
                } else if (this.timeOut > 0) {
                    requestSocket.setSoTimeout(this.timeOut);
                }
                OutputStream os = requestSocket.getOutputStream();
                byte[] buffer = this.space != null ? this.space.convertMessage(msg).getBytes() : msg.toString().getBytes();
                int start = 0;
                int size = BUFFER;
                while (true) {
                    int end;
                    if ((end = start + BUFFER) > buffer.length) break;
                    os.write(buffer, start, size);
                    start = end;
                }
                size = buffer.length - start;
                os.write(buffer, start, size);
                os.flush();
                if (this.allowAnswer) {
                    this.readFromInputStream(requestSocket);
                }
                this.setSendTime(buffer.length);
                requestSocket.close();
                success = true;
            }
        }
        catch (IOException ioException) {
            this.withOnline(false);
            success = false;
        }
        return success;
    }

    public boolean start() {
        return this.initProxy();
    }

    @Override
    public boolean close() {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
        return true;
    }

    @Override
    protected boolean initProxy() {
        boolean isInput = NodeProxy.isInput(this.getType());
        if (this.url == null && this.getType() == null || isInput) {
            if (this.serverSocket != null) {
                return true;
            }
            if (!isInput) {
                this.withType("IN");
            }
            this.serverSocket = new Server_TCP(this);
            if (this.url == null) {
                try {
                    String url = InetAddress.getLocalHost().getHostAddress();
                    if (!LOCALHOST.equals(url)) {
                        this.url = url;
                    }
                }
                catch (UnknownHostException unknownHostException) {}
            }
        } else {
            this.withType("OUT");
            if (this.url == null) {
                try {
                    this.url = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public boolean isSendable() {
        return this.url != null;
    }

    public static NodeProxyTCP create(String url, int port) {
        NodeProxyTCP proxy = new NodeProxyTCP().withURLPort(url, port);
        return proxy;
    }

    public static NodeProxyTCP createServer(int port) {
        NodeProxyTCP proxy = new NodeProxyTCP();
        proxy.withPort(port);
        proxy.withType("INOUT");
        return proxy;
    }

    @Override
    public NodeProxyTCP getSendableInstance(boolean reference) {
        return new NodeProxyTCP();
    }

    public NodeProxyTCP withListener(ObjectCondition condition) {
        this.listener = condition;
        this.allowAnswer = true;
        return this;
    }

    public static HTMLEntity postHTTP(String url, int port, String path, String bodyType, Object ... params) {
        String uri = NodeProxyTCP.convertPath(url, port, path);
        if (uri == null) {
            return null;
        }
        if (!(BODY_JSON.equalsIgnoreCase(bodyType) || BODY_PLAIN.equalsIgnoreCase(bodyType) || HEADER_PLAIN.equalsIgnoreCase(bodyType))) {
            return null;
        }
        HttpURLConnection conn = NodeProxyTCP.getConnection(uri, POST);
        byte[] byteArray = null;
        if (HEADER_PLAIN.equalsIgnoreCase(bodyType)) {
            for (int i = 0; i < params.length; i += 2) {
                conn.setRequestProperty("" + params[i], "" + params[i + 1]);
            }
        } else if (BODY_PLAIN.equalsIgnoreCase(bodyType)) {
            CharacterBuffer sb = new CharacterBuffer();
            NodeProxyTCP.convertParams(sb, params);
            byteArray = sb.toBytes(new boolean[0]);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        } else if (BODY_JSON.equalsIgnoreCase(bodyType)) {
            JsonObject json = new JsonObject();
            NodeProxyTCP.convertParams(json, params);
            byteArray = json.toString().getBytes();
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        }
        conn.setFixedLengthStreamingMode(byteArray.length);
        try {
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(byteArray);
            return NodeProxyTCP.readAnswer(conn);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static HTMLEntity getHTTP(HTMLEntity session, String path, Object ... params) {
        String uri;
        if (session == null) {
            return null;
        }
        CharacterBuffer buffer = new CharacterBuffer();
        buffer.add(session.getConnectionHeader("remote"));
        if (path != null) {
            if (path.startsWith("/")) {
                buffer.with(path);
            } else {
                buffer.with('/');
                buffer.with(path);
            }
        }
        if (params != null && params.length > 0) {
            buffer.add("?");
            NodeProxyTCP.convertParams(buffer, params);
        }
        if ((uri = buffer.toString()) == null) {
            return null;
        }
        HttpURLConnection conn = NodeProxyTCP.getConnection(uri, GET);
        List<String> cookies = session.getConnectionHeaders("Set-Cookie");
        if (cookies != null) {
            for (int i = 0; i < cookies.size(); ++i) {
                String cookie = cookies.get(i).substring(0, cookies.get(i).indexOf(59));
                conn.setRequestProperty("Cookie", cookie);
            }
        }
        try {
            conn.connect();
            return NodeProxyTCP.readAnswer(conn);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static HTMLEntity postHTTP(HTMLEntity session, String path, String bodyType, Object ... params) {
        String uri;
        if (session == null) {
            return null;
        }
        CharacterBuffer buffer = new CharacterBuffer();
        buffer.add(session.getConnectionHeader("remote"));
        if (path != null) {
            if (path.startsWith("/")) {
                buffer.with(path);
            } else {
                buffer.with('/');
                buffer.with(path);
            }
        }
        if ((uri = buffer.toString()) == null) {
            return null;
        }
        if (!(BODY_JSON.equalsIgnoreCase(bodyType) || BODY_PLAIN.equalsIgnoreCase(bodyType) || HEADER_PLAIN.equalsIgnoreCase(bodyType))) {
            return null;
        }
        HttpURLConnection conn = NodeProxyTCP.getConnection(uri, POST);
        List<String> cookies = session.getConnectionHeaders("Set-Cookie");
        if (cookies != null) {
            for (int i = 0; i < cookies.size(); ++i) {
                String cookie = cookies.get(i).substring(0, cookies.get(i).indexOf(59));
                conn.setRequestProperty("Cookie", cookie);
            }
        }
        byte[] byteArray = null;
        if (HEADER_PLAIN.equalsIgnoreCase(bodyType)) {
            for (int i = 0; i < params.length; i += 2) {
                conn.setRequestProperty("" + params[i], "" + params[i + 1]);
            }
        } else if (BODY_PLAIN.equalsIgnoreCase(bodyType)) {
            CharacterBuffer sb = new CharacterBuffer();
            if (params != null && params.length == 1) {
                sb.with(params[0].toString());
            } else {
                NodeProxyTCP.convertParams(sb, params);
            }
            byteArray = sb.toBytes(new boolean[0]);
            conn.setRequestProperty("Content-Type", "text/plain");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", "" + byteArray.length);
        } else if (BODY_JSON.equalsIgnoreCase(bodyType)) {
            JsonObject json = new JsonObject();
            NodeProxyTCP.convertParams(json, params);
            byteArray = json.toString().getBytes();
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        }
        if (byteArray != null) {
            conn.setFixedLengthStreamingMode(byteArray.length);
        }
        try {
            conn.connect();
            if (byteArray != null) {
                OutputStream os = conn.getOutputStream();
                os.write(byteArray);
            }
            return NodeProxyTCP.readAnswer(conn);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static BaseItem convertParams(BaseItem result, Object ... params) {
        block4: {
            block3: {
                if (params == null || params.length < 1) {
                    return result;
                }
                if (!(params[0] instanceof Map)) break block3;
                Map map = (Map)params[0];
                Set keySet = map.keySet();
                for (Object key : keySet) {
                    NodeProxyTCP.addToList(result, "" + key, "" + map.get(key));
                }
                break block4;
            }
            if (params.length % 2 != 0) break block4;
            for (int i = 0; i < params.length; i += 2) {
                NodeProxyTCP.addToList(result, "" + params[i], "" + params[i + 1]);
            }
        }
        return result;
    }

    private static void addToList(BaseItem params, String key, String value) {
        if (params instanceof CharacterBuffer) {
            if (params.size() > 0) {
                params.add(Character.valueOf('&'));
            }
            params.add(key, "=", value);
        } else {
            params.add(key, value);
        }
    }

    public static HTMLEntity postHTTP(String url, Map<String, String> params) {
        HttpURLConnection conn = NodeProxyTCP.getConnection(url, POST);
        if (conn == null) {
            return null;
        }
        CharacterBuffer sb = new CharacterBuffer();
        NodeProxyTCP.convertParams(sb, params);
        byte[] byteArray = sb.toBytes(new boolean[0]);
        conn.setFixedLengthStreamingMode(byteArray.length);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        try {
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(byteArray);
            return NodeProxyTCP.readAnswer(conn);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static HTMLEntity postHTTP(String url, BaseItem params) {
        HttpURLConnection conn = NodeProxyTCP.getConnection(url, POST);
        if (conn == null) {
            return null;
        }
        CharacterBuffer sb = new CharacterBuffer();
        if (params != null) {
            sb.with(params.toString());
        }
        byte[] byteArray = sb.toBytes(new boolean[0]);
        conn.setFixedLengthStreamingMode(byteArray.length);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        try {
            conn.connect();
            OutputStream os = conn.getOutputStream();
            os.write(byteArray);
            return NodeProxyTCP.readAnswer(conn);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static HttpURLConnection getConnection(String url, String type) {
        HttpURLConnection conn = null;
        try {
            if (((String)url).startsWith("localhost")) {
                url = "http://" + (String)url;
            }
            URL remoteURL = new URL((String)url);
            conn = (HttpURLConnection)remoteURL.openConnection();
            if (POST.equals(type)) {
                conn.setRequestMethod(POST);
                conn.setDoOutput(true);
            } else {
                conn.setRequestMethod(GET);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return conn;
    }

    private static HTMLEntity readAnswer(HttpURLConnection conn) {
        HTMLEntity rootItem = new HTMLEntity();
        if (conn == null) {
            return rootItem;
        }
        try {
            int bytesRead;
            rootItem.withStatus(conn.getResponseCode(), conn.getResponseMessage());
            String uri = conn.getURL().toString();
            String path = conn.getURL().getPath();
            if (uri.length() > path.length()) {
                uri = uri.substring(0, uri.length() - path.length());
            }
            rootItem.withConnectionHeader("remote", uri);
            rootItem.withConnectionHeader(conn.getHeaderFields());
            InputStream is = conn.getInputStream();
            CharacterBuffer sb = new CharacterBuffer();
            byte[] messageArray = new byte[BUFFER];
            while ((bytesRead = is.read(messageArray, 0, BUFFER)) > 0) {
                sb.add(new String(messageArray, 0, bytesRead, Charset.forName("UTF-8")));
            }
            rootItem.with(sb);
        }
        catch (IOException e) {
            InputStream is = conn.getErrorStream();
            byte[] messageArray = new byte[BUFFER];
            CharacterBuffer sb = new CharacterBuffer();
            try {
                int bytesRead;
                while ((bytesRead = is.read(messageArray, 0, BUFFER)) > 0) {
                    sb.add(new String(messageArray, 0, bytesRead, Charset.forName("UTF-8")));
                }
                rootItem.with(sb);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        conn.disconnect();
        return rootItem;
    }

    public static String convertPath(String url, int port, String path) {
        if (url == null) {
            return null;
        }
        CharacterBuffer buffer = new CharacterBuffer();
        if (url.toLowerCase().startsWith("http")) {
            buffer.with(url);
        } else {
            buffer.with("http://" + url);
        }
        if (buffer.indexOf(58, 6) < 1) {
            buffer.with(':');
            buffer.with(port);
        }
        if (path != null) {
            if (path.startsWith("/")) {
                buffer.with(path);
            } else {
                buffer.with('/');
                buffer.with(path);
            }
        }
        return buffer.toString();
    }

    public static HTMLEntity getHTTP(String url, int port, String path) {
        String uri = NodeProxyTCP.convertPath(url, port, path);
        if (uri == null) {
            return null;
        }
        return NodeProxyTCP.getHTTP(url);
    }

    public static HTMLEntity getHTTP(String url) {
        HttpURLConnection conn = NodeProxyTCP.getConnection(url, GET);
        if (conn == null) {
            return null;
        }
        return NodeProxyTCP.readAnswer(conn);
    }

    public String toString() {
        if (this.url != null && this.port > 0) {
            return this.getClass().getSimpleName() + " " + this.url + ":" + this.port;
        }
        return super.toString();
    }

    public NodeProxyTCP withTimeOut(int value) {
        this.timeOut = value;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.port > 0;
    }
}

