/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.messages.ChangeMessage;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyMessages;
import de.uniks.networkparser.ext.sql.SQLStatement;
import de.uniks.networkparser.ext.sql.SQLStatementList;
import de.uniks.networkparser.ext.sql.SQLTokener;
import java.sql.Connection;

public class NodeProxySQL
extends NodeProxy {
    public static final String PROPERTY_DATABASE = "database";
    public static final String PROPERTY_DRIVER = "driver";
    private String database;
    private String driver;
    private SQLTokener tokener;

    public NodeProxySQL() {
        this.property.addAll(PROPERTY_DATABASE, PROPERTY_DRIVER);
        this.propertyInfo.addAll(PROPERTY_DATABASE, PROPERTY_DRIVER);
        this.propertyUpdate.addAll(PROPERTY_DATABASE, PROPERTY_DRIVER);
    }

    @Override
    public Object getValue(Object element, String attrName) {
        if (element instanceof NodeProxySQL) {
            NodeProxySQL nodeProxy = (NodeProxySQL)element;
            if (PROPERTY_DATABASE.equals(attrName)) {
                return nodeProxy.getDataBase();
            }
            if (PROPERTY_DRIVER.equals(attrName)) {
                return nodeProxy.getDriver();
            }
        }
        return super.getValue(element, attrName);
    }

    public NodeProxySQL withConnection(Connection con) {
        this.initTokener(con);
        return this;
    }

    public String getDataBase() {
        return this.database;
    }

    public String getDriver() {
        return this.driver;
    }

    public NodeProxySQL withDriver(String value) {
        this.driver = value;
        return this;
    }

    private NodeProxySQL withDatabase(String value) {
        this.database = value;
        return this;
    }

    @Override
    public boolean setValue(Object element, String attrName, Object value, String type) {
        if (element instanceof NodeProxyMessages) {
            NodeProxySQL nodeProxy = (NodeProxySQL)element;
            if (PROPERTY_DATABASE.equals(attrName)) {
                nodeProxy.withDatabase((String)value);
                return true;
            }
            if (PROPERTY_DRIVER.equals(attrName)) {
                nodeProxy.withDriver((String)value);
                return true;
            }
        }
        return super.setValue(element, attrName, value, type);
    }

    @Override
    public int compareTo(NodeProxy o) {
        return 0;
    }

    @Override
    public String getKey() {
        return this.database;
    }

    @Override
    public boolean close() {
        if (this.tokener != null) {
            return this.tokener.close();
        }
        return true;
    }

    @Override
    protected boolean initProxy() {
        this.withType("INOUT");
        return true;
    }

    @Override
    public boolean isSendable() {
        return this.driver != null;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new NodeProxySQL();
    }

    public void initTokener(Connection con) {
        String[] split;
        if (this.tokener == null && (split = this.driver.split(":")).length > 2) {
            this.tokener = new SQLTokener(SQLStatement.connect(split[0], split[1], split[2]));
            this.database = split[2];
        }
        if (con != null) {
            this.tokener.withConnection(con);
        } else if (this.tokener.getConnection() == null) {
            Connection connection = ReflectionLoader.loadSQLDriver(this.driver, this.database);
            this.tokener.withConnection(connection);
        }
    }

    @Override
    protected boolean sending(Message msg) {
        if (super.sending(msg)) {
            return true;
        }
        if (this.driver == null) {
            return false;
        }
        this.initTokener(null);
        SQLStatementList statements = null;
        if (msg instanceof ChangeMessage) {
            ChangeMessage cm = (ChangeMessage)msg;
            Object entity = cm.getEntity();
            String property = cm.getProperty();
            Object newValue = cm.getNewValue();
            String id = cm.getId();
            statements = this.tokener.update(entity, id, property, newValue);
        }
        if (statements != null) {
            this.tokener.executeStatements(statements);
        }
        return super.sending(msg);
    }
}

