/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.messages;

import de.uniks.networkparser.ext.petaf.ModelChange;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.ReceivingTimerTask;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.messages.AcceptMessage;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SortedSet;

public class InfoMessage
extends ReceivingTimerTask {
    public static final String PROPERTY_PROXIES = "proxies";
    public static final String PROPERTY_LASTID = "history_id";

    public InfoMessage() {
        props.add(PROPERTY_PROXIES, PROPERTY_LASTID);
    }

    public static InfoMessage create(Space space) {
        InfoMessage msg = new InfoMessage();
        msg.withSpace(space);
        return msg;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (attribute == null || !(entity instanceof AcceptMessage)) {
            return null;
        }
        AcceptMessage message = (AcceptMessage)entity;
        Space space = message.getSpace();
        if (space != null) {
            ModelChange lastModelChange;
            if (PROPERTY_PROXIES.equalsIgnoreCase(attribute)) {
                SimpleList<NodeProxy> candidates = new SimpleList<NodeProxy>();
                SortedSet<NodeProxy> nodeProxies = space.getNodeProxies(new ObjectCondition[0]);
                for (NodeProxy proxy : nodeProxies) {
                    if (!proxy.isSendable()) continue;
                    candidates.add(proxy);
                }
                return candidates;
            }
            if (PROPERTY_LASTID.equalsIgnoreCase(attribute) && (lastModelChange = space.getHistory().getLastModelChange()) != null) {
                return lastModelChange.getKey();
            }
        }
        return super.getValue(entity, attribute);
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new InfoMessage();
    }
}

