/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.messages;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.UpdateAccumulate;
import de.uniks.networkparser.ext.petaf.ReceivingTimerTask;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyModel;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;

public class ChangeMessage
extends ReceivingTimerTask {
    public static final String PROPERTY_TYPE = "change";
    public static final String PROPERTY_ID = "changeid";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_OLD = "old";
    public static final String PROPERTY_NEW = "new";
    public static final String PROPERTY_CHANGECLASS = "changeclass";
    private Object entity;
    private Filter filter;
    private String property;
    private String id;
    private Object oldValue;
    private Object newValue;

    public ChangeMessage() {
        props.add(PROPERTY_ID, PROPERTY_PROPERTY, PROPERTY_OLD, PROPERTY_NEW, PROPERTY_CHANGECLASS);
    }

    public ChangeMessage withEntity(Object value) {
        this.entity = value;
        return this;
    }

    public ChangeMessage withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public ChangeMessage withValue(String property, Object oldValue, Object newValue) {
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
        return this;
    }

    public ChangeMessage withValue(SimpleEvent event) {
        this.property = event.getPropertyName();
        this.oldValue = event.getOldValue();
        this.newValue = event.getNewValue();
        this.entity = event.getModelValue();
        return this;
    }

    @Override
    public BaseItem getMessage() {
        if (this.msg == null && this.space != null && this.property == null) {
            this.msg = this.space.encode(this.entity, this.filter);
        }
        return super.getMessage();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean runTask() throws Exception {
        Object currentValue;
        if (this.id == null || this.space == null) {
            return false;
        }
        IdMap map = this.space.getMap();
        Object element = map.getObject(this.id);
        SendableEntityCreator creator = null;
        if (element == null) {
            if (this.entity instanceof String) {
                String className = (String)this.entity;
                creator = map.getCreator(className, true);
                element = creator.getSendableInstance(true);
                map.put(this.id, element, false);
                this.space.createModel(element);
            }
        } else {
            creator = map.getCreatorClass(element);
        }
        if (element != null && creator != null && ((currentValue = creator.getValue(element, this.property)) == null && this.oldValue == null || currentValue != null && currentValue.equals(this.oldValue))) {
            UpdateAccumulate changeMessage = new UpdateAccumulate();
            changeMessage.withTarget(element, creator, this.property);
            this.space.suspendNotification(changeMessage);
            creator.setValue(element, this.property, this.newValue, "upd");
            this.space.resetNotification();
        }
        return super.runTask();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        Space space;
        if (attribute == null || !(entity instanceof ChangeMessage)) {
            return false;
        }
        ChangeMessage message = (ChangeMessage)entity;
        if (PROPERTY_OLD.equalsIgnoreCase(attribute)) {
            return message.oldValue;
        }
        if (PROPERTY_NEW.equalsIgnoreCase(attribute)) {
            return message.newValue;
        }
        if (PROPERTY_PROPERTY.equalsIgnoreCase(attribute)) {
            return message.property;
        }
        if (PROPERTY_CHANGECLASS.equalsIgnoreCase(attribute)) {
            if (message.entity == null) {
                return null;
            }
            return message.entity.getClass().getName();
        }
        if (entity != null && PROPERTY_ID.equalsIgnoreCase(attribute) && (space = message.getSpace()) != null) {
            return space.getId(message.entity);
        }
        return super.getValue(entity, attribute);
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (attribute == null || !(entity instanceof ChangeMessage)) {
            return false;
        }
        ChangeMessage message = (ChangeMessage)entity;
        if (PROPERTY_OLD.equalsIgnoreCase(attribute)) {
            message.oldValue = value;
            return true;
        }
        if (PROPERTY_NEW.equalsIgnoreCase(attribute)) {
            message.newValue = value;
            return true;
        }
        if (PROPERTY_PROPERTY.equalsIgnoreCase(attribute)) {
            message.property = (String)value;
            return true;
        }
        if (PROPERTY_ID.equalsIgnoreCase(attribute)) {
            message.id = (String)value;
            return true;
        }
        if (PROPERTY_CHANGECLASS.equalsIgnoreCase(attribute)) {
            message.entity = (String)value;
            return true;
        }
        return super.setValue(entity, attribute, value, type);
    }

    protected void initialize(NodeProxyModel modell) {
        if (modell == null) {
            return;
        }
        if (this.space == null) {
            this.space = modell.getSpace();
        }
        if (this.entity == null) {
            this.entity = modell.getModel();
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    @Override
    public ChangeMessage getSendableInstance(boolean prototyp) {
        return new ChangeMessage().withFilter(this.filter);
    }

    @Override
    public String getType() {
        return PROPERTY_TYPE;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public String getProperty() {
        return this.property;
    }
}

